/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.config.ConfigImpl;
import com.seleritycorp.common.base.config.PrefixedConfig;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;

public class ConfigUtils {
    private static final Log log = LogFactory.getLog(ConfigUtils.class);

    private static String addToKey(String key, String addendum) {
        String ret = key;
        if (ret == null) {
            ret = "";
        }
        if (!ret.equals("")) {
            ret = ret + ".";
        }
        ret = ret + addendum;
        return ret;
    }

    private static ConfigImpl loadProperties(Path path) throws IOException {
        ConfigImpl ret;
        try (FileInputStream stream = new FileInputStream(path.toFile());
             InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
            ret = ConfigUtils.loadProperties(reader);
        }
        return ret;
    }

    private static ConfigImpl loadProperties(Reader reader) throws IOException {
        ConfigImpl ret = new ConfigImpl();
        Properties properties = new Properties();
        properties.load(reader);
        for (String key : properties.stringPropertyNames()) {
            ret.set(key, properties.getProperty(key));
        }
        return ret;
    }

    private static ConfigImpl loadJson(Path path) throws IOException {
        ConfigImpl ret;
        try (FileInputStream stream = new FileInputStream(path.toFile());
             InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
            ret = ConfigUtils.loadJson(reader);
        }
        return ret;
    }

    private static ConfigImpl loadJson(Reader reader) {
        ConfigImpl ret = new ConfigImpl();
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(reader);
        ConfigUtils.loadJson(element, ret, "");
        return ret;
    }

    private static void loadJson(JsonElement element, ConfigImpl config, String key) {
        if (element.isJsonObject()) {
            ConfigUtils.loadJson(element.getAsJsonObject(), config, key);
        } else if (element.isJsonArray()) {
            ConfigUtils.loadJson(element.getAsJsonArray(), config, key);
        } else if (element.isJsonPrimitive()) {
            ConfigUtils.loadJson(element.getAsJsonPrimitive(), config, key);
        } else if (!element.isJsonNull()) {
            throw new UnsupportedOperationException("Unimplemented JsonElement state");
        }
    }

    private static void loadJson(JsonObject object, ConfigImpl config, String key) {
        for (Map.Entry entry : object.entrySet()) {
            String newKey = ConfigUtils.addToKey(key, (String)entry.getKey());
            ConfigUtils.loadJson((JsonElement)entry.getValue(), config, newKey);
        }
    }

    private static void loadJson(JsonArray array, ConfigImpl config, String key) {
        int index = 0;
        for (JsonElement element : array) {
            String newKey = ConfigUtils.addToKey(key, Integer.toString(index));
            ConfigUtils.loadJson(element, config, newKey);
            ++index;
        }
    }

    private static void loadJson(JsonPrimitive primitive, ConfigImpl config, String key) {
        String value = null;
        if (primitive.isBoolean()) {
            boolean bool = primitive.getAsBoolean();
            value = bool ? "true" : "false";
        } else if (primitive.isString()) {
            value = primitive.getAsString();
        } else if (primitive.isNumber()) {
            value = Double.toString(primitive.getAsDouble());
        }
        config.set(key, value);
    }

    static ConfigImpl load(Path source) {
        log.info("Loading config from " + source);
        ConfigImpl ret = null;
        if (Files.exists(source, new LinkOption[0])) {
            try {
                try {
                    ret = ConfigUtils.loadJson(source);
                }
                catch (JsonParseException e) {
                    ret = ConfigUtils.loadProperties(source);
                }
            }
            catch (IOException e) {
                log.info("Failed to load config file " + source + ". Assuming empty config", e);
            }
        } else {
            log.info("Config source " + source + " not found. Assuming empty config");
        }
        if (ret == null) {
            ret = new ConfigImpl();
        }
        return ret;
    }

    public static Config subconfig(Config config, String prefix) {
        return new PrefixedConfig(config, prefix);
    }
}

