/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.config;

import com.seleritycorp.common.base.config.Config;
import java.util.concurrent.TimeUnit;

public class PrefixedConfig
implements Config {
    private final String prefix;
    private final Config config;

    PrefixedConfig(Config config, String prefix) {
        this.config = config;
        this.prefix = prefix + ".";
    }

    @Override
    public String get(String key) {
        return this.config.get(this.prefix + key);
    }

    @Override
    public String get(String key, String defaultValue) {
        return this.config.get(this.prefix + key, defaultValue);
    }

    @Override
    public int getInt(String key) {
        return this.config.getInt(this.prefix + key);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.config.getInt(this.prefix + key, defaultValue);
    }

    @Override
    public long getLong(String key) {
        return this.config.getLong(this.prefix + key);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.config.getLong(this.prefix + key, defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return this.config.getFloat(this.prefix + key);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.config.getFloat(this.prefix + key, defaultValue);
    }

    @Override
    public double getDouble(String key) {
        return this.config.getDouble(this.prefix + key);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.config.getDouble(this.prefix + key, defaultValue);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.config.getBoolean(this.prefix + key);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.config.getBoolean(this.prefix + key, defaultValue);
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> clazz, String key) {
        return this.config.getEnum(clazz, this.prefix + key);
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> clazz, String key, T defaultValue) {
        return this.config.getEnum(clazz, this.prefix + key, defaultValue);
    }

    @Override
    public long getDurationMillis(String key) {
        return this.config.getDurationMillis(this.prefix + key);
    }

    @Override
    public long getDurationMillis(String key, long defaultDuration) {
        return this.config.getDurationMillis(this.prefix + key, defaultDuration);
    }

    @Override
    public long getDurationMillis(String key, long defaultDuration, TimeUnit defaultUnit) {
        return this.config.getDurationMillis(this.prefix + key, defaultDuration, defaultUnit);
    }

    @Override
    public long getDurationSeconds(String key) {
        return this.config.getDurationSeconds(this.prefix + key);
    }

    @Override
    public long getDurationSeconds(String key, long defaultDuration) {
        return this.config.getDurationSeconds(this.prefix + key, defaultDuration);
    }

    @Override
    public long getDurationSeconds(String key, long defaultDuration, TimeUnit defaultUnit) {
        return this.config.getDurationSeconds(this.prefix + key, defaultDuration, defaultUnit);
    }
}

