/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.coreservices;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.config.ConfigUtils;
import com.seleritycorp.common.base.coreservices.CallErrorException;
import com.seleritycorp.common.base.http.client.HttpException;
import com.seleritycorp.common.base.http.client.HttpRequestFactory;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import com.seleritycorp.common.base.meta.MetaDataFormatter;
import com.seleritycorp.common.base.uuid.UuidGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RawCoreServiceClient {
    private static final Log log = LogFactory.getLog(RawCoreServiceClient.class);
    private final UuidGenerator uuidGenerator;
    private final String apiUrl;
    private final int timeoutMillis;
    private final String user;
    private final String client;
    private final HttpRequestFactory requestFactory;
    private final GsonBuilder gsonBuilder;
    private static final int BUFFER_SIZE = 0x800000;

    @Inject
    public RawCoreServiceClient(@ApplicationConfig Config appConfig, UuidGenerator uuidGenerator, MetaDataFormatter metaDataFormatter, HttpRequestFactory requestFactory) {
        this.uuidGenerator = uuidGenerator;
        Config config = ConfigUtils.subconfig(appConfig, "CoreServices");
        this.apiUrl = config.get("url");
        this.user = config.get("user");
        this.timeoutMillis = (int)config.getDurationMillis("timeout", 300L, TimeUnit.SECONDS);
        this.client = metaDataFormatter.getUserAgent();
        this.requestFactory = requestFactory;
        this.gsonBuilder = new GsonBuilder();
    }

    JsonElement call(String method, JsonElement params, String token, int timeoutMillis) throws HttpException, CallErrorException {
        JsonObject header = new JsonObject();
        header.addProperty("user", this.user);
        if (token != null) {
            header.addProperty("token", token);
        }
        header.addProperty("client", this.client);
        JsonObject request = new JsonObject();
        request.addProperty("id", this.uuidGenerator.generate().toString());
        request.addProperty("method", method);
        request.add("params", params);
        request.add("header", (JsonElement)header);
        int effectiveTimeoutMillis = timeoutMillis > 0 ? timeoutMillis : this.timeoutMillis;
        log.debug("Calling method " + method + " (user: " + this.user + ")");
        JsonObject responseObj = this.requestFactory.createPostJson(this.apiUrl, request).setReadTimeoutMillis(effectiveTimeoutMillis).execute().getBodyAsJsonObject();
        log.debug("Method " + method + " done (user: " + this.user + ")");
        JsonElement error = responseObj.get("error");
        if (error != null && !error.isJsonNull()) {
            throw new CallErrorException("Error: " + error.toString());
        }
        return responseObj.get("result");
    }

    void call(String method, JsonElement params, String token, int timeoutMillis, JsonWriter writer) throws HttpException, CallErrorException {
        JsonObject header = new JsonObject();
        header.addProperty("user", this.user);
        if (token != null) {
            header.addProperty("token", token);
        }
        header.addProperty("client", this.client);
        JsonObject request = new JsonObject();
        request.addProperty("id", this.uuidGenerator.generate().toString());
        request.addProperty("method", method);
        request.add("params", params);
        request.add("header", (JsonElement)header);
        int effectiveTimeoutMillis = timeoutMillis > 0 ? timeoutMillis : this.timeoutMillis;
        log.debug("Calling method " + method + " (user: " + this.user + ")");
        InputStream responseStream = this.requestFactory.createPostJson(this.apiUrl, request).setReadTimeoutMillis(effectiveTimeoutMillis).executeAndStream().getBodyAsStream();
        log.debug("Method " + method + " done (user: " + this.user + ")");
        if (responseStream == null) {
            log.info("Empty response while executing request to " + this.apiUrl);
            return;
        }
        JsonObject errorObject = null;
        try (JsonReader reader = this.getJsonReader(responseStream);){
            if (reader.hasNext()) {
                if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                    reader.beginObject();
                    while (reader.peek() != JsonToken.END_OBJECT) {
                        String name = reader.nextName();
                        if ("error".equals(name)) {
                            if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                                errorObject = (JsonObject)this.gsonBuilder.create().fromJson(reader, JsonObject.class);
                                continue;
                            }
                            reader.skipValue();
                            continue;
                        }
                        if ("result".equals(name)) {
                            this.pushToWriter(reader, writer);
                            continue;
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                } else {
                    log.warn("Response received is not a JSON object, ignoring. Requsest:" + this.apiUrl);
                }
            } else {
                log.warn("Received empty response while executing the request to " + this.apiUrl);
            }
        }
        catch (IOException e) {
            throw new HttpException("Failed to execute request to '" + this.apiUrl + "'", e);
        }
        if (errorObject != null && !errorObject.isJsonNull()) {
            throw new CallErrorException("Error: " + errorObject.toString());
        }
    }

    JsonReader getJsonReader(InputStream stream) {
        return new JsonReader((Reader)new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8), 0x800000));
    }

    private void pushToWriter(JsonReader reader, JsonWriter writer) throws IOException {
        int count = 0;
        boolean isObject = reader.peek() == JsonToken.BEGIN_OBJECT;
        block12: do {
            JsonToken jsToken = reader.peek();
            switch (jsToken) {
                case BEGIN_ARRAY: {
                    reader.beginArray();
                    writer.beginArray();
                    if (isObject) continue block12;
                    ++count;
                    break;
                }
                case END_ARRAY: {
                    reader.endArray();
                    writer.endArray();
                    if (isObject) continue block12;
                    --count;
                    break;
                }
                case BEGIN_OBJECT: {
                    reader.beginObject();
                    writer.beginObject();
                    if (!isObject) continue block12;
                    ++count;
                    break;
                }
                case END_OBJECT: {
                    reader.endObject();
                    writer.endObject();
                    if (!isObject) continue block12;
                    --count;
                    break;
                }
                case NAME: {
                    String name = reader.nextName();
                    writer.name(name);
                    break;
                }
                case STRING: {
                    String stringValue = reader.nextString();
                    writer.value(stringValue);
                    break;
                }
                case NUMBER: {
                    String numValue = reader.nextString();
                    writer.value((Number)new BigDecimal(numValue));
                    break;
                }
                case BOOLEAN: {
                    boolean boolValue = reader.nextBoolean();
                    writer.value(boolValue);
                    break;
                }
                case NULL: {
                    reader.nextNull();
                    writer.nullValue();
                    break;
                }
                case END_DOCUMENT: {
                    return;
                }
                default: {
                    return;
                }
            }
        } while (count != 0);
    }
}

