/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.coreservices;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.coreservices.CallErrorException;
import com.seleritycorp.common.base.coreservices.RawAuthenticatedCoreServiceClient;
import com.seleritycorp.common.base.http.client.HttpException;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RefDataClient {
    private static final Log log = LogFactory.getLog(RefDataClient.class);
    private final RawAuthenticatedCoreServiceClient client;
    private final int timeoutMillis;

    @Inject
    public RefDataClient(RawAuthenticatedCoreServiceClient client, @ApplicationConfig Config config) {
        this.client = client;
        this.timeoutMillis = (int)config.getDurationMillis("RefDataClient.timeout", 1200L, TimeUnit.SECONDS);
    }

    public JsonElement getIdentifiersForEnumType(String enumType) throws HttpException, CallErrorException {
        JsonArray params = new JsonArray();
        params.add(enumType);
        log.debug("Getting identifiers for enum type " + enumType + " (timeout: " + this.timeoutMillis + "ms)");
        JsonElement ret = this.client.authenticatedCall("RefDataHandler.getIdentifiersForEnumType", (JsonElement)params, this.timeoutMillis);
        log.debug("Getting identifiers for enum type " + enumType + " done");
        return ret;
    }

    public void getIdentifiersForEnumType(String enumType, JsonWriter writer) throws HttpException, CallErrorException {
        JsonArray params = new JsonArray();
        params.add(enumType);
        log.debug("Getting identifiers for enum type " + enumType + " (timeout: " + this.timeoutMillis + "ms)");
        this.client.authenticatedCall("RefDataHandler.getIdentifiersForEnumType", (JsonElement)params, this.timeoutMillis, writer);
        log.debug("Getting identifiers for enum type " + enumType + " done");
    }
}

