/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.eventprocessor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.http.client.HttpException;
import com.seleritycorp.common.base.http.client.HttpRequestFactory;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import com.seleritycorp.common.base.uuid.UuidGenerator;
import java.util.UUID;
import javax.inject.Inject;

public class EventSender {
    private static final Log log = LogFactory.getLog(EventSender.class);
    private final UuidGenerator uuidGenerator;
    private final String targetUrl;
    private final HttpRequestFactory requestFactory;

    @Inject
    public EventSender(@ApplicationConfig Config config, UuidGenerator uuidGenerator, HttpRequestFactory requestFactory) {
        this.uuidGenerator = uuidGenerator;
        this.targetUrl = config.get("EventProcessor.beaconUrl", "https://event.seleritycorp.com/beacon");
        this.requestFactory = requestFactory;
    }

    public UUID send(String schema, int schemaVersion, JsonObject payload) {
        UUID uuid = this.uuidGenerator.generate();
        try {
            this.sendChecked(uuid, schema, schemaVersion, payload);
        }
        catch (Exception e) {
            log.info("Failed to send beacon for " + schema + " (version " + schemaVersion + ") to " + this.targetUrl, e);
        }
        return uuid;
    }

    public UUID sendChecked(String schema, int schemaVersion, JsonObject payload) throws HttpException {
        UUID uuid = this.uuidGenerator.generate();
        this.sendChecked(uuid, schema, schemaVersion, payload);
        return uuid;
    }

    private void sendChecked(UUID uuid, String schema, int schemaVersion, JsonObject payload) throws HttpException {
        JsonObject data = new JsonObject();
        data.addProperty("schema", schema);
        data.addProperty("schemaVersion", (Number)schemaVersion);
        data.addProperty("uuid", uuid.toString());
        data.add("payload", (JsonElement)payload);
        this.requestFactory.createPostJson(this.targetUrl, data).setExpectedStatusCode(204).execute();
    }
}

