/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HttpContext;

@Singleton
public class FileHttpClient
extends CloseableHttpClient {
    private HttpParams httpParams = null;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="connectionManager is thread safe. We use synchronization only to avoid loading it twice")
    private ClientConnectionManager connectionManager = null;
    private ProtocolVersion protocolVersion = new ProtocolVersion("FILE", 0, 1);

    @Inject
    public FileHttpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DC_DOUBLECHECK"}, justification="Outer check is quick and unsynchronized. Inner check is synchronized")
    public synchronized HttpParams getParams() {
        if (this.httpParams == null) {
            FileHttpClient fileHttpClient = this;
            synchronized (fileHttpClient) {
                if (this.httpParams == null) {
                    this.httpParams = new SyncBasicHttpParams();
                }
            }
        }
        return this.httpParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DC_DOUBLECHECK"}, justification="Outer check is quick and unsynchronized. Inner check is synchronized")
    public ClientConnectionManager getConnectionManager() {
        if (this.connectionManager == null) {
            FileHttpClient fileHttpClient = this;
            synchronized (fileHttpClient) {
                if (this.connectionManager == null) {
                    this.connectionManager = new BasicClientConnectionManager();
                }
            }
        }
        return this.connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FileHttpClient fileHttpClient = this;
        synchronized (fileHttpClient) {
            if (this.connectionManager != null) {
                this.connectionManager.shutdown();
            }
        }
    }

    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.doExecute(null, (HttpRequest)request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.execute(null, (HttpRequest)request, responseHandler, context);
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        StatusLine statusLine;
        byte[] content = null;
        String uri = request.getRequestLine().getUri();
        if (uri.startsWith("file://")) {
            File file = new File(URI.create(uri));
            uri = file.getAbsolutePath();
        }
        Path path = Paths.get(uri, new String[0]);
        if (request instanceof HttpGet) {
            if (Files.exists(path, new LinkOption[0])) {
                if (Files.isReadable(path)) {
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        content = Files.readAllBytes(path);
                        statusLine = this.createStatusLine(200, "OK");
                    } else {
                        statusLine = this.createStatusLine(400, "Bad Request");
                    }
                } else {
                    statusLine = this.createStatusLine(403, "Forbidden");
                }
            } else {
                statusLine = this.createStatusLine(404, "Not Found");
            }
        } else {
            statusLine = this.createStatusLine(400, "Bad Request");
        }
        FileHttpClientResponse response = new FileHttpClientResponse(statusLine);
        if (content != null) {
            response.setEntity((HttpEntity)new ByteArrayEntity(content));
        }
        return response;
    }

    private StatusLine createStatusLine(int statusCode, String reason) {
        return new BasicStatusLine(this.protocolVersion, statusCode, reason);
    }

    private static class FileHttpClientResponse
    extends BasicHttpResponse
    implements CloseableHttpResponse {
        public FileHttpClientResponse(StatusLine statusline) {
            super(statusline);
        }

        public void close() throws IOException {
        }
    }
}

