/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.client;

import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.http.client.FileHttpClient;
import com.seleritycorp.common.base.http.client.HttpException;
import com.seleritycorp.common.base.http.client.HttpResponse;
import com.seleritycorp.common.base.http.client.HttpResponseStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class HttpRequest {
    private final String uri;
    private final HttpClient netHttpClient;
    private final HttpClient fileHttpClient;
    private final HttpResponse.Factory responseFactory;
    private final HttpResponseStream.Factory responseStreamFactory;
    private String method;
    private String userAgent;
    private int readTimeoutMillis;
    private String data;
    private ContentType contentType;
    private int expectedStatusCode;

    @Inject
    HttpRequest(@Assisted String uri, HttpClient netHttpClient, FileHttpClient fileHttpClient, HttpResponse.Factory responseFactory, HttpResponseStream.Factory responseStreamFactory) {
        this.uri = uri;
        this.netHttpClient = netHttpClient;
        this.fileHttpClient = fileHttpClient;
        this.responseFactory = responseFactory;
        this.responseStreamFactory = responseStreamFactory;
        this.method = "GET";
        this.userAgent = null;
        this.readTimeoutMillis = -1;
        this.data = "";
        this.contentType = null;
        this.expectedStatusCode = -1;
    }

    public HttpRequest setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HttpRequest setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public HttpRequest setMethodPost() {
        this.method = "POST";
        return this;
    }

    public HttpRequest addData(String data) {
        if (data != null) {
            if (!this.data.isEmpty()) {
                this.data = this.data + "&";
            }
            this.data = this.data + data;
        }
        return this;
    }

    public HttpRequest setExpectedStatusCode(int statusCode) {
        this.expectedStatusCode = statusCode;
        return this;
    }

    public HttpRequest setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    private org.apache.http.HttpResponse getHttpResponse() throws HttpException {
        org.apache.http.HttpResponse response;
        HttpGet request;
        switch (this.method) {
            case "GET": {
                request = new HttpGet();
                break;
            }
            case "POST": {
                request = new HttpPost();
                break;
            }
            default: {
                throw new HttpException("Unknown HTTP method '" + this.method + "'");
            }
        }
        try {
            request.setURI(URI.create(this.uri));
        }
        catch (IllegalArgumentException e) {
            throw new HttpException("Failed to create URI '" + this.uri + "'", e);
        }
        if (this.userAgent != null) {
            request.setHeader("User-Agent", this.userAgent);
        }
        if (this.readTimeoutMillis >= 0) {
            request.setConfig(RequestConfig.custom().setSocketTimeout(this.readTimeoutMillis).setConnectTimeout(this.readTimeoutMillis).setConnectionRequestTimeout(this.readTimeoutMillis).build());
        }
        if (!this.data.isEmpty()) {
            if (request instanceof HttpEntityEnclosingRequestBase) {
                ContentType localContentType = this.contentType;
                if (localContentType == null) {
                    localContentType = ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8);
                }
                StringEntity entity = new StringEntity(this.data, localContentType);
                HttpEntityEnclosingRequestBase entityRequest = (HttpEntityEnclosingRequestBase)request;
                entityRequest.setEntity((HttpEntity)entity);
            } else {
                throw new HttpException("Request " + request.getMethod() + " does not allow to send data with the request");
            }
        }
        HttpClient httpClient = this.uri.startsWith("file://") ? this.fileHttpClient : this.netHttpClient;
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new HttpException("Failed to execute request to '" + this.uri + "'", e);
        }
        return response;
    }

    public HttpResponse execute() throws HttpException {
        int statusCode;
        org.apache.http.HttpResponse response = this.getHttpResponse();
        HttpResponse ret = this.responseFactory.create(response);
        if (this.expectedStatusCode >= 0 && (statusCode = ret.getStatusCode()) != this.expectedStatusCode) {
            throw new HttpException("Expected status code " + this.expectedStatusCode + " for call to '" + this.uri + "', but was " + statusCode);
        }
        return ret;
    }

    public HttpResponseStream executeAndStream() throws HttpException {
        int statusCode;
        org.apache.http.HttpResponse response = this.getHttpResponse();
        HttpResponseStream ret = this.responseStreamFactory.create(response);
        if (this.expectedStatusCode >= 0 && (statusCode = ret.getStatusCode()) != this.expectedStatusCode) {
            throw new HttpException("Expected status code " + this.expectedStatusCode + " for call to '" + this.uri + "', but was " + statusCode);
        }
        return ret;
    }

    static interface Factory {
        public HttpRequest create(String var1);
    }
}

