/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.client;

import com.google.gson.JsonObject;
import com.seleritycorp.common.base.http.client.HttpRequest;
import com.seleritycorp.common.base.meta.MetaDataFormatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.http.entity.ContentType;

@Singleton
public class HttpRequestFactory {
    private final HttpRequest.Factory requestFactory;
    private final String userAgent;

    @Inject
    HttpRequestFactory(HttpRequest.Factory requestFactory, MetaDataFormatter metaDataFormatter) {
        this.requestFactory = requestFactory;
        this.userAgent = metaDataFormatter.getUserAgent();
    }

    public HttpRequest create(String url) {
        return this.requestFactory.create(url).setUserAgent(this.userAgent).setExpectedStatusCode(200);
    }

    public HttpRequest createPostJson(String url, JsonObject json) {
        return this.create(url).setMethodPost().setContentType(ContentType.APPLICATION_JSON).addData(json.toString());
    }
}

