/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.http.client.HttpException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;

public class HttpResponse {
    private final int statusCode;
    private final String body;

    @Inject
    public HttpResponse(@Assisted org.apache.http.HttpResponse response) throws HttpException {
        this.statusCode = response.getStatusLine().getStatusCode();
        try {
            HttpEntity entity = response.getEntity();
            this.body = entity != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8) : "";
        }
        catch (IOException | ParseException e) {
            throw new HttpException("Failed to parse response.", (Exception)e);
        }
    }

    public String getBody() {
        return this.body;
    }

    public JsonObject getBodyAsJsonObject() throws HttpException {
        JsonObject ret;
        JsonParser parser = new JsonParser();
        try {
            ret = parser.parse(this.getBody()).getAsJsonObject();
        }
        catch (JsonParseException e) {
            throw new HttpException("Failed to parse server response as JSON", (Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw new HttpException("Parsed entity is not a JsonObject", e);
        }
        return ret;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    static interface Factory {
        public HttpResponse create(org.apache.http.HttpResponse var1);
    }
}

