/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.client;

import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.http.client.HttpException;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.http.HttpResponse;

public class HttpResponseStream {
    private final int statusCode;
    private final InputStream stream;

    @Inject
    public HttpResponseStream(@Assisted HttpResponse response) throws HttpException {
        this.statusCode = response.getStatusLine().getStatusCode();
        try {
            this.stream = response.getEntity() != null && response.getEntity().getContent() != null ? response.getEntity().getContent() : null;
        }
        catch (IOException e) {
            throw new HttpException("Failed to parse response.", e);
        }
    }

    public InputStream getBodyAsStream() {
        return this.stream;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    static interface Factory {
        public HttpResponseStream create(HttpResponse var1);
    }
}

