/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.common;

import com.seleritycorp.common.base.http.common.HeaderParameter;
import com.seleritycorp.common.base.http.common.Negotiable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ContentType
implements Negotiable<ContentType> {
    public static final ContentType APPLICATION_JSON = new ContentType("application", "json", StandardCharsets.UTF_8);
    public static final ContentType TEXT_PLAIN = new ContentType("text", "plain", StandardCharsets.UTF_8);
    public static final ContentType TEXT_HTML = new ContentType("text", "html", StandardCharsets.UTF_8);
    public static final ContentType TEXT_WILDCARD = new ContentType("text", "*");
    public static final ContentType IMAGE_PNG = new ContentType("image", "png");
    public static final ContentType WILDCARD = new ContentType("*", "*");
    private final String type;
    private final String subtype;
    private final HeaderParameter[] parameters;

    public ContentType(String type, String subtype) {
        this(type, subtype, new HeaderParameter[0]);
    }

    public ContentType(String type, String subtype, Charset charset) {
        HeaderParameter[] headerParameterArray;
        if (charset != null) {
            HeaderParameter[] headerParameterArray2 = new HeaderParameter[1];
            headerParameterArray = headerParameterArray2;
            headerParameterArray2[0] = new HeaderParameter("charset", charset.name());
        } else {
            headerParameterArray = new HeaderParameter[]{};
        }
        this(type, subtype, headerParameterArray);
    }

    public ContentType(String raw) {
        String[] parts = raw.split(";");
        String[] mimeParts = parts[0].trim().split("/", 2);
        this.type = mimeParts[0].trim().toLowerCase();
        String string = this.subtype = mimeParts.length > 1 ? mimeParts[1].trim().toLowerCase() : "";
        if (parts.length > 1) {
            String trimmedParams = parts[1].trim();
            if (!trimmedParams.isEmpty()) {
                this.parameters = new HeaderParameter[parts.length - 1];
                for (int idx = 1; idx < parts.length; ++idx) {
                    this.parameters[idx - 1] = new HeaderParameter(parts[idx]);
                }
                Arrays.sort(this.parameters);
            } else {
                this.parameters = new HeaderParameter[0];
            }
        } else {
            this.parameters = new HeaderParameter[0];
        }
    }

    private ContentType(String type, String subtype, HeaderParameter[] parameters) {
        this.type = type != null ? type.trim().toLowerCase() : "";
        this.subtype = subtype != null ? subtype.trim().toLowerCase() : "";
        this.parameters = parameters != null ? parameters : new HeaderParameter[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        if (!this.type.equals(other.type)) {
            return false;
        }
        if (!this.subtype.equals(other.subtype)) {
            return false;
        }
        return Arrays.equals(this.parameters, other.parameters);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type);
        sb.append("/");
        sb.append(this.subtype);
        if (this.parameters.length > 0) {
            for (HeaderParameter parameter : this.parameters) {
                sb.append("; ");
                sb.append(parameter.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public boolean meets(ContentType specification) {
        boolean ret = false;
        if (("*".equals(specification.type) || this.type.equals(specification.type)) && ("*".equals(specification.subtype) || this.subtype.equals(specification.subtype))) {
            ret = true;
            for (HeaderParameter specParam : specification.parameters) {
                boolean foundParameterMatch = false;
                for (int idx = 0; !foundParameterMatch && idx < this.parameters.length; ++idx) {
                    if (!specParam.getKey().equals(this.parameters[idx].getKey()) || !specParam.getValue().equals(this.parameters[idx].getValue())) continue;
                    foundParameterMatch = true;
                }
                ret &= foundParameterMatch;
            }
        }
        return ret;
    }
}

