/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Negotiator<T> {
    protected abstract T parse(String var1);

    protected abstract boolean meets(T var1, T var2);

    private List<SortableUnparsedT> sortByQValue(String preferenceSpecification) {
        ArrayList<SortableUnparsedT> ret = new ArrayList<SortableUnparsedT>();
        if (preferenceSpecification != null) {
            String[] rawPreferences;
            for (String rawPreference : rawPreferences = preferenceSpecification.split(",")) {
                String[] preferenceParts = rawPreference.split(" *; *q *= *", 2);
                String rawT = preferenceParts[0].trim();
                if (rawT.isEmpty()) continue;
                float quality = 1.0f;
                if (preferenceParts.length > 1) {
                    String numberString = preferenceParts[1].split(";")[0].trim();
                    try {
                        quality = Float.parseFloat(numberString);
                        quality = Math.min(Math.max(quality, 0.0f), 1.0f);
                    }
                    catch (Exception e) {
                        quality = 1.0f;
                    }
                }
                ret.add(new SortableUnparsedT(rawT, quality));
            }
        }
        Collections.sort(ret);
        return ret;
    }

    private T findBestMatch(List<SortableUnparsedT> preferences, T[] candidates) {
        T ret = null;
        for (SortableUnparsedT sortableUnparsedT : preferences) {
            if (ret != null) continue;
            T preference = this.parse(sortableUnparsedT.getRaw());
            for (T candidate : candidates) {
                if (ret != null || !this.meets(candidate, preference)) continue;
                ret = candidate;
            }
        }
        return ret;
    }

    public T negotiate(String preferenceSpecification, T fallback, T ... candidates) {
        List<SortableUnparsedT> preferences = this.sortByQValue(preferenceSpecification);
        T ret = this.findBestMatch(preferences, candidates);
        if (ret == null) {
            ret = fallback;
        }
        return ret;
    }

    private class SortableUnparsedT
    implements Comparable<SortableUnparsedT> {
        private final String raw;
        private final float quality;

        SortableUnparsedT(String raw, float quality) {
            this.raw = raw;
            this.quality = quality;
        }

        public String getRaw() {
            return this.raw;
        }

        @Override
        @SuppressFBWarnings(value={"CO_COMPARETO_INCORRECT_FLOATING"}, justification="The strict equality checks on floats are ok. If there are tinydifferences between them, we want them to tip the scale.")
        public int compareTo(SortableUnparsedT other) {
            float diff = this.quality - other.quality;
            if (diff == 0.0f) {
                diff = this.raw.length() - other.raw.length();
            }
            return diff < 0.0f ? 1 : (diff == 0.0f ? 0 : -1);
        }

        public String toString() {
            return this.raw + "; q=" + this.quality;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Float.floatToIntBits(this.quality);
            result = 31 * result + (this.raw == null ? 0 : this.raw.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SortableUnparsedT other = (SortableUnparsedT)obj;
            if (Float.floatToIntBits(this.quality) != Float.floatToIntBits(other.quality)) {
                return false;
            }
            return !(this.raw == null ? other.raw != null : !this.raw.equals(other.raw));
        }
    }
}

