/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.jmx;

import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class MBeanUtils {
    private static final Log log = LogFactory.getLog(MBeanUtils.class);

    public static ObjectName register(String name, Object mbean) {
        ObjectName ret = null;
        log.debug("Registering MBean for " + name);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(name);
        }
        catch (NullPointerException | MalformedObjectNameException e) {
            log.error("Cannot register MBean, as name is invalid: " + name, e);
        }
        if (objectName != null) {
            MBeanUtils.unregisterIfRegistered(objectName);
            try {
                mbs.registerMBean(mbean, objectName);
                ret = objectName;
            }
            catch (InstanceAlreadyExistsException e) {
                log.error("Failing to register MBean for " + name + ", although we unregistered that name before. It looks like we're racing against another entity. So we're giving up registering " + name, e);
            }
            catch (MBeanRegistrationException | NotCompliantMBeanException e) {
                log.error("Cannot register MBean for " + name, e);
            }
        }
        return ret;
    }

    public static <T> ObjectName register(String name, T implementation, Class<T> interfaze) {
        ObjectName ret = null;
        StandardMBean bean = null;
        try {
            bean = new StandardMBean(implementation, interfaze);
        }
        catch (NotCompliantMBeanException e) {
            log.error("Failing to turn " + implementation + " into a StandardMBean", e);
        }
        if (bean != null) {
            ret = MBeanUtils.register(name, bean);
        }
        return ret;
    }

    public static void unregisterIfRegistered(ObjectName objectName) {
        if (objectName != null) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (MBeanRegistrationException e) {
                log.warn("Opportunistic unregistering of MBean at " + objectName.getCanonicalName() + " failed", e);
            }
        }
    }
}

