/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.logging;

import com.seleritycorp.common.base.logging.Formatter;
import com.seleritycorp.common.base.logging.Level;
import com.seleritycorp.common.base.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CommonsLog
implements Log {
    private static final String fqcn = CommonsLog.class.getName();
    private final org.apache.commons.logging.Log wrappedLog;
    private final Logger wrappedLog4j;
    private final Formatter formatter;

    CommonsLog(org.apache.commons.logging.Log wrappedLog, Formatter formatter) {
        this.wrappedLog = wrappedLog;
        this.formatter = formatter;
        this.wrappedLog4j = wrappedLog instanceof Log4JLogger ? ((Log4JLogger)wrappedLog).getLogger() : (wrappedLog instanceof Log ? ((Log)wrappedLog).getLog4jLogger() : null);
    }

    protected String processMessage(String message) {
        return message == null ? null : message.toString();
    }

    protected Event processEvent(Event event) {
        event.setMessage(this.processMessage(event.getMessage()));
        return event;
    }

    protected String processStructuredData(String tag, int version, Object ... objs) {
        return this.formatter.formatStructuredLine(tag, version, objs);
    }

    public boolean isDebugEnabled() {
        return this.wrappedLog.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.wrappedLog.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.wrappedLog.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.wrappedLog.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.wrappedLog.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.wrappedLog.isWarnEnabled();
    }

    public void trace(Object message) {
        Event event = new Event(message);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.TRACE, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.trace((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.trace((Object)event.getMessage());
        }
    }

    public void trace(Object message, Throwable throwable) {
        Event event = new Event(message, throwable);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.TRACE, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.trace((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.trace((Object)event.getMessage());
        }
    }

    public void debug(Object message) {
        Event event = new Event(message);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.DEBUG, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.debug((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.debug((Object)event.getMessage());
        }
    }

    public void debug(Object message, Throwable throwable) {
        Event event = new Event(message, throwable);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.DEBUG, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.debug((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.debug((Object)event.getMessage());
        }
    }

    public void info(Object message) {
        Event event = new Event(message);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.INFO, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.info((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.info((Object)event.getMessage());
        }
    }

    public void info(Object message, Throwable throwable) {
        Event event = new Event(message, throwable);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.INFO, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.info((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.info((Object)event.getMessage());
        }
    }

    public void warn(Object message) {
        Event event = new Event(message);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.WARN, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.warn((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.warn((Object)event.getMessage());
        }
    }

    public void warn(Object message, Throwable throwable) {
        Event event = new Event(message, throwable);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.WARN, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.warn((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.warn((Object)event.getMessage());
        }
    }

    public void error(Object message) {
        Event event = new Event(message);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.ERROR, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.error((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.error((Object)event.getMessage());
        }
    }

    public void error(Object message, Throwable throwable) {
        Event event = new Event(message, throwable);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.ERROR, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.error((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.error((Object)event.getMessage());
        }
    }

    public void fatal(Object message) {
        Event event = new Event(message);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.FATAL, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.fatal((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.fatal((Object)event.getMessage());
        }
    }

    public void fatal(Object message, Throwable throwable) {
        Event event = new Event(message, throwable);
        event = this.processEvent(event);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.FATAL, (Object)event.getMessage(), event.getThrowable());
        } else if (event.hasThrowable()) {
            this.wrappedLog.fatal((Object)event.getMessage(), event.getThrowable());
        } else {
            this.wrappedLog.fatal((Object)event.getMessage());
        }
    }

    @Override
    public void log(Level level, Object message) {
        if (level != null) {
            Event event = new Event(message);
            event = this.processEvent(event);
            if (this.wrappedLog4j != null) {
                this.wrappedLog4j.log(fqcn, (Priority)level.toLog4jLevel(), (Object)event.getMessage(), event.getThrowable());
            } else {
                switch (level) {
                    case FATAL: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.fatal((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.fatal((Object)event.getMessage());
                        break;
                    }
                    case ERROR: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.error((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.error((Object)event.getMessage());
                        break;
                    }
                    case WARN: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.warn((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.warn((Object)event.getMessage());
                        break;
                    }
                    case INFO: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.info((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.info((Object)event.getMessage());
                        break;
                    }
                    case DEBUG: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.debug((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.debug((Object)event.getMessage());
                        break;
                    }
                    case TRACE: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.trace((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.trace((Object)event.getMessage());
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void log(Level level, Object message, Throwable throwable) {
        if (level != null) {
            Event event = new Event(message, throwable);
            event = this.processEvent(event);
            if (this.wrappedLog4j != null) {
                this.wrappedLog4j.log(fqcn, (Priority)level.toLog4jLevel(), (Object)event.getMessage(), event.getThrowable());
            } else {
                switch (level) {
                    case FATAL: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.fatal((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.fatal((Object)event.getMessage());
                        break;
                    }
                    case ERROR: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.error((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.error((Object)event.getMessage());
                        break;
                    }
                    case WARN: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.warn((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.warn((Object)event.getMessage());
                        break;
                    }
                    case INFO: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.info((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.info((Object)event.getMessage());
                        break;
                    }
                    case DEBUG: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.debug((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.debug((Object)event.getMessage());
                        break;
                    }
                    case TRACE: {
                        if (event.hasThrowable()) {
                            this.wrappedLog.trace((Object)event.getMessage(), event.getThrowable());
                            break;
                        }
                        this.wrappedLog.trace((Object)event.getMessage());
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void structuredInfo(String tag, int version, Object ... objs) {
        String message = this.processStructuredData(tag, version, objs);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.INFO, (Object)message, null);
        } else {
            this.wrappedLog.info((Object)message);
        }
    }

    @Override
    public void structuredDebug(String tag, int version, Object ... objs) {
        String message = this.processStructuredData(tag, version, objs);
        if (this.wrappedLog4j != null) {
            this.wrappedLog4j.log(fqcn, (Priority)org.apache.log4j.Level.DEBUG, (Object)message, null);
        } else {
            this.wrappedLog.debug((Object)message);
        }
    }

    @Override
    public Logger getLog4jLogger() {
        return this.wrappedLog4j;
    }

    public static class Event {
        private String message;
        private boolean hasThrowable;
        private Throwable throwable;

        public Event(Object message) {
            this.setMessage(message);
            this.unsetThrowable();
        }

        public Event(Object message, Throwable throwable) {
            this.setMessage(message);
            this.setThrowable(throwable);
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(Object message) {
            this.message = message == null ? null : message.toString();
        }

        public boolean hasThrowable() {
            return this.hasThrowable;
        }

        public void unsetThrowable() {
            this.hasThrowable = false;
            this.throwable = null;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.hasThrowable = true;
            this.throwable = throwable;
        }
    }
}

