/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.logging;

import com.seleritycorp.common.base.logging.CommonsLog;
import com.seleritycorp.common.base.logging.Formatter;
import com.seleritycorp.common.base.logging.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

public class FlatLog
extends CommonsLog {
    public FlatLog(Log wrappedLog, Formatter formatter) {
        super(wrappedLog, formatter);
    }

    @Override
    protected CommonsLog.Event processEvent(CommonsLog.Event event) {
        event.setMessage(this.toSingleLine(event.getMessage(), event.getThrowable()));
        event.unsetThrowable();
        return event;
    }

    private String toSingleLine(Object message) {
        String ret = message.toString();
        ret = ret.replaceAll("\n", "\\\\n");
        return ret;
    }

    private String toSingleLine(Object message, Throwable throwable) {
        String multiLineMessage = message.toString();
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            multiLineMessage = multiLineMessage + "\\n" + throwable.toString() + "\\n" + stringWriter.toString();
        }
        return this.toSingleLine(multiLineMessage);
    }
}

