/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.logging;

import javax.inject.Singleton;

@Singleton
public class Formatter {
    private static final char SEPARATOR = '/';

    private String formatStructuredColumn(String name, Object value) {
        String ret = name == null ? "<null>" : name;
        ret = ret + ":";
        ret = ret + (value == null ? "<null>" : value);
        ret = ret.replaceAll("\\\\", "\\\\<");
        ret = ret.replaceAll("\r", "\\\\r");
        ret = ret.replaceAll("\n", "\\\\n");
        ret = ret.replaceAll("/", "\\\\|");
        return ret;
    }

    public String formatStructuredLine(String tag, int version, Object ... objs) {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        sb.append(this.formatStructuredColumn("log-tag", tag));
        sb.append('/');
        sb.append(this.formatStructuredColumn("log-tag-version", version));
        if (objs != null) {
            Object prev = null;
            boolean hasPrev = false;
            for (Object o : objs) {
                if (hasPrev) {
                    sb.append('/');
                    String prevStr = null;
                    if (prev != null) {
                        prevStr = prev.toString();
                    }
                    sb.append(this.formatStructuredColumn(prevStr, o));
                    hasPrev = false;
                    continue;
                }
                prev = o;
                hasPrev = true;
            }
            if (hasPrev) {
                sb.append('/');
                sb.append(this.formatStructuredColumn(null, prev));
            }
        }
        sb.append('/');
        return sb.toString();
    }
}

