/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.logging;

import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.logging.CommonsLog;
import com.seleritycorp.common.base.logging.Formatter;
import javax.inject.Inject;
import org.apache.commons.logging.Log;

public class PrefixedLogger
extends CommonsLog {
    private final String prefix;

    @Inject
    PrefixedLogger(@Assisted String prefix, @Assisted Log wrappedLog, Formatter formatter) {
        super(wrappedLog, formatter);
        this.prefix = prefix;
    }

    @Override
    protected String processMessage(String message) {
        return "(" + this.prefix + ") " + message;
    }

    @Override
    protected String processStructuredData(String tag, int version, Object ... objs) {
        int objsLength = objs == null ? 0 : objs.length;
        Object[] prefixedObjs = new Object[objsLength + 2];
        prefixedObjs[0] = "prefix";
        prefixedObjs[1] = this.prefix;
        System.arraycopy(objs, 0, prefixedObjs, 2, objsLength);
        return super.processStructuredData(tag, version, prefixedObjs);
    }

    public static interface Factory {
        public PrefixedLogger create(String var1, Log var2);
    }
}

