/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.state;

import com.seleritycorp.common.base.config.ApplicationPaths;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import com.seleritycorp.common.base.state.AnnotatedAppStateFacet;
import com.seleritycorp.common.base.state.AppState;
import com.seleritycorp.common.base.state.AppStateFacet;
import com.seleritycorp.common.base.state.AppStateManagerAccessor;
import com.seleritycorp.common.base.state.AppStatePushFacet;
import com.seleritycorp.common.base.time.Clock;
import com.seleritycorp.common.base.time.TimeUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AppStateManager
implements AppStateManagerAccessor {
    private static final Log log = LogFactory.getLog(AppStateManager.class);
    final Path statePath;
    final Path stateTmpPath;
    final Path stateUsablePath;
    final Path stateDrainPath;
    final Path stateOverridePath;
    final ConcurrentMap<String, AppStateFacetCapsule> facets;
    final AppStatePushFacet mainFacet;
    final AppStatePushFacet drainFacet;
    final OverridingAppStatePushFacet overrideFacet;
    private AppState previousState;
    private final TimeUtils timeUtils;
    private final Clock clock;

    @Inject
    public AppStateManager(ApplicationPaths paths, TimeUtils timeUtils, Clock clock) {
        this.statePath = paths.getDataStatePath().resolve("app-state");
        String statePathString = this.statePath.toString();
        this.stateTmpPath = Paths.get(statePathString + ".tmp", new String[0]);
        this.stateUsablePath = Paths.get(statePathString + ".usable", new String[0]);
        this.stateDrainPath = Paths.get(statePathString + ".drain", new String[0]);
        this.stateOverridePath = Paths.get(statePathString + ".override", new String[0]);
        this.facets = new ConcurrentHashMap<String, AppStateFacetCapsule>();
        this.previousState = AppState.INITIALIZING;
        this.timeUtils = timeUtils;
        this.clock = clock;
        this.mainFacet = this.createRegisteredAppStatePushFacet("main");
        if (this.mainFacet == null) {
            throw new IllegalStateException("Failed to register main facet with AppStateManager " + this);
        }
        this.drainFacet = this.createRegisteredAppStatePushFacet("draining");
        if (this.drainFacet == null) {
            throw new IllegalStateException("Failed to register draining facet with AppStateManager " + this);
        }
        this.overrideFacet = new OverridingAppStatePushFacet();
        this.registerAppStateFacet("state-override", this.overrideFacet);
    }

    @Override
    public AppStatePushFacet createRegisteredAppStatePushFacet(String name) {
        AppStatePushFacet facet = new AppStatePushFacet();
        if (!this.registerAppStateFacet(name, facet)) {
            facet = null;
        }
        return facet;
    }

    @Override
    public boolean registerAppStateFacet(String name, AppStateFacet facet) {
        boolean ret;
        AppStateFacetCapsule capsule;
        String safeName = name.replaceAll("[^a-zA-Z0-9]", "-");
        AppStateFacetCapsule oldCapsule = this.facets.putIfAbsent(safeName, capsule = new AppStateFacetCapsule(safeName, facet));
        boolean bl = ret = oldCapsule == null || oldCapsule.getAppStateFacet() == facet;
        if (!ret) {
            log.error("Could not register " + facet + " for name '" + safeName + "' as that is taken by " + oldCapsule.getAppStateFacet() + " already");
        }
        return ret;
    }

    @Override
    public void setMainAppState(AppState state) {
        this.mainFacet.setAppState(state);
    }

    @Override
    public AppState getAppState() {
        AppState state;
        if (this.facets.isEmpty()) {
            log.error("No facets in AppStateManager");
            state = AppState.FAULTY;
        } else if (this.overrideFacet.isOverride()) {
            state = this.overrideFacet.getAppState();
        } else {
            state = AppState.READY;
            for (AppStateFacetCapsule capsule : this.facets.values()) {
                AppState facetState = AppState.FAULTY;
                try {
                    facetState = capsule.getAppState();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                state = state.combine(facetState);
            }
        }
        if (this.previousState != state) {
            String message = "Application state changed from '" + (Object)((Object)this.previousState) + "' to '" + (Object)((Object)state) + "'.";
            if (this.previousState.isUsable() && !state.isUsable()) {
                log.error(message);
            } else {
                log.info(message);
            }
        }
        this.previousState = state;
        return state;
    }

    @Override
    public boolean isAppInitializing() {
        return this.getAppState() == AppState.INITIALIZING;
    }

    @Override
    public boolean isAppReady() {
        return this.getAppState() == AppState.READY;
    }

    @Override
    public boolean isAppWarning() {
        return this.getAppState() == AppState.WARNING;
    }

    @Override
    public boolean isAppFaulty() {
        return this.getAppState() == AppState.FAULTY;
    }

    @Override
    public boolean isAppUsable() {
        return this.getAppState().isUsable();
    }

    @Override
    public boolean isAppUnusable() {
        return !this.getAppState().isUsable();
    }

    private void persistStateFile(AppState cachedState) {
        try {
            Files.write(this.stateTmpPath, this.getStatusReport().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            try {
                Files.move(this.stateTmpPath, this.statePath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                log.warn("Could not move " + this.stateTmpPath + " onto " + this.statePath, e);
            }
        }
        catch (Exception e) {
            log.warn("Could not materialize state " + this.stateTmpPath, e);
        }
    }

    private void persistUsableFile(AppState cachedState) {
        if (cachedState.isUsable()) {
            try {
                Files.createFile(this.stateUsablePath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                FileTime time = FileTime.fromMillis(this.clock.getMillisEpoch());
                try {
                    Files.setLastModifiedTime(this.stateUsablePath, time);
                }
                catch (Exception e2) {
                    log.warn("Could not update mtime on " + this.stateUsablePath, e2);
                }
            }
            catch (Exception e) {
                log.warn("Could not delete " + this.stateUsablePath, e);
            }
        } else {
            try {
                Files.deleteIfExists(this.stateUsablePath);
            }
            catch (Exception e) {
                log.error("Could not delete " + this.stateUsablePath, e);
            }
        }
    }

    void persistState() {
        AppState cachedState = this.getAppState();
        this.persistStateFile(cachedState);
        this.persistUsableFile(cachedState);
    }

    void readDrainState() {
        if (Files.exists(this.stateDrainPath, new LinkOption[0])) {
            this.drainFacet.setAppState(AppState.FAULTY, "The draining file '" + this.stateDrainPath + "' exists, hence draining by marking FAULTY");
        } else {
            this.drainFacet.setAppState(AppState.READY);
        }
    }

    void readOverrideState() {
        block9: {
            AppState state = null;
            if (Files.exists(this.stateOverridePath, new LinkOption[0])) {
                try {
                    List<String> content = Files.readAllLines(this.stateOverridePath, Charset.defaultCharset());
                    if (content.size() >= 1) {
                        String trimmedContent = content.get(0).trim();
                        try {
                            state = AppState.valueOf(trimmedContent);
                            this.overrideFacet.setOverride(state);
                        }
                        catch (IllegalArgumentException e) {
                            this.overrideFacet.setOverride(AppState.FAULTY, "State '" + trimmedContent + "' (found in: " + this.stateOverridePath + " ) does not exist");
                        }
                        catch (NullPointerException e) {
                            this.overrideFacet.setOverride(AppState.FAULTY, "Encountered null trying to parse " + this.stateOverridePath);
                        }
                        break block9;
                    }
                    this.overrideFacet.resetOverride();
                }
                catch (IOException e) {
                    if (Files.exists(this.stateOverridePath, new LinkOption[0])) {
                        this.overrideFacet.resetOverride();
                        break block9;
                    }
                    this.overrideFacet.setOverride(AppState.FAULTY, "Override file exists, but cannot be read");
                }
            } else {
                this.overrideFacet.resetOverride();
            }
        }
    }

    void readStatePaths() {
        this.readDrainState();
        this.readOverrideState();
    }

    public String getStatusReport() {
        AppState cachedState = this.getAppState();
        StringBuilder sb = new StringBuilder();
        sb.append((Object)cachedState);
        sb.append("\n");
        sb.append("\n");
        sb.append("Application state: " + (Object)((Object)cachedState));
        sb.append("\n");
        sb.append("Application state report time: ");
        sb.append(this.timeUtils.formatTimeNanos());
        sb.append("\n");
        sb.append("\n");
        sb.append("Application state details:");
        sb.append("\n");
        for (Map.Entry entry : this.facets.entrySet()) {
            String name = (String)entry.getKey();
            AppStateFacet facet = ((AppStateFacetCapsule)entry.getValue()).getAppStateFacet();
            AppState state = AppState.FAULTY;
            String annotation = null;
            try {
                state = facet.getAppState();
                if (facet instanceof AnnotatedAppStateFacet) {
                    try {
                        annotation = ((AnnotatedAppStateFacet)facet).getAppStateAnnotation();
                    }
                    catch (Exception e) {
                        log.warn("Getting annotation for facet " + name + " failed", e);
                        annotation = "Getting annotation threw " + e.toString();
                    }
                }
            }
            catch (Exception e) {
                log.warn("Getting state for facet " + name + " failed", e);
                state = AppState.FAULTY;
                annotation = "Getting state threw " + e.toString();
            }
            if (annotation == null) {
                annotation = "";
            }
            sb.append(String.format("  %1$-14s %2$-14s %3$s", state.toString(), name, annotation));
            sb.append("\n");
        }
        return sb.toString();
    }

    private class OverridingAppStatePushFacet
    extends AppStatePushFacet {
        boolean override;

        public OverridingAppStatePushFacet() {
            this.resetOverride();
        }

        public boolean isOverride() {
            return this.override;
        }

        public void setOverride(AppState state) {
            this.setOverride(state, "State override in place. See file" + AppStateManager.this.stateOverridePath);
        }

        public void setOverride(AppState state, String annotation) {
            this.setAppState(state, annotation);
            this.override = true;
        }

        public void resetOverride() {
            this.setAppState(AppState.READY, "No overriding. Write state into " + AppStateManager.this.stateOverridePath + " to override.");
            this.override = false;
        }
    }

    private static class AppStateFacetCapsule {
        private final String name;
        private final AppStateFacet facet;
        private AppState previousState;

        private AppStateFacetCapsule(String name, AppStateFacet facet) {
            this.name = name;
            this.facet = facet;
            this.previousState = this.getAppStateUncapsuled();
        }

        private AppState getAppStateUncapsuled() {
            AppState state = this.facet.getAppState();
            if (state == null) {
                state = AppState.FAULTY;
            }
            return state;
        }

        public AppState getAppState() {
            AppState state = this.getAppStateUncapsuled();
            if (this.previousState != state) {
                String message = "AppStateFacet '" + this.name + "' changed state from '" + (Object)((Object)this.previousState) + "' to '" + (Object)((Object)state) + "'";
                if (this.previousState.isUsable() && !state.isUsable()) {
                    log.error(message);
                } else {
                    log.info(message);
                }
            }
            this.previousState = state;
            return state;
        }

        public AppStateFacet getAppStateFacet() {
            return this.facet;
        }
    }
}

