/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.state;

import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.ApplicationPaths;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import com.seleritycorp.common.base.state.HaState;
import com.seleritycorp.common.base.state.HaStateManagerAccessor;
import com.seleritycorp.common.base.state.StateManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HaStateManager
implements HaStateManagerAccessor {
    private static final Log log = LogFactory.getLog(StateManager.class);
    private final Path statePath;
    private boolean dynamic;
    private HaState state;

    @Inject
    HaStateManager(@ApplicationConfig Config config, ApplicationPaths paths) {
        this.dynamic = config.getBoolean("HaStateManager.enabled", false);
        this.statePath = paths.getDataStatePath().resolve("ha-state");
        this.setHaState(this.dynamic ? HaState.FAULT : HaState.MASTER);
    }

    @Override
    public HaState getHaState() {
        return this.state;
    }

    @Override
    public boolean isHaMaster() {
        return this.state == HaState.MASTER;
    }

    @Override
    public boolean isHaBackup() {
        return this.state == HaState.BACKUP;
    }

    @Override
    public boolean isHaFault() {
        return this.state == HaState.FAULT;
    }

    @Override
    public boolean isHaHealthy() {
        return this.isHaMaster() || this.isHaBackup();
    }

    @Override
    public boolean isHaUnhealthy() {
        return !this.isHaHealthy();
    }

    void setHaState(HaState state) {
        this.state = state == null ? HaState.FAULT : state;
    }

    void readState() {
        if (this.dynamic) {
            this.readStateForced();
        }
    }

    void readStateForced() {
        HaState newState = HaState.FAULT;
        try {
            List<String> contents = Files.readAllLines(this.statePath, Charset.defaultCharset());
            if (!contents.isEmpty()) {
                String newStateString = contents.get(0);
                try {
                    newState = HaState.valueOf(newStateString);
                }
                catch (IllegalArgumentException e) {
                    log.warn("First line '" + newStateString + "' of HA state file '" + this.statePath + "' does not parse to a proper state", e);
                }
                catch (NullPointerException e) {
                    log.warn("First line '" + newStateString + "' of HA state file '" + this.statePath + "' does not parse to a proper state", e);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.state != newState) {
            log.info("HA state switch: '" + (Object)((Object)this.state) + "' -> '" + (Object)((Object)newState) + "'");
        }
        this.state = newState;
    }
}

