/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.state;

import com.seleritycorp.common.base.jmx.MBeanUtils;
import com.seleritycorp.common.base.state.AppState;
import com.seleritycorp.common.base.state.AppStateFacet;
import com.seleritycorp.common.base.state.AppStateManager;
import com.seleritycorp.common.base.state.AppStateManagerAccessor;
import com.seleritycorp.common.base.state.AppStatePushFacet;
import com.seleritycorp.common.base.state.HaState;
import com.seleritycorp.common.base.state.HaStateManager;
import com.seleritycorp.common.base.state.HaStateManagerAccessor;
import com.seleritycorp.common.base.state.StateManagerMBean;
import com.seleritycorp.common.base.state.StateManagerPeriodicTasksRunner;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StateManager
implements StateManagerMBean,
AppStateManagerAccessor,
HaStateManagerAccessor {
    private final AppStateManager appStateManager;
    private final HaStateManager haStateManager;
    private final StateManagerPeriodicTasksRunner periodicTasksRunner;

    @Inject
    StateManager(AppStateManager appStateManager, HaStateManager haStateManager, StateManagerPeriodicTasksRunner periodicTasksRunner) {
        this.appStateManager = appStateManager;
        this.haStateManager = haStateManager;
        this.periodicTasksRunner = periodicTasksRunner;
        MBeanUtils.register("com.seleritycorp.common.base.state:name=StateManager", this);
    }

    @Override
    public HaState getHaState() {
        return this.haStateManager.getHaState();
    }

    @Override
    public int getHaStateNumber() {
        return this.getHaState().getHaStateNumber();
    }

    @Override
    public boolean isHaMaster() {
        return this.haStateManager.isHaMaster();
    }

    @Override
    public boolean isHaBackup() {
        return this.haStateManager.isHaBackup();
    }

    @Override
    public boolean isHaFault() {
        return this.haStateManager.isHaFault();
    }

    @Override
    public boolean isHaHealthy() {
        return this.haStateManager.isHaHealthy();
    }

    @Override
    public boolean isHaUnhealthy() {
        return this.haStateManager.isHaUnhealthy();
    }

    @Override
    public void setMainAppState(AppState state) {
        this.appStateManager.setMainAppState(state);
    }

    @Override
    public AppState getAppState() {
        return this.appStateManager.getAppState();
    }

    @Override
    public boolean isAppInitializing() {
        return this.appStateManager.isAppInitializing();
    }

    @Override
    public boolean isAppReady() {
        return this.appStateManager.isAppReady();
    }

    @Override
    public boolean isAppWarning() {
        return this.appStateManager.isAppWarning();
    }

    @Override
    public boolean isAppFaulty() {
        return this.appStateManager.isAppFaulty();
    }

    @Override
    public boolean isAppUsable() {
        return this.appStateManager.isAppUsable();
    }

    @Override
    public boolean getAppUsable() {
        return this.isAppUsable();
    }

    @Override
    public int getAppStateNumber() {
        return this.getAppState().getWeight();
    }

    @Override
    public boolean isAppUnusable() {
        return this.appStateManager.isAppUnusable();
    }

    @Override
    public AppStatePushFacet createRegisteredAppStatePushFacet(String name) {
        return this.appStateManager.createRegisteredAppStatePushFacet(name);
    }

    @Override
    public boolean registerAppStateFacet(String name, AppStateFacet facet) {
        return this.appStateManager.registerAppStateFacet(name, facet);
    }

    void startPeriodicTasks() {
        this.periodicTasksRunner.start();
    }

    void stopPeriodicTasks() {
        this.periodicTasksRunner.stop();
    }
}

