/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.thread;

import com.google.inject.Inject;
import com.seleritycorp.common.base.jmx.MBeanUtils;
import com.seleritycorp.common.base.thread.ExecutorServiceMetrics;
import com.seleritycorp.common.base.thread.ThreadFactoryFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;

@Singleton
public class ExecutorServiceFactory {
    private ThreadFactoryFactory threadFactoryFactory;
    private final ExecutorServiceMetrics.Factory executorServiceMetricsFactory;

    @Inject
    public ExecutorServiceFactory(ThreadFactoryFactory threadFactoryFactory, ExecutorServiceMetrics.Factory executorServiceMetricsFactory) {
        this.threadFactoryFactory = threadFactoryFactory;
        this.executorServiceMetricsFactory = executorServiceMetricsFactory;
    }

    public ExecutorService createFixedUnboundedDaemonExecutorService(String prefix, int threadCount) {
        ThreadFactory threadFactory = this.threadFactoryFactory.createDaemonThreadFactory(prefix);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, queue, threadFactory);
        ExecutorServiceMetrics metrics = this.executorServiceMetricsFactory.create(executor);
        String name = "com.seleritycorp.common.base.thread:type=ThreadPool,name=" + prefix;
        MBeanUtils.register(name, metrics);
        return executor;
    }
}

