/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.time;

import com.seleritycorp.common.base.time.Clock;
import com.seleritycorp.common.base.time.TimeUtils;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.inject.Inject;

public class TimeUtilsImpl
implements TimeUtils {
    protected static final ThreadLocal<SimpleDateFormat> ISO8601_FORMAT_PLUS_MS = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat initValue = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            initValue.setTimeZone(TimeZone.getTimeZone("UTC"));
            return initValue;
        }
    };
    private static final long MIN_SLEEP_MILLIS = 5L;
    private final Clock clock;

    @Inject
    public TimeUtilsImpl(Clock clock) {
        this.clock = clock;
    }

    @Override
    public String formatTimeNanos() {
        long nanos = this.clock.getNanosEpoch();
        long millis = nanos / 1000000L;
        String ret = ISO8601_FORMAT_PLUS_MS.get().format(millis);
        long microsAndNanosWoMillis = nanos % 1000000L;
        ret = ret + Long.toString(1000000L + microsAndNanosWoMillis).substring(1);
        return ret;
    }

    @Override
    public InterruptedException sleepForMillis(long millis) {
        InterruptedException ret = null;
        long end = this.clock.getMillisEpoch() + millis;
        try {
            while (end >= this.clock.getMillisEpoch()) {
                long duration = Math.max(end - this.clock.getMillisEpoch(), 5L);
                Thread.sleep(duration);
            }
        }
        catch (InterruptedException e) {
            ret = e;
        }
        return ret;
    }
}

