/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.util.concurrent.CopyOnWriteArrayList;
import org.dhatim.fastexcel.BitMatrix;

public class DynamicBitMatrix {
    static final int UNIT_WEITH = 64;
    static final int UNIT_HIGHT = 1024;
    final int MAX_WIDTH;
    final int MAX_HIGHT;
    private final CopyOnWriteArrayList<CopyOnWriteArrayList<BitMatrix>> bitMatrixData = new CopyOnWriteArrayList();

    public DynamicBitMatrix(int maxWidth, int maxHight) {
        this.MAX_WIDTH = maxWidth;
        this.MAX_HIGHT = maxHight;
    }

    void setRegion(int top, int left, int bottom, int right) {
        int i;
        if (right >= this.MAX_WIDTH) {
            throw new IllegalArgumentException(String.format("Right boundary value exceeds maximum allowed.MAX_WIDTH = %d,right = %d", this.MAX_WIDTH, right));
        }
        if (bottom >= this.MAX_HIGHT) {
            throw new IllegalArgumentException(String.format("Bottom boundary value exceeds maximum allowed.MAX_HIGHT = %d,bottom = %d", this.MAX_HIGHT, bottom));
        }
        int rightBitMatrixColIndex = right / 64;
        int leftBitMatrixColIndex = left / 64;
        int topBitMatrixRowIndex = top / 1024;
        int bottomBitMatrixRowIndex = bottom / 1024;
        if (rightBitMatrixColIndex >= this.bitMatrixData.size()) {
            for (i = this.bitMatrixData.size() - 1; i < rightBitMatrixColIndex; ++i) {
                this.bitMatrixData.add(null);
            }
        }
        for (i = leftBitMatrixColIndex; i <= rightBitMatrixColIndex; ++i) {
            int j;
            CopyOnWriteArrayList<BitMatrix> colBitMatrices;
            if (this.bitMatrixData.get(i) == null || this.bitMatrixData.get(i).isEmpty()) {
                this.bitMatrixData.set(i, new CopyOnWriteArrayList());
            }
            if (bottomBitMatrixRowIndex >= (colBitMatrices = this.bitMatrixData.get(i)).size()) {
                for (j = colBitMatrices.size() - 1; j < bottomBitMatrixRowIndex; ++j) {
                    colBitMatrices.add(null);
                }
            }
            for (j = topBitMatrixRowIndex; j <= bottomBitMatrixRowIndex; ++j) {
                if (colBitMatrices.get(j) == null || colBitMatrices.isEmpty()) {
                    colBitMatrices.set(j, new BitMatrix(64, 1024));
                }
                BitMatrix bitMatrix = colBitMatrices.get(j);
                int l = Math.max(i * 64, left) - i * 64;
                int t = Math.max(j * 1024, top) - j * 1024;
                int r = Math.min((i + 1) * 64 - 1, right) - i * 64;
                int b = Math.min((j + 1) * 1024 - 1, bottom) - j * 1024;
                bitMatrix.setRegion(l, t, r - l + 1, b - t + 1);
            }
        }
    }

    boolean isConflict(int top, int left, int bottom, int right) {
        if (this.get(top, left) || this.get(top, right) || this.get(bottom, left) || this.get(bottom, right)) {
            return true;
        }
        for (int c = left; c <= right; ++c) {
            for (int r = top; r <= bottom; ++r) {
                if (c == left && (r == top || r == bottom) || c == right && (r == top || r == bottom) || !this.get(r, c)) continue;
                return true;
            }
        }
        return false;
    }

    boolean get(int row, int col) {
        int bitMatrixRowIndex = row / 1024;
        int bitMatrixColIndex = col / 64;
        return !this.isInNullArea(bitMatrixRowIndex, bitMatrixColIndex) && this.bitMatrixData.get(bitMatrixColIndex).get(bitMatrixRowIndex).get(col - bitMatrixColIndex * 64, row - bitMatrixRowIndex * 1024);
    }

    private boolean isInNullArea(int bitMatrixRowIndex, int bitMatrixColIndex) {
        if (bitMatrixColIndex >= this.bitMatrixData.size()) {
            return true;
        }
        CopyOnWriteArrayList<BitMatrix> colBitMatrices = this.bitMatrixData.get(bitMatrixColIndex);
        if (colBitMatrices == null || colBitMatrices.isEmpty()) {
            return true;
        }
        if (bitMatrixRowIndex >= colBitMatrices.size()) {
            return true;
        }
        return colBitMatrices.get(bitMatrixRowIndex) == null;
    }

    public String toString() {
        return this.buildToString("1", "0", " ", "\n");
    }

    public String buildToString(String setString, String unsetString, String fillNullString, String lineSeparator) {
        StringBuilder builder = new StringBuilder();
        int maxBitMatrixCol = this.bitMatrixData.size();
        int maxBitMatrixRow = this.bitMatrixData.stream().mapToInt(a -> a == null ? 0 : a.size()).max().orElse(0);
        for (int i = 0; i < maxBitMatrixRow; ++i) {
            for (int h = 0; h < 1024; ++h) {
                for (int j = 0; j < maxBitMatrixCol; ++j) {
                    boolean inNullArea = this.isInNullArea(i, j);
                    for (int k = 0; k < 64; ++k) {
                        builder.append(inNullArea ? fillNullString : (this.bitMatrixData.get(j).get(i).get(k, h) ? setString : unsetString));
                        builder.append(j == maxBitMatrixCol - 1 && k == 63 ? lineSeparator : Character.valueOf(','));
                    }
                }
            }
        }
        return builder.toString();
    }
}

