/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.fonts.roboto;

import com.formdev.flatlaf.util.FontUtils;
import java.net.URL;

public class FlatRobotoFont {
    public static final String FAMILY = "Roboto";
    public static final String FAMILY_LIGHT = "Roboto Light";
    public static final String FAMILY_SEMIBOLD = "Roboto Medium";
    public static final String STYLE_REGULAR = "Roboto-Regular.ttf";
    public static final String STYLE_ITALIC = "Roboto-Italic.ttf";
    public static final String STYLE_BOLD = "Roboto-Bold.ttf";
    public static final String STYLE_BOLD_ITALIC = "Roboto-BoldItalic.ttf";
    public static final String STYLE_LIGHT = "Roboto-Light.ttf";
    public static final String STYLE_LIGHT_ITALIC = "Roboto-LightItalic.ttf";
    public static final String STYLE_SEMIBOLD = "Roboto-Medium.ttf";
    public static final String STYLE_SEMIBOLD_ITALIC = "Roboto-MediumItalic.ttf";

    private FlatRobotoFont() {
    }

    public static void installLazy() {
        FontUtils.registerFontFamilyLoader((String)FAMILY, FlatRobotoFont::installBasic);
        FontUtils.registerFontFamilyLoader((String)FAMILY_LIGHT, FlatRobotoFont::installLight);
        FontUtils.registerFontFamilyLoader((String)FAMILY_SEMIBOLD, FlatRobotoFont::installSemiBold);
    }

    public static void install() {
        FlatRobotoFont.installBasic();
        FlatRobotoFont.installLight();
        FlatRobotoFont.installSemiBold();
    }

    public static void installBasic() {
        FlatRobotoFont.installStyle(STYLE_REGULAR);
        FlatRobotoFont.installStyle(STYLE_ITALIC);
        FlatRobotoFont.installStyle(STYLE_BOLD);
        FlatRobotoFont.installStyle(STYLE_BOLD_ITALIC);
    }

    public static void installLight() {
        FlatRobotoFont.installStyle(STYLE_LIGHT);
        FlatRobotoFont.installStyle(STYLE_LIGHT_ITALIC);
    }

    public static void installSemiBold() {
        FlatRobotoFont.installStyle(STYLE_SEMIBOLD);
        FlatRobotoFont.installStyle(STYLE_SEMIBOLD_ITALIC);
    }

    public static boolean installStyle(String name) {
        return FontUtils.installFont((URL)FlatRobotoFont.class.getResource(name));
    }
}

