/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.base;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.TransactionTemplate;

public abstract class Connection<D extends Database>
implements Closeable {
    protected final D database;
    protected final JdbcTemplate jdbcTemplate;
    private final java.sql.Connection jdbcConnection;
    protected final String originalSchemaNameOrSearchPath;
    private final boolean originalAutoCommit;

    protected Connection(D database, java.sql.Connection connection) {
        this.database = database;
        try {
            this.originalAutoCommit = connection.getAutoCommit();
            if (!this.originalAutoCommit) {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to turn on auto-commit for the connection", e);
        }
        this.jdbcConnection = connection;
        this.jdbcTemplate = new JdbcTemplate(this.jdbcConnection, ((Database)database).getDatabaseType());
        try {
            this.originalSchemaNameOrSearchPath = this.getCurrentSchemaNameOrSearchPath();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine the original schema for the connection", e);
        }
    }

    protected abstract String getCurrentSchemaNameOrSearchPath() throws SQLException;

    public final Schema getCurrentSchema() {
        try {
            return this.doGetCurrentSchema();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine the current schema for the connection", e);
        }
    }

    protected Schema doGetCurrentSchema() throws SQLException {
        return this.getSchema(this.getCurrentSchemaNameOrSearchPath());
    }

    public abstract Schema getSchema(String var1);

    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (!schema.exists()) {
                return;
            }
            this.doChangeCurrentSchemaOrSearchPathTo(schema.getName());
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error setting current schema to " + schema, e);
        }
    }

    protected void doChangeCurrentSchemaOrSearchPathTo(String schemaNameOrSearchPath) throws SQLException {
    }

    public <T> T lock(final Table table, final Callable<T> callable) {
        return TransactionTemplate.createTransactionTemplate(this.jdbcTemplate.getConnection(), ((Database)this.database).supportsDdlTransactions()).execute(new Callable<T>(){

            @Override
            public T call() throws Exception {
                table.lock();
                return callable.call();
            }
        });
    }

    public final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public final void close() {
        this.restoreOriginalState();
        this.restoreOriginalSchema();
        this.restoreOriginalAutoCommit();
        JdbcUtils.closeConnection(this.jdbcConnection);
    }

    private void restoreOriginalSchema() {
        TransactionTemplate.createTransactionTemplate(this.jdbcConnection).execute(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    Connection.this.doChangeCurrentSchemaOrSearchPathTo(Connection.this.originalSchemaNameOrSearchPath);
                }
                catch (SQLException e) {
                    throw new FlywaySqlException("Unable to restore original schema", e);
                }
                return null;
            }
        });
    }

    public final void restoreOriginalState() {
        try {
            this.doRestoreOriginalState();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to restore connection to its original state", e);
        }
    }

    private void restoreOriginalAutoCommit() {
        try {
            this.jdbcConnection.setAutoCommit(this.originalAutoCommit);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to restore connection to its original auto-commit setting", e);
        }
    }

    protected void doRestoreOriginalState() throws SQLException {
    }

    public final java.sql.Connection getJdbcConnection() {
        return this.jdbcConnection;
    }
}

