/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.oasis.OasisZip;
import net.sf.jasperreports.engine.export.oasis.TableBuilder;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.util.RendererUtil;

public abstract class DocumentBuilder {
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected final Map<String, String> rendererToImagePathMap = new HashMap<String, String>();
    protected final RenderersCache renderersCache = new RenderersCache(this.getJasperReportsContext());
    protected final OasisZip oasisZip;

    public DocumentBuilder(OasisZip oasisZip) {
        this.oasisZip = oasisZip;
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("export.common.invalid.image.name", imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        return this.getHyperlinkURL(link, true);
    }

    protected String getHyperlinkURL(JRPrintHyperlink link, boolean isOnePagePerSheet) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block12: {
                href = null;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block12;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.getReportIndex() + "_" + (isOnePagePerSheet ? link.getHyperlinkPage().toString() : "1");
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected RenderersCache getRenderersCache() {
        return this.renderersCache;
    }

    protected String getImagePath(Renderable renderer, Dimension dimension, Color backcolor, JRExporterGridCell gridCell, RenderersCache imageRenderersCache) throws JRException {
        String imagePath = null;
        if (renderer instanceof DataRenderable && this.rendererToImagePathMap.containsKey(renderer.getId())) {
            imagePath = this.rendererToImagePathMap.get(renderer.getId());
        } else {
            JRPrintElementIndex imageIndex = this.getElementIndex(gridCell);
            DataRenderable imageRenderer = RendererUtil.getInstance(this.getJasperReportsContext()).getImageDataRenderable(imageRenderersCache, renderer, dimension, backcolor);
            this.oasisZip.addEntry(new FileBufferedZipEntry("Pictures/" + DocumentBuilder.getImageName(imageIndex), imageRenderer.getData(this.getJasperReportsContext())));
            String imageName = DocumentBuilder.getImageName(imageIndex);
            imagePath = "Pictures/" + imageName;
            if (imageRenderer == renderer) {
                this.rendererToImagePathMap.put(renderer.getId(), imagePath);
            }
        }
        return imagePath;
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.getReportIndex(), this.getPageIndex(), gridCell.getElementAddress());
        return imageIndex;
    }

    public abstract JRStyledText getStyledText(JRPrintText var1);

    public abstract Locale getTextLocale(JRPrintText var1);

    public abstract String getInvalidCharReplacement();

    protected abstract void insertPageAnchor(TableBuilder var1);

    protected abstract JRHyperlinkProducer getHyperlinkProducer(JRPrintHyperlink var1);

    protected abstract JasperReportsContext getJasperReportsContext();

    protected abstract int getReportIndex();

    protected abstract int getPageIndex();
}

