/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.bradesco_api;

import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;

public class ConfiguracaoBradescoAPI
implements Configuracao {
    @NotEmpty
    private String clientId;
    @NotEmpty
    private String cpfCnpj;
    @NotNull
    private AmbienteEnum ambiente;
    @NotEmpty
    private String caminhoCertificado;
    @NotEmpty
    private String urlRegistroBoleto = "/v1/boleto/registrarBoleto";
    @NotEmpty
    private String urlToken = "/auth/server/v1.1/token";
    @NotEmpty
    private String urlBaseProducao = "https://openapi.bradesco.com.br";
    @NotEmpty
    private String urlBaseHomologacao = "https://proxy.api.prebanco.com.br";
    private final String arquivoJasper = "BoletoBradesco";
    private final String logo = "LogoBradesco.png";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    public String getURLBase() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlBaseProducao : this.urlBaseHomologacao;
    }

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    @Override
    public InputStream modeloImpressaoBoleto() {
        if (this.modeloImpressaoBoleto == null) {
            try {
                this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoBradesco.jasper");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
        try {
            this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoCarne.jasper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() {
        Image imageLogo = null;
        try {
            InputStream inputStreamLogo = this.getClass().getResourceAsStream("/logo/LogoBradesco.png");
            imageLogo = new ImageIcon(IOUtils.toByteArray(inputStreamLogo)).getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.parametrosImpressaoBoleto.put("LogoBanco", imageLogo);
        this.parametrosImpressaoBoleto.put("REPORT_LOCALE", new Locale("pt", "BR"));
        return this.parametrosImpressaoBoleto;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return Arrays.asList("beneficiario.agencia", "beneficiario.digitoAgencia", "beneficiario.conta", "beneficiario.digitoConta", "beneficiario.documento", "beneficiario.carteira", "nossoNumero", "pagador.nome", "pagador.documento", "pagador.codigo", "pagador.endereco.logradouro", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cep", "pagador.endereco.cidade", "pagador.endereco.uf", "valorBoleto", "dataVencimento", "beneficiario", "pagador");
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @NotNull
    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public String getCaminhoCertificado() {
        return this.caminhoCertificado;
    }

    public String getUrlRegistroBoleto() {
        return this.urlRegistroBoleto;
    }

    public String getUrlToken() {
        return this.urlToken;
    }

    public String getUrlBaseProducao() {
        return this.urlBaseProducao;
    }

    public String getUrlBaseHomologacao() {
        return this.urlBaseHomologacao;
    }

    public String getArquivoJasper() {
        return this.arquivoJasper;
    }

    public String getLogo() {
        return this.logo;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public void setAmbiente(@NotNull AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public void setCaminhoCertificado(String caminhoCertificado) {
        this.caminhoCertificado = caminhoCertificado;
    }

    public void setUrlRegistroBoleto(String urlRegistroBoleto) {
        this.urlRegistroBoleto = urlRegistroBoleto;
    }

    public void setUrlToken(String urlToken) {
        this.urlToken = urlToken;
    }

    public void setUrlBaseProducao(String urlBaseProducao) {
        this.urlBaseProducao = urlBaseProducao;
    }

    public void setUrlBaseHomologacao(String urlBaseHomologacao) {
        this.urlBaseHomologacao = urlBaseHomologacao;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

