/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.bradesco_cnab400;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.Beneficiario;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Pagador;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.TipoMultaEnum;
import br.com.java_brasil.boleto.service.bancos.bradesco_cnab400.BradescoUtil;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang3.StringUtils;

public class BancoBradescoCnab400
extends BoletoController {
    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            boletos.forEach(this::preparaValidaBoletoImpressao);
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        return this.gerarArquivo(remessaRetornoModel);
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        return this.importarArquivo(arquivo);
    }

    public String gerarArquivo(List<RemessaRetornoModel> list) {
        list.forEach(boleto -> ValidaUtils.validaBoletoModel(boleto.getBoleto(), this.getConfiguracao().camposObrigatoriosBoleto()));
        Integer contador = 1;
        StringBuilder linhaArquivo = new StringBuilder();
        linhaArquivo.append("0");
        linhaArquivo.append("1");
        linhaArquivo.append("REMESSA");
        linhaArquivo.append("01");
        linhaArquivo.append(StringUtils.rightPad("COBRANCA", 15, ' '));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getCodigosEmpresa(), 20, "0"));
        linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(list.get(0).getBoleto().getBeneficiario().getNomeBeneficiario(), 30), 30, " "));
        linhaArquivo.append("237");
        linhaArquivo.append(StringUtils.rightPad("BRADESCO", 15, ' '));
        linhaArquivo.append(BoletoUtil.getDataFormato(LocalDate.now(), "ddMMyy"));
        linhaArquivo.append(StringUtils.repeat(" ", 8));
        linhaArquivo.append("MX");
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getNumeroRemessa(), 7, '0'));
        linhaArquivo.append(StringUtils.repeat(" ", 277));
        linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, "0"));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        Integer n = contador;
        Integer n2 = contador = Integer.valueOf(contador + 1);
        for (RemessaRetornoModel boleto2 : list) {
            linhaArquivo.append("1");
            linhaArquivo.append(StringUtils.repeat("0", 5));
            linhaArquivo.append(StringUtils.repeat("0", 1));
            linhaArquivo.append(StringUtils.repeat("0", 5));
            linhaArquivo.append(StringUtils.repeat("0", 7));
            linhaArquivo.append(StringUtils.repeat("0", 1));
            linhaArquivo.append("0");
            linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getCarteira(), 3, "0"));
            linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getAgencia(), 5, "0"));
            linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 7, "0"));
            linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getDigitoConta(), 1, "0"));
            linhaArquivo.append(StringUtils.repeat(" ", 25));
            linhaArquivo.append(StringUtils.repeat("0", 3));
            if (!boleto2.getBoleto().getTipoMulta().equals((Object)TipoMultaEnum.ISENTO) && BoletoUtil.isNotNullEMaiorQZero(boleto2.getBoleto().getValorPercentualMulta())) {
                linhaArquivo.append("2");
                linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualMulta(), 2, 4));
            } else {
                linhaArquivo.append("0");
                linhaArquivo.append(StringUtils.repeat("0", 4));
            }
            linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getNossoNumero(), 11, "0"));
            linhaArquivo.append(boleto2.getBoleto().getDigitoNossoNumero());
            linhaArquivo.append(StringUtils.repeat("0", 10));
            linhaArquivo.append("2");
            linhaArquivo.append(" ");
            linhaArquivo.append(StringUtils.repeat(" ", 10));
            linhaArquivo.append(" ");
            linhaArquivo.append("2");
            linhaArquivo.append(StringUtils.repeat(" ", 2));
            linhaArquivo.append(StringUtils.leftPad(boleto2.getInstrucao(), 2, "0"));
            linhaArquivo.append(StringUtils.rightPad(boleto2.getBoleto().getNumeroDocumento(), 10, " "));
            linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataVencimento(), "ddMMyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorBoleto(), 2, 13));
            linhaArquivo.append(StringUtils.repeat("0", 3));
            linhaArquivo.append(StringUtils.repeat("0", 5));
            linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getEspecieDocumento(), 2, "0"));
            linhaArquivo.append("N");
            linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataEmissao(), "ddMMyy"));
            linhaArquivo.append(StringUtils.repeat("0", 4));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getJuroDeMora(), 2, 13));
            linhaArquivo.append(StringUtils.repeat("0", 6));
            linhaArquivo.append(StringUtils.repeat("0", 13));
            linhaArquivo.append(StringUtils.repeat("0", 13));
            linhaArquivo.append(StringUtils.repeat("0", 13));
            linhaArquivo.append(boleto2.getBoleto().getPagador().isClienteCpf() ? "01" : "02");
            linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getPagador().getDocumento(), 14, "0"));
            linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(boleto2.getBoleto().getPagador().getNome(), 40), 40, " "));
            String enderecoCompleto = boleto2.getBoleto().getPagador().getEndereco().getLogradouro();
            enderecoCompleto = enderecoCompleto + ", " + boleto2.getBoleto().getPagador().getEndereco().getNumero();
            if (boleto2.getBoleto().getPagador().getEndereco().getComplemento() != null) {
                enderecoCompleto = enderecoCompleto + " " + boleto2.getBoleto().getPagador().getEndereco().getComplemento();
            }
            linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(enderecoCompleto, 40), 40, " "));
            linhaArquivo.append(StringUtils.repeat(" ", 12));
            linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getPagador().getEndereco().getCep(), 8, "0"));
            linhaArquivo.append(StringUtils.repeat(" ", 60));
            linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, "0"));
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
            Integer n3 = contador;
            Integer n4 = contador = Integer.valueOf(contador + 1);
        }
        linhaArquivo.append("9");
        linhaArquivo.append(StringUtils.repeat(" ", 393));
        linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, "0"));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        String arquivoRemessa = linhaArquivo.toString();
        StringBuilder sbRemessa = new StringBuilder();
        for (int i = 0; i < arquivoRemessa.length(); ++i) {
            char ch = arquivoRemessa.charAt(i);
            if (BradescoUtil.isASCIIBradesco(ch)) {
                sbRemessa.append(ch);
                continue;
            }
            sbRemessa.append(' ');
        }
        return sbRemessa.toString();
    }

    private List<RemessaRetornoModel> importarArquivo(String arquivo) {
        ArrayList<RemessaRetornoModel> list = new ArrayList<RemessaRetornoModel>();
        String numeroRetorno = null;
        try (Scanner scanner = new Scanner(arquivo);){
            while (scanner.hasNextLine()) {
                String linha = scanner.nextLine();
                if (linha.length() <= 1) continue;
                if (linha.charAt(0) == '0') {
                    if (!linha.substring(1, 2).equals("2")) {
                        throw new BoletoException("Formato do aquivo inv\u00e1lido.");
                    }
                    if (!linha.substring(76, 79).equals("237")) {
                        throw new BoletoException("N\u00famero do Banco inv\u00e1lido.");
                    }
                    numeroRetorno = linha.substring(108, 113);
                }
                if (linha.charAt(0) != '1') continue;
                RemessaRetornoModel remessaRetornoModel = new RemessaRetornoModel();
                remessaRetornoModel.setBoleto(new BoletoModel());
                remessaRetornoModel.getBoleto().setPagador(new Pagador());
                remessaRetornoModel.getBoleto().setBeneficiario(new Beneficiario());
                remessaRetornoModel.getBoleto().setCodRetorno(numeroRetorno);
                remessaRetornoModel.getBoleto().getBeneficiario().setDocumento(linha.substring(3, 17));
                remessaRetornoModel.getBoleto().setNossoNumero(linha.substring(70, 81));
                remessaRetornoModel.getBoleto().setDigitoNossoNumero(linha.substring(81, 82));
                remessaRetornoModel.setOcorrencia(linha.substring(108, 110));
                remessaRetornoModel.getBoleto().setNumeroDocumento(linha.substring(116, 126));
                remessaRetornoModel.getBoleto().setDataVencimento(BoletoUtil.formataStringPadraoDDMMYYParaLocalDate(linha.substring(146, 152)));
                remessaRetornoModel.getBoleto().setValorBoleto(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(152, 165)));
                remessaRetornoModel.setDespesaCobranca(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(175, 188)));
                remessaRetornoModel.setMotivoOcorrencia(linha.substring(318, 328));
                remessaRetornoModel.setAbatimentoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(227, 240)));
                remessaRetornoModel.setDataOcorrencia(BoletoUtil.formataStringPadraoDDMMYYParaLocalDate(linha.substring(110, 116)));
                remessaRetornoModel.setDescontoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(240, 253)));
                remessaRetornoModel.setJuroDeMora(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(266, 279)));
                remessaRetornoModel.setValorEfetivamentePago(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(253, 266)));
                remessaRetornoModel.setDataPrevisaoLancamento(BoletoUtil.formataStringPadraoDDMMYYParaLocalDate(linha.substring(295, 301)));
                list.add(remessaRetornoModel);
            }
        }
        return list;
    }

    private void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        StringBuilder codigoBarras = new StringBuilder();
        codigoBarras.append("2379");
        codigoBarras.append("X");
        codigoBarras.append(BradescoUtil.fatorData(boletoModel.getDataVencimento()));
        codigoBarras.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        StringBuilder campoLivre = new StringBuilder();
        campoLivre.append(StringUtils.leftPad(boletoModel.getBeneficiario().getAgencia(), 4, "0"));
        campoLivre.append(boletoModel.getBeneficiario().getCarteira());
        campoLivre.append(StringUtils.leftPad(boletoModel.getNossoNumero(), 11, "0"));
        campoLivre.append(StringUtils.leftPad(boletoModel.getBeneficiario().getConta(), 7, "0"));
        campoLivre.append("0");
        codigoBarras.append((CharSequence)campoLivre);
        Integer digitoVerificadorGeral = BradescoUtil.modulo11(codigoBarras.toString().replace("X", ""));
        boletoModel.setCodigoBarras(codigoBarras.toString().replace("X", digitoVerificadorGeral.toString()));
        StringBuilder linhaParte1 = new StringBuilder();
        linhaParte1.append("2379");
        linhaParte1.append(campoLivre.toString(), 0, 5);
        linhaParte1.append(BradescoUtil.modulo10(linhaParte1.toString()));
        StringBuilder linhaParte2 = new StringBuilder();
        linhaParte2.append(campoLivre.toString(), 5, 15);
        linhaParte2.append(BradescoUtil.modulo10(linhaParte2.toString()));
        StringBuilder linhaParte3 = new StringBuilder();
        linhaParte3.append(campoLivre.substring(15, 25));
        linhaParte3.append(BradescoUtil.modulo10(linhaParte3.toString()));
        StringBuilder linhaParte4 = new StringBuilder();
        linhaParte4.append(digitoVerificadorGeral);
        StringBuilder linhaParte5 = new StringBuilder();
        linhaParte5.append(codigoBarras.toString(), 5, 19);
        StringBuilder linhaDigitavel = new StringBuilder();
        linhaDigitavel.append(linhaParte1.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte1.toString(), 5, 10);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte2.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte2.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte3.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte3.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte4);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte5);
        boletoModel.setLinhaDigitavel(linhaDigitavel.toString());
        this.validaDadosImpressao(boletoModel);
    }

    private void validaDadosImpressao(BoletoModel boleto) {
        ValidaUtils.validaBoletoModel(boleto, Arrays.asList("locaisDePagamento", "dataVencimento", "beneficiario.nomeBeneficiario", "beneficiario.documento", "beneficiario.agencia", "beneficiario.conta", "dataEmissao", "dataProcessamento", "numeroDocumento", "especieDocumento", "aceite", "nossoNumero", "digitoNossoNumero", "especieMoeda", "valorBoleto", "pagador.nome", "pagador.documento", "pagador.endereco.logradouro", "pagador.endereco.cep", "linhaDigitavel", "codigoBarras", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf", "beneficiario.carteira", "beneficiario.digitoAgencia", "beneficiario.digitoConta", "codigosEmpresa"));
    }
}

