/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.bradesco_cnab400;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BradescoUtil {
    public static String fatorData(LocalDate dataVencimento) {
        LocalDate dataBase = LocalDate.of(1997, 10, 7);
        if (dataVencimento.isAfter(LocalDate.of(2025, 2, 21))) {
            dataBase = dataBase.plusDays(9000L);
        }
        long difDia = ChronoUnit.DAYS.between(dataBase, dataVencimento);
        return StringUtils.leftPad("" + difDia, 4, '0');
    }

    public static String geraDigitoNossoNumero(String carteiraNossoNumero) {
        int s = 0;
        int p = 2;
        int cont = 13;
        for (int i = carteiraNossoNumero.length() - 1; i >= 0; --i) {
            s += Integer.parseInt(carteiraNossoNumero.substring(i, cont)) * p;
            p = p == 7 ? 2 : ++p;
            --cont;
        }
        int r = s % 11;
        switch (r) {
            case 0: {
                return "0";
            }
            case 1: {
                return "P";
            }
        }
        return String.valueOf(11 - r);
    }

    public static Integer modulo11(String codigo) {
        int s = 0;
        int p = 2;
        int cont = 43;
        for (int i = codigo.length() - 1; i >= 0; --i) {
            s += Integer.parseInt(codigo.substring(i, cont)) * p;
            p = p == 9 ? 2 : ++p;
            --cont;
        }
        int r = s % 11;
        int digito = 11 - r;
        return digito == 0 || digito == 1 || digito > 9 ? 1 : digito;
    }

    public static Integer modulo10(String codigo) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < codigo.length(); ++i) {
            int valor = (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
            if (valor > 9) {
                valor -= 9;
            }
            total += valor;
            if (peso == 2) {
                --peso;
                continue;
            }
            ++peso;
        }
        int resto = total < 10 ? total : total % 10;
        int digito = resto == 0 ? 0 : 10 - resto;
        return digito;
    }

    public static Map<String, String> getMapOcorrencia() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("02", "Entrada Confirmada");
            map.put("03", "Entrada Rejeitada");
            map.put("06", "Liquida\u00e7\u00e3o Normal");
            map.put("07", "Conf. Exc. Cadastro Pagador D\u00e9bito");
            map.put("08", "Rej. Ped. Exc. Cadastro de Pagador D\u00e9bito");
            map.put("09", "Baixado Automat. via Arquivo");
            map.put("10", "Baixado conforme instru\u00e7\u00f5es da Ag\u00eancia");
            map.put("11", "Em Ser - Arquivo de T\u00edtulos Pendentes");
            map.put("12", "Abatimento Concedido");
            map.put("13", "Abatimento Cancelado");
            map.put("14", "Vencimento Alterado");
            map.put("15", "Liquida\u00e7\u00e3o em Cart\u00f3rio");
            map.put("16", "T\u00edtulo Pago em Cheque - Vinculado");
            map.put("17", "Liquida\u00e7\u00e3o ap\u00f3s Baixa ou T\u00edtulo n\u00e3o Registrado");
            map.put("18", "Acerto de Deposit\u00e1ria");
            map.put("19", "Confirma\u00e7\u00e3o Receb. Inst. de Protesto");
            map.put("20", "Confirma\u00e7\u00e3o Recebimento Instru\u00e7\u00e3o Susta\u00e7\u00e3o de Protesto");
            map.put("21", "Acerto do Controle do Participante");
            map.put("22", "T\u00edtulo com Pagamento Cancelado");
            map.put("23", "Entrada do T\u00edtulo em Cart\u00f3rio");
            map.put("24", "Entrada Rejeitada por CEP Irregular");
            map.put("25", "Confirma\u00e7\u00e3o Receb.Inst.de Protesto Falimentar");
            map.put("27", "Baixa Rejeitada");
            map.put("28", "D\u00e9bito de Tarifas/Custas");
            map.put("29", "Ocorr\u00eancias do Pagador");
            map.put("30", "Altera\u00e7\u00e3o de Outros Dados Rejeitados");
            map.put("31", "Confirmado Inclus\u00e3o Cadastro Pagador");
            map.put("32", "Instru\u00e7\u00e3o Rejeitada");
            map.put("33", "Confirma\u00e7\u00e3o Pedido Altera\u00e7\u00e3o Outros Dados");
            map.put("34", "Retirado de Cart\u00f3rio e Manuten\u00e7\u00e3o Carteira");
            map.put("35", "Desagendamento do D\u00e9bito Autom\u00e1tico");
            map.put("37", "Rejeitado Inclus\u00e3o Cadastro Pagador");
            map.put("38", "Confirmado Altera\u00e7\u00e3o Pagador");
            map.put("39", "Rejeitado Altera\u00e7\u00e3o Cadastro Pagador");
            map.put("40", "Estorno de Pagamento");
            map.put("55", "Sustado Judicial");
            map.put("68", "Acerto dos Dados do Rateio de Cr\u00e9dito");
            map.put("69", "Cancelamento de Rateio");
            map.put("73", "Confirma\u00e7\u00e3o Receb. Pedido de Negativa\u00e7\u00e3o");
            map.put("74", "Confir Pedido de Excl de Negat");
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static Map<String, String> getMapMotivoOcorrencia(String ocorrencia) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            switch (ocorrencia) {
                case "02": {
                    map.put("00", "Ocorr\u00eancia Aceita");
                    map.put("01", "C\u00f3digo do Banco Inv\u00e1lido");
                    map.put("02", "Pendente de Autoriza\u00e7\u00e3o (Autoriza\u00e7\u00e3o D\u00e9bito Autom\u00e1tico)");
                    map.put("03", "Pendente de A\u00e7\u00e3o do Pagador (Autoriza\u00e7\u00e3o D\u00e9bito Autom\u00e1tico - Data Vencimento)");
                    map.put("04", "C\u00f3digo do Movimento n\u00e3o Permitido para a Carteira");
                    map.put("15", "Caracter\u00edsticas da Cobran\u00e7a Incompat\u00edveis");
                    map.put("17", "Data de Vencimento Anterior \u00e0 Data de Emiss\u00e3o");
                    map.put("21", "Esp\u00e9cie do T\u00edtulo Inv\u00e1lido");
                    map.put("24", "Data da Emiss\u00e3o Inv\u00e1lida");
                    map.put("27", "Valor/Taxa de Juros Mora Inv\u00e1lido");
                    map.put("38", "Prazo para Protesto/Negativa\u00e7\u00e3o Inv\u00e1lido");
                    map.put("39", "Pedido para Protesto/Negativa\u00e7\u00e3o n\u00e3o Permitido para o T\u00edtulo");
                    map.put("43", "Prazo para Baixa e Devolu\u00e7\u00e3o Inv\u00e1lido");
                    map.put("45", "Nome do Pagador Inv\u00e1lido");
                    map.put("46", "Tipo/Num. de Inscri\u00e7\u00e3o do Pagador Inv\u00e1lidos");
                    map.put("47", "Endere\u00e7o do Pagador n\u00e3o Informado");
                    map.put("48", "CEP Inv\u00e1lido");
                    map.put("50", "CEP referente a Banco Correspondente");
                    map.put("53", "N\u00ba de Inscri\u00e7\u00e3o do Pagador/Avalista Inv\u00e1lidos (CPF/CNPJ)");
                    map.put("54", "Benefici\u00e1rio Final n\u00e3o Informado");
                    map.put("67", "D\u00e9bito Autom\u00e1tico Agendado");
                    map.put("68", "D\u00e9bito n\u00e3o Agendado - Erro nos Dados de Remessa");
                    map.put("69", "D\u00e9bito n\u00e3o Agendado - Pagador n\u00e3o Consta no Cadastro de Autorizante");
                    map.put("70", "D\u00e9bito n\u00e3o Agendado - Benefici\u00e1rio n\u00e3o Autorizado pelo Pagador");
                    map.put("71", "D\u00e9bito n\u00e3o Agendado - Benefici\u00e1rio n\u00e3o Participa da Modalidade de D\u00e9b.Autom\u00e1tico");
                    map.put("72", "D\u00e9bito n\u00e3o Agendado - C\u00f3digo de Moeda Diferente de R$");
                    map.put("73", "D\u00e9bito n\u00e3o Agendado - Data de Vencimento Inv\u00e1lida/Vencida");
                    map.put("75", "D\u00e9bito n\u00e3o Agendado - Tipo do N\u00famero de Inscri\u00e7\u00e3o do Pagador Debitado Inv\u00e1lido");
                    map.put("76", "Pagador Eletr\u00f4nico DDA - Esse motivo somente ser\u00e1 disponibilizado no arquivo-retorno para as empresas cadastradas nessa condi\u00e7\u00e3o");
                    map.put("86", "Seu N\u00famero do Documento Inv\u00e1lido");
                    map.put("87", "T\u00edtulo Baixado por Coobriga\u00e7\u00e3o e Devolvido para Carteira");
                    map.put("89", "Email Pagador n\u00e3o Enviado - T\u00edtulo com D\u00e9bito Autom\u00e1tico");
                    map.put("90", "Email Pagador n\u00e3o Enviado - T\u00edtulo de Cobran\u00e7a sem Registro");
                    break;
                }
                case "03": {
                    map.put("00", "Ocorr\u00eancia Aceita");
                    map.put("02", "C\u00f3digo do Registro Detalhe Inv\u00e1lido");
                    map.put("03", "C\u00f3digo da Ocorr\u00eancia Inv\u00e1lida");
                    map.put("04", "C\u00f3digo de Ocorr\u00eancia n\u00e3o Permitida para a Carteira");
                    map.put("05", "C\u00f3digo de Ocorr\u00eancia n\u00e3o Num\u00e9rico");
                    map.put("07", "Ag\u00eancia/Conta/D\u00edgito Inv\u00e1lido");
                    map.put("08", "Nosso N\u00famero Inv\u00e1lido");
                    map.put("09", "Nosso N\u00famero Duplicado");
                    map.put("10", "Carteira Inv\u00e1lida");
                    map.put("13", "Identifica\u00e7\u00e3o da Emiss\u00e3o do Bloqueto Inv\u00e1lida");
                    map.put("16", "Data de Vencimento Inv\u00e1lida");
                    map.put("18", "Vencimento fora do Prazo de Opera\u00e7\u00e3o");
                    map.put("20", "Valor do T\u00edtulo Inv\u00e1lido");
                    map.put("21", "Esp\u00e9cie do T\u00edtulo Inv\u00e1lida");
                    map.put("22", "Esp\u00e9cie n\u00e3o Permitida para a Carteira");
                    map.put("23", "Tipo Pagamento n\u00e3o Contratado");
                    map.put("24", "Data de Emiss\u00e3o Inv\u00e1lida");
                    map.put("27", "Valor/Taxa de Juros Mora Inv\u00e1lido");
                    map.put("28", "C\u00f3digo do Desconto Inv\u00e1lido");
                    map.put("29", "Valor Desconto > ou = Valor T\u00edtulo");
                    map.put("32", "Valor do IOF Inv\u00e1lido");
                    map.put("34", "Valor do Abatimento Maior ou Igual ao Valor do T\u00edtulo");
                    map.put("38", "Prazo para Protesto/Negativa\u00e7\u00e3o Inv\u00e1lido");
                    map.put("39", "Pedido de Protesto/Negativa\u00e7\u00e3o n\u00e3o Permitida para o T\u00edtulo");
                    map.put("44", "C\u00f3digo da Moeda Inv\u00e1lido");
                    map.put("45", "Nome do Pagador n\u00e3o Informado");
                    map.put("46", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Pagador Inv\u00e1lidos");
                    map.put("47", "Endere\u00e7o do Pagador n\u00e3o Informado");
                    map.put("48", "CEP Inv\u00e1lido");
                    map.put("49", "CEP sem Pra\u00e7a de Cobran\u00e7a");
                    map.put("50", "CEP Irregular - Banco Correspondente");
                    map.put("53", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Benefici\u00e1rio Final Inv\u00e1lido");
                    map.put("54", "Sacador/Avalista (Benefici\u00e1rio Final) n\u00e3o Informado");
                    map.put("59", "Valor/Percentual da Multa Inv\u00e1lido");
                    map.put("63", "Entrada para T\u00edtulo j\u00e1 Cadastrado");
                    map.put("65", "Limite Excedido");
                    map.put("66", "N\u00famero Autoriza\u00e7\u00e3o Inexistente");
                    map.put("68", "D\u00e9bito n\u00e3o Agendado - Erro nos Dados de Remessa");
                    map.put("69", "D\u00e9bito n\u00e3o Agendado - Pagador n\u00e3o Consta no Cadastro de Autorizante");
                    map.put("70", "D\u00e9bito n\u00e3o Agendado - Benefici\u00e1rio n\u00e3o Autorizado pelo Pagador");
                    map.put("71", "D\u00e9bito n\u00e3o Agendado - Benefici\u00e1rio n\u00e3o Participa do D\u00e9bito Autom\u00e1tico");
                    map.put("72", "D\u00e9bito n\u00e3o Agendado - C\u00f3digo de Moeda Diferente de R$");
                    map.put("73", "D\u00e9bito n\u00e3o Agendado - Data de Vencimento Inv\u00e1lida/Cadastro Vencido");
                    map.put("74", "D\u00e9bito n\u00e3o Agendado - Conforme seu Pedido, T\u00edtulo n\u00e3o Registrado");
                    map.put("75", "D\u00e9bito n\u00e3o Agendado - Tipo de N\u00famero de Inscri\u00e7\u00e3o do Debitado Inv\u00e1lido");
                    map.put("79", "Data de Juros de Mora Inv\u00e1lida");
                    map.put("80", "Data do Desconto Inv\u00e1lida");
                    map.put("86", "Seu N\u00famero Inv\u00e1lido");
                    map.put("A3", "Benef. Final/ Sacador/Pagador Devem ser Iguais");
                    map.put("A6", "Esp. BDP/Dep\u00f3sito e Aporte, n\u00e3o Aceita Pgto Parcial");
                    break;
                }
                case "06": {
                    map.put("00", "Cr\u00e9dito Dispon\u00edvel");
                    map.put("15", "Cr\u00e9dito Indispon\u00edvel");
                    map.put("18", "Pagamento Parcial");
                    map.put("42", "Rateio n\u00e3o Efetuado, C\u00f3d. C\u00e1lculo 2 (VLR. Registro)");
                    break;
                }
                case "07": {
                    map.put("A0", "Cadastro Exclu\u00eddo pelo Benefici\u00e1rio");
                    map.put("A1", "Cadastro Exclu\u00eddo pelo Pagador");
                    break;
                }
                case "08": {
                    map.put("C0", "Informa\u00e7\u00f5es do Tipo 6 Inv\u00e1lidas");
                    map.put("B9", "Cadastro Pagador n\u00e3o Localizado");
                    break;
                }
                case "09": {
                    map.put("00", "Ocorr\u00eancia Aceita");
                    map.put("10", "Baixa Comandada pelo Cliente");
                    map.put("18", "Pagador n\u00e3o Aceitou o D\u00e9bito (Autoriza\u00e7\u00e3o D\u00e9bito Autom\u00e1tico)");
                    map.put("19", "Pendente de A\u00e7\u00e3o do Pagador (Autoriza\u00e7\u00e3o D\u00e9bito Autom\u00e1tico)");
                    break;
                }
                case "10": {
                    map.put("00", "Baixado Conforme Instru\u00e7\u00f5es da Ag\u00eancia");
                    map.put("14", "T\u00edtulo Protestado");
                    map.put("16", "T\u00edtulo Baixado pelo Banco por Decurso Prazo");
                    map.put("20", "Titulo Baixado e Transferido para Desconto");
                    break;
                }
                case "15": {
                    map.put("00", "Cr\u00e9dito Dispon\u00edvel");
                    map.put("15", "Cr\u00e9dito Indispon\u00edvel");
                    break;
                }
                case "17": {
                    map.put("00", "Cr\u00e9dito Dispon\u00edvel");
                    map.put("15", "Cr\u00e9dito Indispon\u00edvel");
                    break;
                }
                case "24": {
                    map.put("00", "Ocorr\u00eancia Aceita");
                    map.put("48", "CEP Inv\u00e1lido");
                    map.put("49", "CEP sem Pra\u00e7a de Cobran\u00e7a");
                    break;
                }
                case "27": {
                    map.put("00", "Ocorr\u00eancia Aceita");
                    map.put("02", "C\u00f3digo do Registro Detalhe Inv\u00e1lido");
                    map.put("04", "C\u00f3digo de Ocorr\u00eancia n\u00e3o Permitido para a Carteira");
                    map.put("07", "Ag\u00eancia/Conta/D\u00edgito Inv\u00e1lidos");
                    map.put("08", "Nosso N\u00famero Inv\u00e1lido");
                    map.put("09", "Nosso N\u00famero Duplicado");
                    map.put("10", "Carteira Inv\u00e1lida");
                    map.put("15", "Carteira/Ag\u00eancia/Conta/Nosso N\u00famero Inv\u00e1lidos");
                    map.put("16", "Data Vencimento Inv\u00e1lida");
                    map.put("18", "Vencimento Fora do Prazo de Opera\u00e7\u00e3o");
                    map.put("20", "Valor T\u00edtulo Inv\u00e1lido");
                    map.put("40", "T\u00edtulo com Ordem de Protesto Emitido");
                    map.put("42", "C\u00f3digo para Baixa/Devolu\u00e7\u00e3o Inv\u00e1lido");
                    map.put("45", "Nome do Sacado n\u00e3o Informado ou Inv\u00e1lido");
                    map.put("46", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Sacado Inv\u00e1lido");
                    map.put("47", "Endere\u00e7o do Sacado n\u00e3o Informado");
                    map.put("48", "CEP Inv\u00e1lido");
                    map.put("60", "Movimento para T\u00edtulo n\u00e3o Cadastrado");
                    map.put("77", "Transfer\u00eancia para Desconto n\u00e3o Permitido para a Carteira");
                    map.put("85", "T\u00edtulo com Pagamento Vinculado");
                    map.put("86", "Seu N\u00famero Inv\u00e1lido");
                    break;
                }
                case "28": {
                    map.put("02", "Tarifa de Perman\u00eancia T\u00edtulo Cadastrado");
                    map.put("03", "Tarifa de Susta\u00e7\u00e3o/Excl Negativa\u00e7\u00e3o");
                    map.put("04", "Tarifa de Protesto/Incl Negativa\u00e7\u00e3o");
                    map.put("08", "Custas de Protesto");
                    map.put("12", "Tarifa de Registro");
                    map.put("13", "Tarifa T\u00edtulo Pago no Bradesco");
                    map.put("14", "Tarifa T\u00edtulo Pago Compensa\u00e7\u00e3o");
                    map.put("15", "Tarifa T\u00edtulo Baixado n\u00e3o Pago");
                    map.put("16", "Tarifa Altera\u00e7\u00e3o de Vencimento");
                    map.put("17", "Tarifa Concess\u00e3o Abatimento");
                    map.put("18", "Tarifa Cancelamento de Abatimento");
                    map.put("19", "Tarifa Concess\u00e3o Desconto");
                    map.put("20", "Tarifa Cancelamento Desconto");
                    map.put("21", "Tarifa T\u00edtulo Pago CICS");
                    map.put("22", "Tarifa T\u00edtulo Pago Internet");
                    map.put("23", "Tarifa T\u00edtulo Pago Term. Gerencial Servi\u00e7os");
                    map.put("24", "Tarifa T\u00edtulo Pago Pag-Contas");
                    map.put("25", "Tarifa T\u00edtulo Pago Fone F\u00e1cil");
                    map.put("26", "Tarifa T\u00edtulo D\u00e9b. Postagem");
                    map.put("28", "Tarifa T\u00edtulo Pago BDN");
                    map.put("29", "Tarifa T\u00edtulo Pago Term. Multi Fun\u00e7\u00e3o");
                    map.put("32", "Tarifa T\u00edtulo Pago PagFor");
                    map.put("33", "Tarifa Reg/Pgto - Guich\u00ea Caixa");
                    map.put("34", "Tarifa T\u00edtulo Pago Retaguarda");
                    map.put("35", "Tarifa T\u00edtulo Pago Subcentro");
                    map.put("36", "Tarifa T\u00edtulo Pago Cart\u00e3o de Cr\u00e9dito");
                    map.put("37", "Tarifa T\u00edtulo Pago Comp Eletr\u00f4nica");
                    map.put("38", "Tarifa T\u00edtulo Baix. Pg. Cart\u00f3rio");
                    map.put("39", "Tarifa T\u00edtulo Baixado Acerto Bco");
                    map.put("40", "Baixa Registro em Duplicidade");
                    map.put("41", "Tarifa T\u00edtulo Baixado Decurso Prazo");
                    map.put("42", "Tarifa T\u00edtulo Baixado Judicialmente");
                    map.put("43", "Tarifa T\u00edtulo Baixado via Remessa");
                    map.put("44", "Tarifa T\u00edtulo Baixado Rastreamento");
                    map.put("45", "Tarifa T\u00edtulo Baixado Conf. Pedido");
                    map.put("46", "Tarifa T\u00edtulo Baixado Protestado");
                    map.put("47", "Tarifa T\u00edtulo Baixado p/ Devolu\u00e7\u00e3o");
                    map.put("48", "Tarifa T\u00edtulo Baixado Franco Pagto");
                    map.put("49", "Tarifa T\u00edtulo Baixado Sust/Ret/Cart\u00f3rio");
                    map.put("50", "Tarifa T\u00edtulo Baixado Sus/Sem/Rem/Cart\u00f3rio");
                    map.put("51", "Tarifa T\u00edtulo Transferido Desconto");
                    map.put("54", "Tarifa Baixa por Contabilidade");
                    map.put("55", "Tr. Tentativa Cons D\u00e9b Aut");
                    map.put("56", "Tr. Cr\u00e9dito On-Line");
                    map.put("57", "Tarifa Reg/Pagto Bradesco Expresso");
                    map.put("58", "Tarifa Emiss\u00e3o Papeleta");
                    map.put("78", "Tarifa Cadastro Cartela Instru\u00e7\u00e3o Permanente");
                    map.put("80", "Tarifa Parcial Pagamento Compensa\u00e7\u00e3o");
                    map.put("81", "Tarifa Reapresenta\u00e7\u00e3o Autom\u00e1tica T\u00edtulo");
                    map.put("82", "Tarifa Registro T\u00edtulo D\u00e9b. Autom\u00e1tico");
                    map.put("83", "Tarifa Rateio de Cr\u00e9dito");
                    map.put("89", "Tarifa Parcial Pagamento Bradesco");
                    map.put("96", "Tarifa Reg. Pagto Outras M\u00eddias");
                    map.put("97", "Tarifa Reg/Pagto - Net Empresa");
                    map.put("98", "Tarifa T\u00edtulo Pago Vencido");
                    map.put("99", "Tr.T\u00edt. Baixado por Decurso Prazo");
                    break;
                }
                case "29": {
                    map.put("78", "Pagador Alega que Faturamento \u00e9 Indevido");
                    map.put("95", "Pagador Aceita/Reconhece Faturamento");
                    break;
                }
                case "30": {
                    map.put("00", "Ocorr\u00eancia Aceita");
                    map.put("01", "C\u00f3digo do Banco Inv\u00e1lido");
                    map.put("04", "C\u00f3digo de Ocorr\u00eancia n\u00e3o Permitido para a Carteira");
                    map.put("05", "C\u00f3digo da Ocorr\u00eancia n\u00e3o Num\u00e9rico");
                    map.put("08", "Nosso N\u00famero Inv\u00e1lido");
                    map.put("15", "Caracter\u00edstica da Cobran\u00e7a Incompat\u00edvel");
                    map.put("16", "Data de Vencimento Inv\u00e1lido");
                    map.put("17", "Data de Vencimento Anterior \u00e0 Data de Emiss\u00e3o");
                    map.put("18", "Vencimento Fora do Prazo de Opera\u00e7\u00e3o");
                    map.put("20", "Valor T\u00edtulo Inv\u00e1lido");
                    map.put("21", "Esp\u00e9cie T\u00edtulo Inv\u00e1lida");
                    map.put("22", "Esp\u00e9cie n\u00e3o Permitida para a Carteira");
                    map.put("23", "Tipo Pagamento n\u00e3o Contratado");
                    map.put("24", "Data de Emiss\u00e3o Inv\u00e1lida");
                    map.put("26", "C\u00f3digo de Juros de Mora Inv\u00e1lido");
                    map.put("27", "Valor/Taxa de Juros de Mora Inv\u00e1lido");
                    map.put("28", "C\u00f3digo de Desconto Inv\u00e1lido");
                    map.put("29", "Valor do Desconto Maior/Igual ao Valor do T\u00edtulo");
                    map.put("30", "Desconto a Conceder n\u00e3o Confere");
                    map.put("31", "Concess\u00e3o de Desconto j\u00e1 Existente (Desconto Anterior)");
                    map.put("32", "Valor do IOF Inv\u00e1lido");
                    map.put("33", "Valor do Abatimento Inv\u00e1lido");
                    map.put("34", "Valor do Abatimento Maior/Igual ao Valor do T\u00edtulo");
                    map.put("36", "Concess\u00e3o Abatimento");
                    map.put("38", "Prazo para Protesto/ Negativa\u00e7\u00e3o Inv\u00e1lido");
                    map.put("39", "Pedido para Protesto/ Negativa\u00e7\u00e3o n\u00e3o Permitido para o T\u00edtulo");
                    map.put("40", "T\u00edtulo com Ordem/Pedido de Protesto/Negativa\u00e7\u00e3o Emitido");
                    map.put("42", "C\u00f3digo para Baixa/Devolu\u00e7\u00e3o Inv\u00e1lido");
                    map.put("43", "Prazo para Baixa/Devolu\u00e7\u00e3o Inv\u00e1lido");
                    map.put("46", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Pagador Inv\u00e1lidos");
                    map.put("48", "CEP Inv\u00e1lido");
                    map.put("53", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Pagador/Avalista Inv\u00e1lidos");
                    map.put("54", "Pagador/Avalista n\u00e3o Informado");
                    map.put("57", "C\u00f3digo da Multa Inv\u00e1lido");
                    map.put("58", "Data da Multa Inv\u00e1lida");
                    map.put("60", "Movimento para T\u00edtulo n\u00e3o Cadastrado");
                    map.put("79", "Data de Juros de Mora Inv\u00e1lida");
                    map.put("80", "Data do Desconto Inv\u00e1lida");
                    map.put("85", "T\u00edtulo com Pagamento Vinculado");
                    map.put("88", "E-mail Pagador n\u00e3o Lido no Prazo 5 Dias");
                    map.put("91", "E-mail Pagador n\u00e3o Recebido");
                    map.put("C0", "Informa\u00e7\u00f5es do Tipo 6 Inv\u00e1lidas");
                    map.put("C1", "Informa\u00e7\u00f5es do Tipo 6 Divergentes do Cadastro");
                    break;
                }
                case "32": {
                    map.put("00", "Ocorr\u00eancia Aceita");
                    map.put("01", "C\u00f3digo do Banco Inv\u00e1lido");
                    map.put("02", "C\u00f3digo Registro Detalhe Inv\u00e1lido");
                    map.put("04", "C\u00f3digo de Ocorr\u00eancia n\u00e3o Permitido para a Carteira");
                    map.put("05", "C\u00f3digo de Ocorr\u00eancia n\u00e3o Num\u00e9rico");
                    map.put("06", "Esp\u00e9cie BDP, n\u00e3o Aceita Pagamento Parcial");
                    map.put("07", "Ag\u00eancia/Conta/D\u00edgito Inv\u00e1lidos");
                    map.put("08", "Nosso N\u00famero Inv\u00e1lido");
                    map.put("10", "Carteira Inv\u00e1lida");
                    map.put("15", "Caracter\u00edsticas da Cobran\u00e7a Incompat\u00edveis");
                    map.put("16", "Data de Vencimento Inv\u00e1lida");
                    map.put("17", "Data de Vencimento Anterior \u00e0 Data de Emiss\u00e3o");
                    map.put("18", "Vencimento Fora do Prazo de Opera\u00e7\u00e3o");
                    map.put("20", "Valor do T\u00edtulo Inv\u00e1lido");
                    map.put("21", "Esp\u00e9cie do T\u00edtulo Inv\u00e1lida");
                    map.put("22", "Esp\u00e9cie n\u00e3o Permitida para a Carteira");
                    map.put("23", "Tipo Pagamento n\u00e3o Contratado");
                    map.put("24", "Data de Emiss\u00e3o Inv\u00e1lida");
                    map.put("26", "C\u00f3digo Juros Mora Inv\u00e1lido");
                    map.put("27", "Valor/Taxa Juros Mira Inv\u00e1lido");
                    map.put("28", "C\u00f3digo de Desconto Inv\u00e1lido");
                    map.put("29", "Valor do Desconto Maior/Igual ao Valor do T\u00edtulo");
                    map.put("30", "Desconto a Conceder n\u00e3o Confere");
                    map.put("31", "Concess\u00e3o de Desconto - J\u00e1 Existe Desconto Anterior");
                    map.put("33", "Valor do Abatimento Inv\u00e1lido");
                    map.put("34", "Valor do Abatimento Maior/Igual ao Valor do T\u00edtulo");
                    map.put("36", "Concess\u00e3o Abatimento - J\u00e1 Existe Abatimento Anterior");
                    map.put("38", "Prazo para Protesto/Negativa\u00e7\u00e3o Inv\u00e1lido");
                    map.put("39", "Pedido para Protesto/Negativa\u00e7\u00e3o n\u00e3o Permitido para o T\u00edtulo");
                    map.put("40", "T\u00edtulo com Ordem/Pedido de Protesto/Negativa\u00e7\u00e3o Emitido");
                    map.put("41", "Pedido de Susta\u00e7\u00e3o/Excl p/ T\u00edtulo sem Instru\u00e7\u00e3o de Protesto/Negativa\u00e7\u00e3o");
                    map.put("45", "Nome do Pagador n\u00e3o Informado");
                    map.put("46", "Tipo/N\u00famero de Inscri\u00e7\u00e3o do Pagador Inv\u00e1lidos");
                    map.put("47", "Endere\u00e7o do Pagador n\u00e3o Informado");
                    map.put("48", "CEP Inv\u00e1lido");
                    map.put("50", "CEP referente a um Banco Correspondente");
                    map.put("52", "Unidade da Federa\u00e7\u00e3o Inv\u00e1lida");
                    map.put("53", "Tipo de Inscri\u00e7\u00e3o do Pagador Avalista Inv\u00e1lidos");
                    map.put("60", "Movimento para T\u00edtulo n\u00e3o Cadastrado");
                    map.put("65", "Limite Excedido");
                    map.put("66", "N\u00famero Autoriza\u00e7\u00e3o Inexistente");
                    map.put("85", "T\u00edtulo com Pagamento Vinculado");
                    map.put("86", "Seu N\u00famero Inv\u00e1lido");
                    map.put("94", "T\u00edtulo Cess\u00e3o Fiduci\u00e1ria - Instru\u00e7\u00e3o N\u00e3o Liberada pela Ag\u00eancia");
                    map.put("97", "Instru\u00e7\u00e3o n\u00e3o Permitida T\u00edtulo Negativado");
                    map.put("98", "Inclus\u00e3o Bloqueada face \u00e0 Determina\u00e7\u00e3o Judicial");
                    map.put("99", "Telefone Benefici\u00e1rio n\u00e3o Informado / Inconsistente");
                    break;
                }
                case "35": {
                    map.put("81", "Tentativas Esgotadas, Baixado");
                    map.put("82", "Tentativas Esgotadas, Pendente");
                    map.put("83", "Cancelado pelo Pagador e Mantido Pendente, Conforme Negocia\u00e7\u00e3o");
                    map.put("84", "Cancelado pelo Pagador e Baixado, Conforme Negocia\u00e7\u00e3o");
                    break;
                }
                case "37": 
                case "39": {
                    map.put("C0", "Informa\u00e7\u00f5es do Tipo 6 Inv\u00e1lidas");
                    map.put("C1", "Informa\u00e7\u00f5es do Tipo 6 Divergentes do Cadastro");
                }
            }
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static boolean isASCIIBradesco(char ch) {
        if (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9') {
            return true;
        }
        if (ch == ' ' || ch == '!' || ch == '#' || ch == '$' || ch == '%' || ch == '&' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == '-' || ch == '.' || ch == '/' || ch == ':' || ch == ';' || ch == '@' || ch == '[' || ch == '\\' || ch == ']' || ch == '{' || ch == '}') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        return ch == '\n' || ch == '\r';
    }
}

