/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.pjbank_api.recebimento;

import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.enums.StatusPagamentoBoleto;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.PJBankClient;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.auth.PJBankAuthenticatedService;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.exceptions.PJBankException;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.models.recebimento.ExtratoBoleto;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class BoletosManager
extends PJBankAuthenticatedService {
    private String endPoint = "recebimentos/{{credencial}}";

    public BoletosManager(String credencial, String chave) {
        super(credencial, chave);
        this.endPoint = this.endPoint.replace("{{credencial}}", credencial);
    }

    public BoletoModel create(BoletoModel boletoModel) throws IOException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes"));
        HttpPost httpPost = client.getHttpPostClient();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        JSONObject params = new JSONObject();
        params.put("vencimento", dateFormat.format(boletoModel.getDataVencimento()));
        params.put("valor", boletoModel.getValorBoleto());
        params.put("juros", boletoModel.getValorJuros());
        params.put("dias_juros", boletoModel.getDiasJuros());
        params.put("multa", boletoModel.getValorMulta());
        params.put("dias_multa", boletoModel.getDiasMulta());
        params.put("desconto", boletoModel.getValorDescontos());
        params.put("nome_cliente", boletoModel.getPagador().getNome());
        params.put("cpf_cliente", boletoModel.getPagador().getDocumento());
        params.put("endereco_cliente", boletoModel.getPagador().getEndereco().getLogradouro());
        params.put("numero_cliente", boletoModel.getPagador().getEndereco().getNumero());
        params.put("complemento_cliente", boletoModel.getPagador().getEndereco().getComplemento());
        params.put("bairro_cliente", boletoModel.getPagador().getEndereco().getBairro());
        params.put("cidade_cliente", boletoModel.getPagador().getEndereco().getCidade());
        params.put("estado_cliente", boletoModel.getPagador().getEndereco().getUf());
        params.put("cep_cliente", boletoModel.getPagador().getEndereco().getCep());
        params.put("logo_url", boletoModel.getLogoUrl());
        params.put("texto", boletoModel.getDescricoes());
        params.put("grupo", boletoModel.getGrupo());
        params.put("pedido_numero", boletoModel.getNumeroDocumento());
        httpPost.setEntity(new StringEntity(params.toString(), StandardCharsets.UTF_8));
        String response = EntityUtils.toString(client.doRequest(httpPost).getEntity());
        JSONObject responseObject = new JSONObject(response);
        boletoModel.setNossoNumero(responseObject.getString("nossonumero"));
        boletoModel.setLinkBoleto(responseObject.getString("linkBoleto"));
        boletoModel.setLinkGrupo(responseObject.getString("linkGrupo"));
        boletoModel.setLinhaDigitavel(responseObject.getString("linhaDigitavel"));
        return boletoModel;
    }

    public String getByIds(Set<String> pedidos) throws IOException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes/lotes"));
        HttpPost httpPost = client.getHttpPostClient();
        httpPost.addHeader("x-chave", this.getChave());
        JSONArray pedidosArray = new JSONArray((Collection<?>)pedidos);
        JSONObject params = new JSONObject();
        params.put("pedido_numero", pedidosArray);
        httpPost.setEntity(new StringEntity(params.toString(), StandardCharsets.UTF_8));
        String response = EntityUtils.toString(client.doRequest(httpPost).getEntity());
        JSONObject responseObject = new JSONObject(response);
        return responseObject.getString("linkBoleto");
    }

    public List<ExtratoBoleto> get(Date inicio, Date fim, StatusPagamentoBoleto pago) throws URISyntaxException, IOException, PJBankException, ParseException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes"));
        HttpGet httpGet = client.getHttpGetClient();
        httpGet.addHeader("x-chave", this.getChave());
        this.adicionarFiltros(httpGet, inicio, fim, pago);
        String response = EntityUtils.toString(client.doRequest(httpGet).getEntity());
        JSONArray extratoObject = new JSONArray(response);
        int totalItensExtrato = extratoObject.length();
        ArrayList<ExtratoBoleto> extratos = new ArrayList<ExtratoBoleto>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        for (int i = 0; i < totalItensExtrato; ++i) {
            String dataCredito;
            String dataPagamento;
            JSONObject itemExtrato = extratoObject.getJSONObject(i);
            ExtratoBoleto extrato = new ExtratoBoleto(itemExtrato.getDouble("valor"), itemExtrato.optDouble("valor_pago", 0.0), itemExtrato.getDouble("valor_liquido"), itemExtrato.optDouble("valor_tarifa", 0.0), itemExtrato.getString("nosso_numero"), itemExtrato.getString("nosso_numero_original"), itemExtrato.getString("banco_numero"), itemExtrato.getString("token_facilitador"));
            String dataVencimento = itemExtrato.getString("data_vencimento");
            if (!StringUtils.isBlank(dataVencimento)) {
                extrato.setDataVencimento(dateFormat.parse(dataVencimento));
            }
            if (!StringUtils.isBlank(dataPagamento = itemExtrato.getString("data_pagamento"))) {
                extrato.setDataPagamento(dateFormat.parse(dataPagamento));
            }
            if (!StringUtils.isBlank(dataCredito = itemExtrato.getString("data_credito"))) {
                extrato.setDataCredito(dateFormat.parse(dataCredito));
            }
            extratos.add(extrato);
        }
        return extratos;
    }

    private void adicionarFiltros(HttpRequestBase httpRequestClient, Date inicio, Date fim, StatusPagamentoBoleto pago) throws URISyntaxException {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        URIBuilder uriBuilder = new URIBuilder(httpRequestClient.getURI());
        uriBuilder.addParameter("data_inicio", formatter.format(inicio));
        uriBuilder.addParameter("data_fim", formatter.format(fim));
        uriBuilder.addParameter("pago", pago.getName());
        httpRequestClient.setURI(uriBuilder.build());
    }
}

