/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.pjbank_api.recebimento;

import br.com.java_brasil.boleto.model.enums.FormaRecebimento;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.PJBankClient;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.exceptions.PJBankException;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.models.recebimento.CredencialRecebimento;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class Credenciamento {
    private String endPoint = "recebimentos";

    public CredencialRecebimento create(String nomeEmpresa, String bancoRepasse, String agenciaRepasse, String contaRepasse, String cnpj, int ddd, int telefone, String email, FormaRecebimento formaRecebimento) throws IOException, PJBankException {
        return this.create(nomeEmpresa, bancoRepasse, agenciaRepasse, contaRepasse, cnpj, ddd, telefone, email, formaRecebimento, null);
    }

    public CredencialRecebimento create(String nomeEmpresa, String bancoRepasse, String agenciaRepasse, String contaRepasse, String cnpj, int ddd, int telefone, String email, FormaRecebimento formaRecebimento, String agenciaParceiro) throws IOException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint);
        HttpPost httpPost = client.getHttpPostClient();
        JSONObject params = new JSONObject();
        params.put("nome_empresa", nomeEmpresa);
        params.put("banco_repasse", bancoRepasse);
        params.put("agencia_repasse", agenciaRepasse);
        params.put("conta_repasse", contaRepasse);
        params.put("cnpj", cnpj);
        params.put("ddd", String.valueOf(ddd));
        params.put("telefone", String.valueOf(telefone));
        params.put("email", email);
        params.put("cartao", formaRecebimento == FormaRecebimento.CARTAO_CREDITO);
        if (agenciaParceiro != null) {
            params.put("agencia", agenciaParceiro);
        }
        httpPost.setEntity(new StringEntity(params.toString(), StandardCharsets.UTF_8));
        String response = EntityUtils.toString(client.doRequest(httpPost).getEntity());
        JSONObject responseObject = new JSONObject(response);
        return new CredencialRecebimento(responseObject.getString("credencial"), responseObject.getString("chave"), responseObject.getString("conta_virtual"), responseObject.getString("agencia_virtual"));
    }
}

