/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicoob_cnab240;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.Beneficiario;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Pagador;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.TipoDescontoEnum;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.model.enums.TipoMultaEnum;
import br.com.java_brasil.boleto.service.bancos.sicoob_cnab240.SicoobUtil;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang3.StringUtils;

public class BancoSicoobCnab240
extends BoletoController {
    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            boletos.forEach(this::preparaValidaBoletoImpressao);
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        return this.gerarArquivo(remessaRetornoModel);
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        return this.importarArquivo(arquivo);
    }

    public String gerarArquivo(List<RemessaRetornoModel> list) {
        list.forEach(boleto -> ValidaUtils.validaBoletoModel(boleto.getBoleto(), this.getConfiguracao().camposObrigatoriosBoleto()));
        Integer contador = 0;
        Integer contadorLinhas = 0;
        BigDecimal valorTotalTitulos = BigDecimal.ZERO;
        StringBuilder linhaArquivo = new StringBuilder();
        Object object = contadorLinhas;
        Integer n = contadorLinhas = Integer.valueOf(contadorLinhas + 1);
        linhaArquivo.append("756");
        linhaArquivo.append("0000");
        linhaArquivo.append("0");
        linhaArquivo.append(StringUtils.repeat(" ", 9));
        linhaArquivo.append(list.get(0).getBoleto().getBeneficiario().isClienteCpf() ? "1" : "2");
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getDocumento(), 14, "0"));
        linhaArquivo.append(StringUtils.rightPad(" ", 20, " "));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getAgencia(), 5, "0"));
        linhaArquivo.append(StringUtils.rightPad(list.get(0).getBoleto().getBeneficiario().getDigitoAgencia(), 1, " "));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 12, "0"));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getDigitoConta(), 1, "0"));
        linhaArquivo.append("0");
        linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(list.get(0).getBoleto().getBeneficiario().getNomeBeneficiario(), 30), 30, " "));
        linhaArquivo.append(StringUtils.rightPad("SICOOB", 30, " "));
        linhaArquivo.append(StringUtils.repeat(" ", 10));
        linhaArquivo.append("1");
        linhaArquivo.append(BoletoUtil.getDataFormato(LocalDate.now(), "ddMMyyyy"));
        linhaArquivo.append(BoletoUtil.getHoraFormato(LocalTime.now(), "HHmmss"));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getNumeroRemessa(), 6, "0"));
        linhaArquivo.append("081");
        linhaArquivo.append("00000");
        linhaArquivo.append(StringUtils.repeat(" ", 20));
        linhaArquivo.append(StringUtils.repeat(" ", 20));
        linhaArquivo.append(StringUtils.repeat(" ", 29));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        object = contadorLinhas;
        Integer n2 = contadorLinhas = Integer.valueOf(contadorLinhas + 1);
        linhaArquivo.append("756");
        linhaArquivo.append("0001");
        linhaArquivo.append("1");
        linhaArquivo.append("R");
        linhaArquivo.append("01");
        linhaArquivo.append(StringUtils.repeat(" ", 2));
        linhaArquivo.append("040");
        linhaArquivo.append(" ");
        linhaArquivo.append(list.get(0).getBoleto().getBeneficiario().isClienteCpf() ? "1" : "2");
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getDocumento(), 15, "0"));
        linhaArquivo.append(StringUtils.repeat(" ", 20));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getAgencia(), 5, "0"));
        linhaArquivo.append(StringUtils.rightPad(list.get(0).getBoleto().getBeneficiario().getDigitoAgencia(), 1, " "));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 12, "0"));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getDigitoConta(), 1, "0"));
        linhaArquivo.append(" ");
        linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(list.get(0).getBoleto().getBeneficiario().getNomeBeneficiario(), 30), 30, " "));
        linhaArquivo.append(StringUtils.repeat(" ", 40));
        linhaArquivo.append(StringUtils.repeat(" ", 40));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getNumeroRemessa(), 8, "0"));
        linhaArquivo.append(BoletoUtil.getDataFormato(LocalDate.now(), "ddMMyyyy"));
        linhaArquivo.append(StringUtils.repeat("0", 8));
        linhaArquivo.append(StringUtils.repeat(" ", 33));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        for (RemessaRetornoModel remessaRetornoModel : list) {
            Comparable<ChronoLocalDate> dataParaInicioJuros;
            Integer n3 = contador;
            Integer n4 = contador = Integer.valueOf(contador + 1);
            n3 = contadorLinhas;
            n4 = contadorLinhas = Integer.valueOf(contadorLinhas + 1);
            linhaArquivo.append("756");
            linhaArquivo.append("0001");
            linhaArquivo.append("3");
            linhaArquivo.append(StringUtils.leftPad(contador.toString(), 5, "0"));
            linhaArquivo.append("P");
            linhaArquivo.append(" ");
            if (SicoobUtil.isRemessaInstrucaoInvalida(remessaRetornoModel.getInstrucao())) {
                throw new BoletoException("Instru\u00e7\u00e3o [" + remessaRetornoModel.getInstrucao() + "] da remessa incorreta!");
            }
            linhaArquivo.append(StringUtils.leftPad(remessaRetornoModel.getInstrucao(), 2, "0"));
            linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getAgencia(), 5, "0"));
            linhaArquivo.append(StringUtils.rightPad(list.get(0).getBoleto().getBeneficiario().getDigitoAgencia(), 1, " "));
            linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 12, "0"));
            linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getDigitoConta(), 1, "0"));
            linhaArquivo.append(" ");
            String nossoNumeroEnvio = StringUtils.leftPad(remessaRetornoModel.getBoleto().getNossoNumero(), 9, "0");
            nossoNumeroEnvio = nossoNumeroEnvio + remessaRetornoModel.getBoleto().getDigitoNossoNumero();
            nossoNumeroEnvio = nossoNumeroEnvio + StringUtils.leftPad(String.valueOf(remessaRetornoModel.getBoleto().getNumeroDaParcelaCarne()), 2, "0");
            nossoNumeroEnvio = nossoNumeroEnvio + "014";
            linhaArquivo.append(StringUtils.rightPad(nossoNumeroEnvio, 20, " "));
            linhaArquivo.append(remessaRetornoModel.getBoleto().getBeneficiario().getCarteira());
            linhaArquivo.append("0");
            linhaArquivo.append(" ");
            linhaArquivo.append(remessaRetornoModel.getPostagemTitulo());
            linhaArquivo.append(remessaRetornoModel.getImpressaoTitulo());
            linhaArquivo.append(StringUtils.rightPad(remessaRetornoModel.getBoleto().getNumeroDocumento(), 15, " "));
            linhaArquivo.append(BoletoUtil.getDataFormato(remessaRetornoModel.getBoleto().getDataVencimento(), "ddMMyyyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(remessaRetornoModel.getBoleto().getValorBoleto(), 2, 15));
            valorTotalTitulos = valorTotalTitulos.add(remessaRetornoModel.getBoleto().getValorBoleto());
            linhaArquivo.append("00000");
            linhaArquivo.append(" ");
            if (SicoobUtil.isEspecieDoTituloInvalida(remessaRetornoModel.getBoleto().getEspecieDocumento())) {
                throw new BoletoException("Esp\u00e9cie do t\u00edtulo [" + remessaRetornoModel.getBoleto().getEspecieDocumento() + "] incorreta!");
            }
            linhaArquivo.append(StringUtils.leftPad(remessaRetornoModel.getBoleto().getEspecieDocumento(), 2, "0"));
            linhaArquivo.append(remessaRetornoModel.getBoleto().isAceite() ? "A" : "N");
            linhaArquivo.append(BoletoUtil.getDataFormato(remessaRetornoModel.getBoleto().getDataEmissao(), "ddMMyyyy"));
            if (!remessaRetornoModel.getBoleto().getTipoJuros().equals((Object)TipoJurosEnum.ISENTO) && BoletoUtil.isNotNullEMaiorQZero(remessaRetornoModel.getBoleto().getValorPercentualJuros())) {
                linhaArquivo.append(remessaRetornoModel.getBoleto().getTipoJuros().equals((Object)TipoJurosEnum.VALOR_DIA) ? "1" : "2");
                if (remessaRetornoModel.getBoleto().getDiasJuros() > 0) {
                    dataParaInicioJuros = BoletoUtil.adicionarDiasData(remessaRetornoModel.getBoleto().getDataVencimento(), remessaRetornoModel.getBoleto().getDiasJuros());
                    linhaArquivo.append(BoletoUtil.getDataFormato(dataParaInicioJuros, "ddMMyyyy"));
                } else {
                    linhaArquivo.append(BoletoUtil.getDataFormato(remessaRetornoModel.getBoleto().getDataVencimento(), "ddMMyyyy"));
                }
                linhaArquivo.append(BoletoUtil.formatarValorSemPonto(remessaRetornoModel.getBoleto().getValorPercentualJuros(), 2, 15));
            } else {
                linhaArquivo.append("0");
                linhaArquivo.append(StringUtils.repeat("0", 8));
                linhaArquivo.append(StringUtils.repeat("0", 15));
            }
            if (BoletoUtil.isNotNullEMaiorQZero(remessaRetornoModel.getBoleto().getValorPercentualDescontos())) {
                linhaArquivo.append(remessaRetornoModel.getBoleto().getTipoDesconto().equals((Object)TipoDescontoEnum.VALOR_FIXO) ? "1" : "2");
            } else {
                linhaArquivo.append("0");
            }
            linhaArquivo.append(remessaRetornoModel.getBoleto().getDataLimiteParaDesconto() == null ? "00000000" : BoletoUtil.getDataFormato(remessaRetornoModel.getBoleto().getDataLimiteParaDesconto(), "ddMMyyyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(remessaRetornoModel.getBoleto().getValorPercentualDescontos(), 2, 15));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(remessaRetornoModel.getBoleto().getValorIof(), 2, 15));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(remessaRetornoModel.getBoleto().getValorDeducoes(), 2, 15));
            linhaArquivo.append(StringUtils.repeat(" ", 25));
            linhaArquivo.append(remessaRetornoModel.getBoleto().isProtesto() ? "1" : "3");
            linhaArquivo.append(StringUtils.leftPad(String.valueOf(remessaRetornoModel.getBoleto().getDiasProtesto()), 2, '0'));
            linhaArquivo.append("0");
            linhaArquivo.append(StringUtils.repeat(" ", 3));
            linhaArquivo.append("09");
            linhaArquivo.append(StringUtils.repeat("0", 10));
            linhaArquivo.append(" ");
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
            dataParaInicioJuros = contadorLinhas;
            Integer n5 = contadorLinhas = Integer.valueOf(contadorLinhas + 1);
            linhaArquivo.append("756");
            linhaArquivo.append("0001");
            linhaArquivo.append("3");
            dataParaInicioJuros = contador;
            n5 = contador = Integer.valueOf(contador + 1);
            linhaArquivo.append(StringUtils.leftPad(contador.toString(), 5, "0"));
            linhaArquivo.append("Q");
            linhaArquivo.append(" ");
            linhaArquivo.append(StringUtils.leftPad(remessaRetornoModel.getInstrucao(), 2, "0"));
            linhaArquivo.append(remessaRetornoModel.getBoleto().getPagador().isClienteCpf() ? "1" : "2");
            linhaArquivo.append(StringUtils.leftPad(remessaRetornoModel.getBoleto().getPagador().getDocumento(), 15, "0"));
            linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(remessaRetornoModel.getBoleto().getPagador().getNome(), 40), 40, " "));
            String enderecoCompleto = remessaRetornoModel.getBoleto().getPagador().getEndereco().getLogradouro();
            enderecoCompleto = enderecoCompleto + ", " + remessaRetornoModel.getBoleto().getPagador().getEndereco().getNumero();
            if (remessaRetornoModel.getBoleto().getPagador().getEndereco().getComplemento() != null) {
                enderecoCompleto = enderecoCompleto + " " + remessaRetornoModel.getBoleto().getPagador().getEndereco().getComplemento();
            }
            linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(enderecoCompleto, 40), 40, " "));
            linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(remessaRetornoModel.getBoleto().getPagador().getEndereco().getBairro(), 15), 15, " "));
            linhaArquivo.append(StringUtils.leftPad(remessaRetornoModel.getBoleto().getPagador().getEndereco().getCep(), 8, "0"));
            linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(remessaRetornoModel.getBoleto().getPagador().getEndereco().getCidade(), 15), 15, " "));
            linhaArquivo.append(remessaRetornoModel.getBoleto().getPagador().getEndereco().getUf());
            if (remessaRetornoModel.getBoleto().getBeneficiarioFinal() != null) {
                linhaArquivo.append(remessaRetornoModel.getBoleto().getBeneficiarioFinal().isClienteCpf() ? "1" : "2");
                linhaArquivo.append(StringUtils.leftPad(remessaRetornoModel.getBoleto().getBeneficiarioFinal().getDocumento(), 15, "0"));
                linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(remessaRetornoModel.getBoleto().getBeneficiarioFinal().getNome(), 40), 40, " "));
            } else {
                linhaArquivo.append("0");
                linhaArquivo.append(StringUtils.repeat("0", 15));
                linhaArquivo.append(StringUtils.repeat(" ", 40));
            }
            linhaArquivo.append("000");
            linhaArquivo.append(StringUtils.repeat(" ", 20));
            linhaArquivo.append(StringUtils.repeat(" ", 8));
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
            n5 = contadorLinhas;
            Integer n6 = contadorLinhas = Integer.valueOf(contadorLinhas + 1);
            linhaArquivo.append("756");
            linhaArquivo.append("0001");
            linhaArquivo.append("3");
            n5 = contador;
            n6 = contador = Integer.valueOf(contador + 1);
            linhaArquivo.append(StringUtils.leftPad(contador.toString(), 5, "0"));
            linhaArquivo.append("R");
            linhaArquivo.append(StringUtils.repeat(" ", 1));
            linhaArquivo.append(StringUtils.leftPad(remessaRetornoModel.getInstrucao(), 2, "0"));
            if (BoletoUtil.isNotNullEMaiorQZero(remessaRetornoModel.getBoleto().getValorPercentualDescontos2())) {
                linhaArquivo.append(remessaRetornoModel.getBoleto().getTipoDesconto().equals((Object)TipoDescontoEnum.VALOR_FIXO) ? "1" : "2");
            } else {
                linhaArquivo.append("0");
            }
            linhaArquivo.append(remessaRetornoModel.getBoleto().getDataLimiteParaDesconto2() == null ? "00000000" : BoletoUtil.getDataFormato(remessaRetornoModel.getBoleto().getDataLimiteParaDesconto2(), "ddMMyyyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(remessaRetornoModel.getBoleto().getValorPercentualDescontos2(), 2, 15));
            if (BoletoUtil.isNotNullEMaiorQZero(remessaRetornoModel.getBoleto().getValorPercentualDescontos3())) {
                linhaArquivo.append(remessaRetornoModel.getBoleto().getTipoDesconto().equals((Object)TipoDescontoEnum.VALOR_FIXO) ? "1" : "2");
            } else {
                linhaArquivo.append("0");
            }
            linhaArquivo.append(remessaRetornoModel.getBoleto().getDataLimiteParaDesconto3() == null ? "00000000" : BoletoUtil.getDataFormato(remessaRetornoModel.getBoleto().getDataLimiteParaDesconto3(), "ddMMyyyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(remessaRetornoModel.getBoleto().getValorPercentualDescontos3(), 2, 15));
            if (BoletoUtil.isNotNullEMaiorQZero(remessaRetornoModel.getBoleto().getValorPercentualMulta())) {
                linhaArquivo.append(remessaRetornoModel.getBoleto().getTipoMulta().equals((Object)TipoMultaEnum.VALOR) ? "1" : "2");
            } else {
                linhaArquivo.append("0");
            }
            if (remessaRetornoModel.getBoleto().getDiasMulta() > 0 && BoletoUtil.isNotNullEMaiorQZero(remessaRetornoModel.getBoleto().getValorPercentualMulta())) {
                LocalDate dataParaInicioMulta = BoletoUtil.adicionarDiasData(remessaRetornoModel.getBoleto().getDataVencimento(), remessaRetornoModel.getBoleto().getDiasMulta());
                linhaArquivo.append(BoletoUtil.getDataFormato(dataParaInicioMulta, "ddMMyyyy"));
            } else {
                linhaArquivo.append(StringUtils.repeat("0", 8));
            }
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(remessaRetornoModel.getBoleto().getValorPercentualMulta(), 2, 15));
            linhaArquivo.append(StringUtils.repeat(" ", 10));
            linhaArquivo.append(StringUtils.repeat(" ", 40));
            linhaArquivo.append(StringUtils.repeat(" ", 40));
            linhaArquivo.append(StringUtils.repeat(" ", 20));
            linhaArquivo.append("00000000");
            linhaArquivo.append(StringUtils.repeat("0", 3));
            linhaArquivo.append(StringUtils.repeat("0", 5));
            linhaArquivo.append(" ");
            linhaArquivo.append(StringUtils.repeat("0", 12));
            linhaArquivo.append(" ");
            linhaArquivo.append(" ");
            linhaArquivo.append("0");
            linhaArquivo.append(StringUtils.repeat(" ", 9));
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
        }
        linhaArquivo.append("756");
        linhaArquivo.append("0001");
        linhaArquivo.append("5");
        linhaArquivo.append(StringUtils.repeat(" ", 9));
        linhaArquivo.append(StringUtils.leftPad(contadorLinhas.toString(), 6, "0"));
        linhaArquivo.append(StringUtils.leftPad(String.valueOf(list.size()), 6, "0"));
        linhaArquivo.append(BoletoUtil.formatarValorSemPonto(valorTotalTitulos, 2, 17));
        linhaArquivo.append(StringUtils.repeat("0", 6));
        linhaArquivo.append(StringUtils.repeat("0", 17));
        linhaArquivo.append(StringUtils.repeat("0", 6));
        linhaArquivo.append(StringUtils.repeat("0", 17));
        linhaArquivo.append(StringUtils.repeat("0", 6));
        linhaArquivo.append(StringUtils.repeat("0", 17));
        linhaArquivo.append(StringUtils.repeat(" ", 8));
        linhaArquivo.append(StringUtils.repeat(" ", 117));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        object = contadorLinhas;
        Integer n7 = contadorLinhas = Integer.valueOf(contadorLinhas + 1);
        linhaArquivo.append("756");
        linhaArquivo.append("9999");
        linhaArquivo.append("9");
        linhaArquivo.append(StringUtils.repeat(" ", 9));
        linhaArquivo.append("000001");
        linhaArquivo.append(StringUtils.leftPad(contadorLinhas.toString(), 6, "0"));
        linhaArquivo.append("000000");
        linhaArquivo.append(StringUtils.repeat(" ", 205));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        String arquivoRemessa = linhaArquivo.toString();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arquivoRemessa.length(); ++i) {
            char ch = arquivoRemessa.charAt(i);
            if (SicoobUtil.isASCIISicoob(ch)) {
                stringBuilder.append(ch);
                continue;
            }
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private List<RemessaRetornoModel> importarArquivo(String arquivo) {
        ArrayList<RemessaRetornoModel> list = new ArrayList<RemessaRetornoModel>();
        try (Scanner scanner = new Scanner(arquivo);){
            String numeroRetorno = null;
            String beneficiarioDocumento = null;
            while (scanner.hasNextLine()) {
                String linha = scanner.nextLine();
                if (linha.length() <= 1) continue;
                if (linha.charAt(7) == '0') {
                    if (linha.charAt(142) != '2') {
                        throw new BoletoException("Formato do aquivo inv\u00e1lido.");
                    }
                    if (!linha.substring(0, 3).equals("756")) {
                        throw new BoletoException("N\u00famero do Banco inv\u00e1lido.");
                    }
                    numeroRetorno = linha.substring(157, 163);
                    beneficiarioDocumento = linha.substring(18, 32);
                }
                if (linha.charAt(7) != '3') continue;
                String tipoRegistro = linha.substring(13, 14);
                if (tipoRegistro.equals("T")) {
                    RemessaRetornoModel remessaRetornoModel = new RemessaRetornoModel();
                    remessaRetornoModel.setBoleto(new BoletoModel());
                    remessaRetornoModel.getBoleto().setPagador(new Pagador());
                    Beneficiario beneficiario = new Beneficiario();
                    beneficiario.setDocumento(beneficiarioDocumento);
                    remessaRetornoModel.getBoleto().setBeneficiario(beneficiario);
                    remessaRetornoModel.getBoleto().setCodRetorno(numeroRetorno);
                    remessaRetornoModel.getBoleto().getPagador().setDocumento(linha.substring(133, 148));
                    remessaRetornoModel.getBoleto().getPagador().setNome(linha.substring(148, 188));
                    remessaRetornoModel.getBoleto().setNossoNumero(linha.substring(37, 46));
                    remessaRetornoModel.getBoleto().setDigitoNossoNumero(linha.substring(46, 47));
                    remessaRetornoModel.getBoleto().setParcela(Integer.parseInt(linha.substring(47, 49)));
                    remessaRetornoModel.setOcorrencia(linha.substring(15, 17));
                    remessaRetornoModel.getBoleto().setNumeroDocumento(linha.substring(58, 73));
                    remessaRetornoModel.getBoleto().setDataVencimento(BoletoUtil.formataStringPadraoDDMMYYYYParaLocalDate(linha.substring(73, 81)));
                    remessaRetornoModel.getBoleto().setValorBoleto(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(81, 96)));
                    remessaRetornoModel.setDespesaCobranca(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(198, 213)));
                    remessaRetornoModel.setMotivoOcorrencia(linha.substring(213, 223));
                    list.add(remessaRetornoModel);
                    continue;
                }
                if (!tipoRegistro.equals("U")) continue;
                ((RemessaRetornoModel)list.get(list.size() - 1)).setAbatimentoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(47, 62)));
                String previsaoConta = linha.substring(145, 153);
                if (!previsaoConta.replaceAll("\\D", "").equals("00000000")) {
                    ((RemessaRetornoModel)list.get(list.size() - 1)).setDataPrevisaoLancamento(BoletoUtil.formataStringPadraoDDMMYYYYParaLocalDate(previsaoConta));
                }
                ((RemessaRetornoModel)list.get(list.size() - 1)).setDataOcorrencia(BoletoUtil.formataStringPadraoDDMMYYYYParaLocalDate(linha.substring(137, 145)));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setDescontoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(32, 47)));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setDespesaCobranca(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(107, 122)));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setJuroDeMora(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(17, 32)));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setOcorrencia(linha.substring(15, 17));
                ((RemessaRetornoModel)list.get(list.size() - 1)).setValorEfetivamentePago(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(92, 107)));
            }
        }
        return list;
    }

    public void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        StringBuilder codigoBarras = new StringBuilder();
        codigoBarras.append("7569");
        codigoBarras.append("X");
        codigoBarras.append(SicoobUtil.fatorData(boletoModel.getDataVencimento()));
        codigoBarras.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        StringBuilder campoLivre = new StringBuilder();
        campoLivre.append("1");
        campoLivre.append(StringUtils.leftPad(boletoModel.getBeneficiario().getAgencia(), 4, "0"));
        campoLivre.append("01");
        campoLivre.append(boletoModel.getBeneficiario().getNumeroConvenio());
        campoLivre.append(StringUtils.leftPad(boletoModel.getNossoNumero(), 9, "0").substring(2));
        campoLivre.append(boletoModel.getDigitoNossoNumero());
        campoLivre.append(String.format("%03d", boletoModel.getParcela()));
        codigoBarras.append((CharSequence)campoLivre);
        Integer digitoVerificadorGeral = SicoobUtil.modulo11(codigoBarras.toString().replace("X", ""));
        boletoModel.setCodigoBarras(codigoBarras.toString().replace("X", digitoVerificadorGeral.toString()));
        StringBuilder linhaParte1 = new StringBuilder();
        linhaParte1.append("75691");
        linhaParte1.append(boletoModel.getBeneficiario().getAgencia());
        linhaParte1.append(SicoobUtil.modulo10(linhaParte1.toString()));
        StringBuilder linhaParte2 = new StringBuilder();
        linhaParte2.append("01");
        linhaParte2.append(StringUtils.leftPad(boletoModel.getBeneficiario().getNumeroConvenio(), 7, "0"));
        linhaParte2.append(StringUtils.leftPad(boletoModel.getNossoNumero(), 9, "0").substring(2, 3));
        linhaParte2.append(SicoobUtil.modulo10(linhaParte2.toString()));
        StringBuilder linhaParte3 = new StringBuilder();
        linhaParte3.append(StringUtils.leftPad(boletoModel.getNossoNumero(), 9, "0").substring(3));
        linhaParte3.append(boletoModel.getDigitoNossoNumero());
        linhaParte3.append(String.format("%03d", boletoModel.getParcela()));
        linhaParte3.append(SicoobUtil.modulo10(linhaParte3.toString()));
        StringBuilder linhaParte4 = new StringBuilder();
        linhaParte4.append(digitoVerificadorGeral);
        StringBuilder linhaParte5 = new StringBuilder();
        linhaParte5.append(SicoobUtil.fatorData(boletoModel.getDataVencimento()));
        linhaParte5.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        StringBuilder linhaDigitavel = new StringBuilder();
        linhaDigitavel.append(linhaParte1.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte1.toString(), 5, 10);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte2.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte2.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte3.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte3.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte4);
        linhaDigitavel.append("  ");
        linhaDigitavel.append((CharSequence)linhaParte5);
        boletoModel.setLinhaDigitavel(linhaDigitavel.toString());
        this.validaDadosImpressao(boletoModel);
    }

    private void validaDadosImpressao(BoletoModel boleto) {
        ValidaUtils.validaBoletoModel(boleto, Arrays.asList("locaisDePagamento", "dataVencimento", "beneficiario.nomeBeneficiario", "beneficiario.documento", "beneficiario.agencia", "beneficiario.numeroConvenio,max:7", "beneficiario.conta", "dataEmissao", "numeroDocumento", "especieDocumento", "aceite", "nossoNumero,max:9", "digitoNossoNumero", "especieMoeda", "valorBoleto", "pagador.nome", "pagador.documento", "pagador.endereco.logradouro", "pagador.endereco.cep", "linhaDigitavel", "codigoBarras", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf"));
    }
}

