/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicredi_cnab400;

import br.com.java_brasil.boleto.util.BoletoUtil;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SicrediUtil {
    public static String gerarNossoNumero(String serie, String nossoNumero, LocalDate dataBoleto) {
        StringBuilder sb = new StringBuilder();
        sb.append(BoletoUtil.getDataFormato(dataBoleto, "yy"));
        sb.append(StringUtils.leftPad(serie, 1, "0"));
        sb.append(StringUtils.leftPad(nossoNumero, 5, "0"));
        return sb.toString();
    }

    public static int gerarDigitoNossoNumero(String serie, String nossoNumero, LocalDate dataBoleto, String codigoAgencia, String codigoConta, String postoDaAgencia) {
        StringBuilder digitoVerificador = new StringBuilder();
        digitoVerificador.append(StringUtils.leftPad(codigoAgencia, 4, "0"));
        digitoVerificador.append(StringUtils.leftPad(postoDaAgencia, 2, "0"));
        digitoVerificador.append(StringUtils.leftPad(codigoConta, 5, "0"));
        digitoVerificador.append(BoletoUtil.getDataFormato(dataBoleto, "yy"));
        digitoVerificador.append(StringUtils.leftPad(serie, 1, "0"));
        digitoVerificador.append(StringUtils.leftPad(nossoNumero, 5, "0"));
        return SicrediUtil.modulo11Sicredi(digitoVerificador.toString());
    }

    public static String retornaNomeArquivoRemessa(String codigoConta, LocalDate dataRemessa, Integer numeroRemessaNoDia) {
        String mesGeracaoArquivo = SicrediUtil.retornaMes(dataRemessa.getMonth());
        String extensao = numeroRemessaNoDia.compareTo(0) == 0 ? ".CRM" : ".RM" + (numeroRemessaNoDia + 1);
        return StringUtils.leftPad(codigoConta, 5, '0') + mesGeracaoArquivo + StringUtils.leftPad(String.valueOf(dataRemessa.getDayOfMonth()), 2, "0") + extensao;
    }

    private static String retornaMes(Month month) {
        switch (month) {
            case OCTOBER: {
                return "O";
            }
            case NOVEMBER: {
                return "N";
            }
            case DECEMBER: {
                return "D";
            }
        }
        return String.valueOf(month.getValue());
    }

    public static String fatorData(LocalDate dataVencimento) {
        LocalDate dataBase = LocalDate.of(1997, 10, 7);
        if (dataVencimento.isAfter(LocalDate.of(2025, 2, 21))) {
            dataBase = dataBase.plusDays(9000L);
        }
        long difDia = ChronoUnit.DAYS.between(dataBase, dataVencimento);
        return StringUtils.leftPad("" + difDia, 4, '0');
    }

    public static Integer modulo11DvCampoLivre(String codigo) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < codigo.length(); ++i) {
            total += (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
            if (++peso != 10) continue;
            peso = 2;
        }
        int parteInteira = total / 11;
        int multiplicacao = parteInteira * 11;
        int resultado = total - multiplicacao;
        if (resultado < 2) {
            return 0;
        }
        return 11 - resultado;
    }

    public static Integer modulo11DvGeralSicredi(String codigo) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < codigo.length(); ++i) {
            total += (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
            if (++peso != 10) continue;
            peso = 2;
        }
        int resto = total % 11;
        int digito = 11 - resto;
        return digito == 0 || digito == 1 || digito > 9 ? 1 : digito;
    }

    public static Integer modulo10Sicredi(String codigo) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < codigo.length(); ++i) {
            int valor = (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
            if (valor > 9) {
                valor -= 9;
            }
            total += valor;
            if (peso == 2) {
                --peso;
                continue;
            }
            ++peso;
        }
        int resto = total < 10 ? total : total % 10;
        int digito = resto == 0 ? 0 : 10 - resto;
        return digito;
    }

    public static Integer modulo11Sicredi(String codigo) {
        try {
            int total = 0;
            int peso = 2;
            for (int i = 0; i < codigo.length(); ++i) {
                total += (codigo.charAt(codigo.length() - 1 - i) - 48) * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            int resto = total % 11;
            int digito = 11 - resto;
            return digito == 10 || digito == 11 ? 0 : digito;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Map<String, String> getMapOcorrencia() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("02", "Entrada confirmada");
            map.put("03", "Entrada rejeitada");
            map.put("06", "Liquida\u00e7\u00e3o normal");
            map.put("09", "Baixado automaticamente via arquivo");
            map.put("10", "Baixado conforme instru\u00e7\u00f5es da cooperativa de cr\u00e9dito");
            map.put("12", "Abatimento concedido");
            map.put("13", "Abatimento cancelado");
            map.put("14", "Vencimento alterado");
            map.put("15", "Liquida\u00e7\u00e3o em cart\u00f3rio");
            map.put("17", "Liquida\u00e7\u00e3o ap\u00f3s baixa");
            map.put("19", "Confirma\u00e7\u00e3o de recebimento de instru\u00e7\u00e3o de protesto");
            map.put("20", "Confirma\u00e7\u00e3o de recebimento de instru\u00e7\u00e3o de susta\u00e7\u00e3o de protesto");
            map.put("23", "Entrada de t\u00edtulo em cart\u00f3rio");
            map.put("24", "Entrada rejeitada por CEP irregular");
            map.put("27", "Baixa rejeitada");
            map.put("28", "Tarifa");
            map.put("29", "Rejei\u00e7\u00e3o do pagador");
            map.put("30", "Altera\u00e7\u00e3o rejeitada");
            map.put("32", "Instru\u00e7\u00e3o rejeitada");
            map.put("33", "Confirma\u00e7\u00e3o de pedido de altera\u00e7\u00e3o de outros dados");
            map.put("34", "Retirado de cart\u00f3rio e manuten\u00e7\u00e3o em carteira");
            map.put("35", "Aceite do pagador");
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static String getOcorrencia(String ocorrencia) {
        try {
            Map<String, String> map = SicrediUtil.getMapOcorrencia();
            return map.get(ocorrencia) == null ? "Ocorr\u00eancia n\u00e3o catalogada" : map.get(ocorrencia);
        }
        catch (Exception e) {
            return "Error - Ocorr\u00eancia n\u00e3o catalogada";
        }
    }

    public static Map<String, String> getMapMotivoOcorrencia(String ocorrencia) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (ocorrencia.equals("28")) {
                map.put("03", "Tarifa de susta\u00e7\u00e3o");
                map.put("04", "Tarifa de protesto");
                map.put("08", "Tarifa de custas de protesto");
                map.put("A9", "Tarifa de manuten\u00e7\u00e3o de t\u00edtulo vencido");
                map.put("B1", "Tarifa de baixa da carteira");
                map.put("B3", "Tarifa de registro de entrada do t\u00edtulo");
                map.put("F5", "Tarifa de entrada na rede Sicredi");
            } else {
                map.put("00", "Ocorr\u00eancia confirmada(OK)");
                map.put("01", "C\u00f3digo do banco inv\u00e1lido");
                map.put("02", "C\u00f3digo do registro detalhe inv\u00e1lido");
                map.put("03", "C\u00f3digo da ocorr\u00eancia inv\u00e1lido");
                map.put("04", "C\u00f3digo de ocorr\u00eancia n\u00e3o permitida para a carteira");
                map.put("05", "C\u00f3digo de ocorr\u00eancia n\u00e3o num\u00e9rico");
                map.put("07", "Cooperativa/ag\u00eancia/conta/d\u00edgito inv\u00e1lidos");
                map.put("08", "Nosso n\u00famero inv\u00e1lido");
                map.put("09", "Nosso n\u00famero duplicado");
                map.put("10", "Carteira inv\u00e1lida");
                map.put("14", "T\u00edtulo protestado");
                map.put("15", "Cooperativa/carteira/ag\u00eancia/conta/nosso n\u00famero inv\u00e1lidos");
                map.put("16", "Data de vencimento inv\u00e1lida");
                map.put("17", "Data de vencimento anterior \u00e0 data de emiss\u00e3o");
                map.put("18", "Vencimento fora do prazo de opera\u00e7\u00e3o");
                map.put("20", "Valor do t\u00edtulo inv\u00e1lido");
                map.put("21", "Esp\u00e9cie do t\u00edtulo inv\u00e1lida");
                map.put("22", "Esp\u00e9cie n\u00e3o permitida para a carteira");
                map.put("24", "Data de emiss\u00e3o inv\u00e1lida");
                map.put("29", "Valor do desconto maior/igual ao valor do t\u00edtulo");
                map.put("31", "Concess\u00e3o de desconto - existe desconto anterior");
                map.put("33", "Valor do abatimento inv\u00e1lido");
                map.put("34", "Valor do abatimento maior/igual ao valor do t\u00edtulo");
                map.put("36", "Concess\u00e3o de abatimento - existe abatimento anterior");
                map.put("38", "Prazo para protesto inv\u00e1lido");
                map.put("39", "Pedido para protesto n\u00e3o permitido para o t\u00edtulo");
                map.put("40", "T\u00edtulo com ordem de protesto emitida");
                map.put("41", "Pedido cancelamento/susta\u00e7\u00e3o sem instru\u00e7\u00e3o de protesto");
                map.put("44", "Cooperativa de cr\u00e9dito/ag\u00eancia benefici\u00e1ria n\u00e3o prevista");
                map.put("45", "Nome do pagador inv\u00e1lido");
                map.put("46", "Tipo/n\u00famero de inscri\u00e7\u00e3o do pagador inv\u00e1lidos");
                map.put("47", "Endere\u00e7o do pagador n\u00e3o informado");
                map.put("48", "CEP irregular");
                map.put("49", "N\u00famero de Inscri\u00e7\u00e3o do pagador/avalista inv\u00e1lido");
                map.put("50", "Pagador/avalista n\u00e3o informado");
                map.put("60", "Movimento para t\u00edtulo n\u00e3o cadastrado");
                map.put("63", "Entrada para t\u00edtulo j\u00e1 cadastrado");
                map.put("A", "Aceito");
                map.put("D", "Desprezado");
                map.put("A1", "Pra\u00e7a do pagador n\u00e3o cadastrada.");
                map.put("A2", "Tipo de cobran\u00e7a do t\u00edtulo divergente com a pra\u00e7a do pagador.");
                map.put("A3", "Cooperativa/ag\u00eancia deposit\u00e1ria divergente: atualiza o cadastro de pra\u00e7as da Coop./ag\u00eancia benefici\u00e1ria");
                map.put("A4", "Benefici\u00e1rio n\u00e3o cadastrado ou possui CGC/CIC inv\u00e1lido");
                map.put("A5", "Pagador n\u00e3o cadastrado");
                map.put("A6", "Data da instru\u00e7\u00e3o/ocorr\u00eancia inv\u00e1lida");
                map.put("A7", "Ocorr\u00eancia n\u00e3o pode ser comandada");
                map.put("A8", "Recebimento da liquida\u00e7\u00e3o fora da rede Sicredi - via compensa\u00e7\u00e3o eletr\u00f4nica");
                map.put("B4", "Tipo de moeda inv\u00e1lido");
                map.put("B5", "Tipo de desconto/juros inv\u00e1lido");
                map.put("B6", "Mensagem padr\u00e3o n\u00e3o cadastrada");
                map.put("B7", "Seu n\u00famero inv\u00e1lido");
                map.put("B8", "Percentual de multa inv\u00e1lido");
                map.put("B9", "Valor ou percentual de juros inv\u00e1lido");
                map.put("C1", "Data limite para concess\u00e3o de desconto inv\u00e1lida");
                map.put("C2", "Aceite do t\u00edtulo inv\u00e1lido");
                map.put("C3", "Campo alterado na instru\u00e7\u00e3o \u201c31 \u2013 altera\u00e7\u00e3o de outros dados\u201d inv\u00e1lido");
                map.put("C4", "T\u00edtulo ainda n\u00e3o foi confirmado pela centralizadora");
                map.put("C5", "T\u00edtulo rejeitado pela centralizadora");
                map.put("C6", "T\u00edtulo j\u00e1 liquidado");
                map.put("C7", "T\u00edtulo j\u00e1 baixado");
                map.put("C8", "Existe mesma instru\u00e7\u00e3o pendente de confirma\u00e7\u00e3o para este t\u00edtulo");
                map.put("C9", "Instru\u00e7\u00e3o pr\u00e9via de concess\u00e3o de abatimento n\u00e3o existe ou n\u00e3o confirmada");
                map.put("D1", "T\u00edtulo dentro do prazo de vencimento (em dia)");
                map.put("D2", "Esp\u00e9cie de documento n\u00e3o permite protesto de t\u00edtulo");
                map.put("D3", "T\u00edtulo possui instru\u00e7\u00e3o de baixa pendente de confirma\u00e7\u00e3o");
                map.put("D4", "Quantidade de mensagens padr\u00e3o excede o limite permitido");
                map.put("D5", "Quantidade inv\u00e1lida no pedido de bloquetos pr\u00e9-impressos da cobran\u00e7a sem registro");
                map.put("D6", "Tipo de impress\u00e3o inv\u00e1lida para cobran\u00e7a sem registro");
                map.put("D7", "Cidade ou Estado do pagador n\u00e3o informado");
                map.put("D8", "Seq\u00fc\u00eancia para composi\u00e7\u00e3o do nosso n\u00famero do ano atual esgotada");
                map.put("D9", "Registro mensagem para t\u00edtulo n\u00e3o cadastrado");
                map.put("E2", "Registro complementar ao cadastro do t\u00edtulo da cobran\u00e7a com e sem registro n\u00e3o cadastrado");
                map.put("E3", "Tipo de postagem inv\u00e1lido, diferente de S, N e branco");
                map.put("E4", "Pedido de bloquetos pr\u00e9-impressos");
                map.put("E5", "Confirma\u00e7\u00e3o/rejei\u00e7\u00e3o para pedidos de bloquetos n\u00e3o cadastrado");
                map.put("E6", "Pagador/avalista n\u00e3o cadastrado");
                map.put("E7", "Informa\u00e7\u00e3o para atualiza\u00e7\u00e3o do valor do t\u00edtulo para protesto inv\u00e1lido");
                map.put("E8", "Tipo de impress\u00e3o inv\u00e1lido, diferente de A, B e branco");
                map.put("E9", "C\u00f3digo do pagador do t\u00edtulo divergente com o c\u00f3digo da cooperativa de cr\u00e9dito");
                map.put("F1", "Liquidado no sistema do cliente");
                map.put("F2", "Baixado no sistema do cliente");
                map.put("F3", "Instru\u00e7\u00e3o inv\u00e1lida, este t\u00edtulo est\u00e1 caucionado/descontado");
                map.put("F4", "Instru\u00e7\u00e3o fixa com caracteres inv\u00e1lidos");
                map.put("F6", "Nosso n\u00famero / n\u00famero da parcela fora de seq\u00fc\u00eancia \u2013 total de parcelas inv\u00e1lido");
                map.put("F7", "Falta de comprovante de presta\u00e7\u00e3o de servi\u00e7o");
                map.put("F8", "Nome do benefici\u00e1rio incompleto / incorreto.");
                map.put("F9", "CNPJ / CPF incompat\u00edvel com o nome do pagador / Sacador Avalista");
                map.put("G1", "CNPJ / CPF do pagador Incompat\u00edvel com a esp\u00e9cie");
                map.put("G2", "T\u00edtulo aceito: sem a assinatura do pagador");
                map.put("G3", "T\u00edtulo aceito: rasurado ou rasgado");
                map.put("G4", "T\u00edtulo aceito: falta t\u00edtulo (cooperativa/ag. benefici\u00e1ria dever\u00e1 envi\u00e1-lo)");
                map.put("G5", "Pra\u00e7a de pagamento incompat\u00edvel com o endere\u00e7o");
                map.put("G6", "T\u00edtulo aceito: sem endosso ou benefici\u00e1rio irregular");
                map.put("G7", "T\u00edtulo aceito: valor por extenso diferente do valor num\u00e9rico");
                map.put("G8", "Saldo maior que o valor do t\u00edtulo");
                map.put("G9", "Tipo de endosso inv\u00e1lido");
                map.put("H1", "Nome do pagador incompleto / Incorreto");
                map.put("H2", "Susta\u00e7\u00e3o judicial");
                map.put("H3", "Pagador n\u00e3o encontrado");
                map.put("H4", "Altera\u00e7\u00e3o de carteira");
                map.put("H5", "Recebimento de liquida\u00e7\u00e3o fora da rede Sicredi \u2013 VLB Inferior \u2013 Via Compensa\u00e7\u00e3o");
                map.put("H6", "Recebimento de liquida\u00e7\u00e3o fora da rede Sicredi \u2013 VLB Superior \u2013 Via Compensa\u00e7\u00e3o");
                map.put("H7", "Esp\u00e9cie de documento necessita benefici\u00e1rio ou avalista PJ");
                map.put("H8", "Recebimento de liquida\u00e7\u00e3o fora da rede Sicredi \u2013 Conting\u00eancia Via Compe");
                map.put("H9", "Dados do t\u00edtulo n\u00e3o conferem com disquete");
                map.put("I1", "Pagador e Sacador Avalista s\u00e3o a mesma pessoa");
                map.put("I2", "Aguardar um dia \u00fatil ap\u00f3s o vencimento para protestar");
                map.put("I3", "Data do vencimento rasurada");
                map.put("I4", "Vencimento \u2013 extenso n\u00e3o confere com n\u00famero");
                map.put("I5", "Falta data de vencimento no t\u00edtulo");
                map.put("I6", "DM/DMI sem comprovante autenticado ou declara\u00e7\u00e3o");
                map.put("I7", "Comprovante ileg\u00edvel para confer\u00eancia e microfilmagem");
                map.put("I8", "Nome solicitado n\u00e3o confere com emitente ou pagador");
                map.put("I9", "Confirmar se s\u00e3o 2 emitentes. Se sim, indicar os dados dos 2");
                map.put("J1", "Endere\u00e7o do pagador igual ao do pagador ou do portador");
                map.put("J2", "Endere\u00e7o do apresentante incompleto ou n\u00e3o informado");
                map.put("J3", "Rua/n\u00famero inexistente no endere\u00e7o");
                map.put("J4", "Falta endosso do favorecido para o apresentante");
                map.put("J5", "Data da emiss\u00e3o rasurada");
                map.put("J6", "Falta assinatura do pagador no t\u00edtulo");
                map.put("J7", "Nome do apresentante n\u00e3o informado/incompleto/incorreto");
                map.put("J8", "Erro de preenchimento do titulo");
                map.put("J9", "Titulo com direito de regresso vencido");
                map.put("K1", "Titulo apresentado em duplicidade");
                map.put("K2", "Titulo j\u00e1 protestado");
                map.put("K3", "Letra de cambio vencida \u2013 falta aceite do pagador");
                map.put("K4", "Falta declara\u00e7\u00e3o de saldo assinada no t\u00edtulo");
                map.put("K5", "Contrato de cambio \u2013 Falta conta gr\u00e1fica");
                map.put("K6", "Aus\u00eancia do documento f\u00edsico");
                map.put("K7", "Pagador falecido");
                map.put("K8", "Pagador apresentou quita\u00e7\u00e3o do t\u00edtulo");
                map.put("K9", "T\u00edtulo de outra jurisdi\u00e7\u00e3o territorial");
                map.put("L1", "T\u00edtulo com emiss\u00e3o anterior a concordata do pagador");
                map.put("L2", "Pagador consta na lista de fal\u00eancia");
                map.put("L3", "Apresentante n\u00e3o aceita publica\u00e7\u00e3o de edital");
                map.put("L4", "Dados do Pagador em Branco ou inv\u00e1lido");
                map.put("L5", "C\u00f3digo do Pagador na ag\u00eancia benefici\u00e1ria est\u00e1 duplicado");
                map.put("M1", "Reconhecimento da d\u00edvida pelo pagador");
                map.put("M2", "N\u00e3o reconhecimento da d\u00edvida pelo pagador");
                map.put("X1", "Regulariza\u00e7\u00e3o centralizadora \u2013 Rede Sicredi");
                map.put("X2", "Regulariza\u00e7\u00e3o centralizadora \u2013 Compensa\u00e7\u00e3o");
                map.put("X3", "Regulariza\u00e7\u00e3o centralizadora \u2013 Banco correspondente");
                map.put("X4", "Regulariza\u00e7\u00e3o centralizadora - VLB Inferior - via compensa\u00e7\u00e3o");
                map.put("X5", "Regulariza\u00e7\u00e3o centralizadora - VLB Superior - via compensa\u00e7\u00e3o");
                map.put("X0", "Pago com cheque");
                map.put("X6", "Pago com cheque \u2013 bloqueado 24 horas");
                map.put("X7", "Pago com cheque \u2013 bloqueado 48 horas");
                map.put("X8", "Pago com cheque \u2013 bloqueado 72 horas");
                map.put("X9", "Pago com cheque \u2013 bloqueado 96 horas");
                map.put("XA", "Pago com cheque \u2013 bloqueado 120 horas");
                map.put("XB", "Pago com cheque \u2013 bloqueado 144 horas");
            }
            return map;
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
    }

    public static String getMotivoOcorrenciaSicredi(String ocorrencia, String motivoOcorrencia) {
        try {
            Map<String, String> map = SicrediUtil.getMapMotivoOcorrencia(ocorrencia);
            return map.get(motivoOcorrencia) == null ? "Motivo Ocorr\u00eancia n\u00e3o catalogada" : map.get(motivoOcorrencia);
        }
        catch (Exception e) {
            return "Error - Motivo Ocorr\u00eancia n\u00e3o catalogada";
        }
    }

    public static boolean isASCIISicredi(char ch) {
        if (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9') {
            return true;
        }
        if (ch == ' ' || ch == '!' || ch == '#' || ch == '$' || ch == '%' || ch == '&' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == '-' || ch == '.' || ch == '/' || ch == ':' || ch == ';' || ch == '@' || ch == '[' || ch == '\\' || ch == ']' || ch == '{' || ch == '}') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        return ch == '\n' || ch == '\r';
    }
}

