/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.ui.components;

import br.com.java_brasil.boleto.ui.components.ColorUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class Button
extends JButton {
    private boolean borderLineShow;
    private Color borderLineColor;
    private boolean backgroundHover;

    public boolean isBorderLineShow() {
        return this.borderLineShow;
    }

    public void setBorderLineShow(boolean borderLineShow) {
        this.borderLineShow = borderLineShow;
    }

    public Color getBorderLineColor() {
        return this.borderLineColor;
    }

    public void setBorderLineColor(Color borderLineColor) {
        this.borderLineColor = borderLineColor;
    }

    public boolean isBackgroundHover() {
        return this.backgroundHover;
    }

    public void setBackgroundHover(boolean backgroundHover) {
        this.backgroundHover = backgroundHover;
    }

    public Button() {
        super.setOpaque(false);
        super.setContentAreaFilled(false);
        super.setFocusPainted(false);
        super.setFocusable(false);
        super.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        super.setFont(new Font("Segoe UI Semibold", 0, 12));
        super.setForeground(new Color(13, 134, 202));
        super.setCursor(new Cursor(12));
    }

    @Override
    protected void paintBorder(Graphics grphcs) {
        if (this.borderLineShow && this.getModel().isEnabled()) {
            Color line = this.borderLineColor == null ? this.getForeground() : this.borderLineColor;
            grphcs.setColor(line);
            int height = this.getHeight();
            grphcs.drawRoundRect(0, 0, this.getWidth() - 1, height - 1, height - 3, height - 3);
        }
        super.paintBorder(grphcs);
    }

    @Override
    protected void paintComponent(Graphics grphcs) {
        Graphics2D g2 = (Graphics2D)grphcs;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.backgroundHover) {
            Color foreground = this.getForeground();
            if (this.getModel().isPressed()) {
                Color color = ColorUtil.brighter(foreground, 40);
                g2.setColor(color);
            } else if (this.getModel().isRollover()) {
                Color color = ColorUtil.brighter(foreground, 25);
                g2.setColor(color);
            } else {
                g2.setColor(new Color(0, 0, 0, 0));
            }
        } else {
            Color background = this.getBackground();
            if (this.getModel().isPressed()) {
                Color color = ColorUtil.isDark(background) ? ColorUtil.brighter(background) : ColorUtil.darker(background);
                g2.setColor(color);
            } else if (this.getModel().isRollover()) {
                Color color = ColorUtil.isDark(background) ? ColorUtil.brighter(background, 0.85) : ColorUtil.darker(background, 0.85);
                g2.setColor(color);
            } else {
                g2.setColor(background);
            }
        }
        int height = this.getHeight();
        g2.fillRoundRect(0, 0, this.getWidth(), height, height - 3, height - 3);
        super.paintComponent(grphcs);
    }
}

