/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.util;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ValidaUtils {
    public static <T> void validaConfiguracao(T configuracao) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        StringBuilder erros = new StringBuilder();
        for (ConstraintViolation<T> violation : validator.validate(configuracao, new Class[0])) {
            erros.append("Campo ").append(violation.getPropertyPath()).append(" ").append(violation.getMessage()).append(".");
        }
        if (StringUtils.isNotBlank(erros.toString())) {
            throw new BoletoException(erros.toString());
        }
    }

    public static void validaBoletoModel(@NonNull BoletoModel boleto, List<String> camposObrigatorios) {
        if (boleto == null) {
            throw new NullPointerException("boleto is marked non-null but is null");
        }
        StringBuilder erros = new StringBuilder();
        Object objectMapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
        Map props = ((ObjectMapper)objectMapper).convertValue((Object)boleto, Map.class);
        props.forEach((key, value) -> {
            if (value instanceof Map) {
                ((Map)value).forEach((k, v) -> ValidaUtils.validaCampos(camposObrigatorios, key + "." + k, v, erros));
            } else {
                ValidaUtils.validaCampos(camposObrigatorios, key.toString(), value, erros);
            }
        });
        if (StringUtils.isNotBlank(erros.toString())) {
            throw new BoletoException(erros.toString());
        }
    }

    private static <T> void validaCampos(List<String> camposObrigatorios, String key, T value, StringBuilder erros) {
        if (camposObrigatorios.contains(key) && !ValidaUtils.verifica(value).isPresent()) {
            erros.append("Campo ").append(key).append(" n\u00e3o pode estar vazio.\n");
        }
        if (value instanceof String) {
            Optional<String> optCampoMin;
            Optional<String> optCampoMax = camposObrigatorios.stream().filter(campoObrigatorio -> campoObrigatorio.contains(key)).filter(campoObrigatorio -> campoObrigatorio.contains("max:")).findFirst();
            if (optCampoMax.isPresent() && ValidaUtils.verifica(value).isPresent()) {
                String inicioMax;
                String campo = optCampoMax.get();
                int indiceFinal = (inicioMax = campo.substring(campo.indexOf("max:") + 4)).contains(",") ? inicioMax.indexOf(",") : inicioMax.length();
                String tamanho = inicioMax.substring(0, indiceFinal);
                if (StringUtils.isBlank(StringUtils.trimToEmpty(tamanho))) {
                    throw new BoletoException("Valida\u00e7\u00e3o 'max:' sem tamanho informado!");
                }
                String valorDoCampo = (String)value;
                if (valorDoCampo.length() > Integer.parseInt(tamanho)) {
                    erros.append("Campo ").append(key).append(" com tamanho maior que ").append(tamanho).append(" caracteres.\n");
                }
            }
            if ((optCampoMin = camposObrigatorios.stream().filter(campoObrigatorio -> campoObrigatorio.contains(key)).filter(campoObrigatorio -> campoObrigatorio.contains("min:")).findFirst()).isPresent() && ValidaUtils.verifica(value).isPresent()) {
                String inicioMin;
                String campo = optCampoMin.get();
                int indiceFinal = (inicioMin = campo.substring(campo.indexOf("min:") + 4)).contains(",") ? inicioMin.indexOf(",") : inicioMin.length();
                String tamanho = inicioMin.substring(0, indiceFinal);
                if (StringUtils.isBlank(StringUtils.trimToEmpty(tamanho))) {
                    throw new BoletoException("Valida\u00e7\u00e3o 'min:' sem tamanho informado!");
                }
                String valorDoCampo = (String)value;
                if (valorDoCampo.length() < Integer.parseInt(tamanho)) {
                    erros.append("Campo ").append(key).append(" com tamanho menor que ").append(tamanho).append(" caracteres.\n");
                }
            }
        }
    }

    public static <T> Optional<T> verifica(T obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() == 0 ? Optional.empty() : Optional.of(obj);
        }
        String s = String.valueOf(obj).trim();
        return s.length() == 0 || s.equalsIgnoreCase("null") ? Optional.empty() : Optional.of(obj);
    }
}

