/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.util.XYZElement;
import org.jfree.data.xy.AbstractXYZDataset;

public class DefaultXYZDataset
extends AbstractXYZDataset {
    private static final long serialVersionUID = 10200L;
    List<XYZElement> dataset = new ArrayList<XYZElement>();

    public void addValue(Comparable<?> series, Number xValue, Number yValue, Number zValue) {
        boolean found = false;
        for (XYZElement element : this.dataset) {
            if (!element.getSeries().equals(series)) continue;
            element.addElement(xValue, yValue, zValue);
            found = true;
        }
        if (!found) {
            XYZElement element = new XYZElement();
            element.setSeries(series);
            element.addElement(xValue, yValue, zValue);
            this.dataset.add(element);
        }
    }

    @Override
    public int getSeriesCount() {
        int retVal = 0;
        if (this.dataset != null) {
            retVal = this.dataset.size();
        }
        return retVal;
    }

    @Override
    public Number getZ(int series, int index) {
        Number retVal = null;
        if (this.dataset != null && series < this.getSeriesCount()) {
            XYZElement element = this.dataset.get(series);
            retVal = element.getZElement(index);
        }
        return retVal;
    }

    @Override
    public int getItemCount(int series) {
        int retVal = 0;
        if (this.dataset != null && series < this.getSeriesCount()) {
            XYZElement element = this.dataset.get(series);
            retVal = element.getCount();
        }
        return retVal;
    }

    @Override
    public Number getX(int series, int index) {
        Number retVal = null;
        if (this.dataset != null && series < this.getSeriesCount()) {
            XYZElement element = this.dataset.get(series);
            retVal = element.getXElement(index);
        }
        return retVal;
    }

    @Override
    public Number getY(int series, int index) {
        Number retVal = null;
        if (this.dataset != null && series < this.getSeriesCount()) {
            XYZElement element = this.dataset.get(series);
            retVal = element.getYElement(index);
        }
        return retVal;
    }

    @Override
    public Comparable<?> getSeriesKey(int index) {
        String retVal = null;
        if (this.dataset != null && index < this.getSeriesCount()) {
            XYZElement element = this.dataset.get(index);
            retVal = element.getSeries().toString();
        }
        return retVal;
    }
}

