/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.ExpressionReturnValue;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.analytics.dataset.DataAxis;
import net.sf.jasperreports.engine.analytics.dataset.DataAxisLevel;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucket;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucketProperty;
import net.sf.jasperreports.engine.analytics.dataset.DataMeasure;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisData;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisDataset;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.engine.part.PartComponentManager;
import net.sf.jasperreports.engine.part.PartComponentsEnvironment;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRExpressionCollector {
    private static final Log log = LogFactory.getLog(JRExpressionCollector.class);
    public static final String EXCEPTION_MESSAGE_KEY_EXPRESSION_NOT_FOUND = "engine.expression.collector.expression.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_TWO_GENERATED_IDS = "engine.expression.collector.two.generated.ids";
    private final JasperReportsContext jasperReportsContext;
    private final JRReport report;
    private final JRExpressionCollector parent;
    private Map<JRExpression, Integer> expressionIds;
    private LinkedList<Object> contextStack;
    private Map<JRExpression, Object> expressionContextMap;
    private GeneratedIds generatedIds = new GeneratedIds();
    private Map<JRCrosstab, Integer> crosstabIds;
    private Map<String, JRExpressionCollector> datasetCollectors;
    private Map<JRCrosstab, JRExpressionCollector> crosstabCollectors;
    private final Set<JRStyle> collectedStyles;

    public static JRExpressionCollector collector(JasperReportsContext jasperReportsContext, JRReport report) {
        JRExpressionCollector collector = new JRExpressionCollector(jasperReportsContext, null, report);
        collector.collect();
        return collector;
    }

    public static List<JRExpression> collectExpressions(JasperReportsContext jasperReportsContext, JRReport report) {
        return JRExpressionCollector.collector(jasperReportsContext, report).getExpressions();
    }

    public static JRExpressionCollector collector(JasperReportsContext jasperReportsContext, JRReport report, JRCrosstab crosstab) {
        JRExpressionCollector collector = new JRExpressionCollector(jasperReportsContext, null, report);
        collector.collect(crosstab);
        return collector;
    }

    public static List<JRExpression> collectExpressions(JasperReportsContext jasperReportsContext, JRReport report, JRCrosstab crosstab) {
        return JRExpressionCollector.collector(jasperReportsContext, report, crosstab).getExpressions(crosstab);
    }

    protected JRExpressionCollector(JasperReportsContext jasperReportsContext, JRExpressionCollector parent, JRReport report) {
        this.jasperReportsContext = jasperReportsContext;
        this.parent = parent;
        this.report = report;
        if (parent == null) {
            this.expressionIds = new HashMap<JRExpression, Integer>();
            this.datasetCollectors = new HashMap<String, JRExpressionCollector>();
            this.crosstabCollectors = new HashMap<JRCrosstab, JRExpressionCollector>();
            this.contextStack = new LinkedList();
            this.expressionContextMap = new HashMap<JRExpression, Object>();
            this.crosstabIds = new HashMap<JRCrosstab, Integer>();
        } else {
            this.expressionIds = this.parent.expressionIds;
            this.contextStack = this.parent.contextStack;
            this.expressionContextMap = this.parent.expressionContextMap;
            this.crosstabIds = parent.crosstabIds;
        }
        this.collectedStyles = new HashSet<JRStyle>();
    }

    public void addExpression(JRExpression expression) {
        if (expression != null) {
            Integer id = this.getExpressionId(expression);
            if (id == null) {
                id = this.generatedIds.nextId();
                this.setGeneratedId(expression, id);
                this.generatedIds.put(id, expression);
                if (log.isTraceEnabled()) {
                    log.trace(this.hashCode() + " generated id " + id + " for expression " + expression.hashCode() + " " + expression.getText());
                }
            } else {
                if (log.isTraceEnabled()) {
                    log.trace(this.hashCode() + " found id " + id + " for expression " + expression.hashCode() + " " + expression.getText());
                }
                if (this.canUseId(expression, id)) {
                    this.generatedIds.put(id, expression);
                } else {
                    this.reassignId(expression, id);
                }
            }
            this.setExpressionContext(expression);
        }
    }

    private void setGeneratedId(JRExpression expression, Integer id) {
        Integer existingId = this.expressionIds.put(expression, id);
        if (existingId != null && !((Object)existingId).equals(id)) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TWO_GENERATED_IDS, expression.getText());
        }
    }

    private void updateGeneratedId(JRExpression expression, Integer currentId, Integer newId) {
        Integer existingId = this.expressionIds.put(expression, newId);
        if (existingId == null || !((Object)existingId).equals(currentId)) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TWO_GENERATED_IDS, expression.getText(), currentId);
        }
    }

    protected boolean canUseId(JRExpression expression, Integer id) {
        JRExpression existingExpression = this.generatedIds.get(id);
        return existingExpression == null || existingExpression.equals(expression);
    }

    protected void reassignId(JRExpression expression, Integer id) {
        List<JRExpressionCollector> collectors = this.collectorsForExpression(id, expression);
        Integer newId = this.generatedIds.nextId();
        while (!this.canUseId(collectors, expression, newId)) {
            newId = newId + 1;
        }
        if (log.isTraceEnabled()) {
            log.trace(this.hashCode() + " updated id to " + newId + " for expression " + expression.hashCode() + " " + expression.getText());
        }
        this.generatedIds.put(newId, expression);
        for (JRExpressionCollector collector : collectors) {
            collector.generatedIds.move(id, newId);
        }
        this.updateGeneratedId(expression, id, newId);
    }

    protected boolean canUseId(List<JRExpressionCollector> collectors, JRExpression expression, Integer id) {
        boolean canUse = this.canUseId(expression, id);
        if (canUse) {
            for (JRExpressionCollector collector : collectors) {
                if (collector.canUseId(expression, id)) continue;
                canUse = false;
            }
        }
        return canUse;
    }

    protected JRExpressionCollector rootCollector() {
        return this.parent == null ? this : this.parent;
    }

    protected boolean hasExpression(Integer id, JRExpression expression) {
        JRExpression existingExpression = this.generatedIds.get(id);
        return existingExpression != null && existingExpression.equals(expression);
    }

    protected List<JRExpressionCollector> collectorsForExpression(Integer id, JRExpression expression) {
        JRExpressionCollector root = this.rootCollector();
        ArrayList<JRExpressionCollector> collectors = new ArrayList<JRExpressionCollector>();
        if (root.hasExpression(id, expression)) {
            collectors.add(root);
        }
        for (JRExpressionCollector collector : root.datasetCollectors.values()) {
            if (!collector.hasExpression(id, expression)) continue;
            collectors.add(collector);
        }
        for (JRExpressionCollector collector : root.crosstabCollectors.values()) {
            if (!collector.hasExpression(id, expression)) continue;
            collectors.add(collector);
        }
        return collectors;
    }

    protected void pushContextObject(Object context) {
        this.contextStack.addLast(context);
    }

    protected Object popContextObject() {
        return this.contextStack.removeLast();
    }

    protected void setExpressionContext(JRExpression expression) {
        if (!this.contextStack.isEmpty()) {
            Object context = this.contextStack.getLast();
            this.expressionContextMap.put(expression, context);
        }
    }

    public JRExpressionCollector getCollector(JRElementDataset elementDataset) {
        JRDatasetRun datasetRun = elementDataset.getDatasetRun();
        JRExpressionCollector collector = datasetRun == null ? this : this.getDatasetCollector(datasetRun.getDatasetName());
        return collector;
    }

    public JRExpressionCollector getDatasetCollector(String datasetName) {
        JRExpressionCollector collector;
        if (this.parent == null) {
            collector = this.datasetCollectors.get(datasetName);
            if (collector == null) {
                collector = new JRExpressionCollector(this.jasperReportsContext, this, this.report);
                this.datasetCollectors.put(datasetName, collector);
                if (log.isTraceEnabled()) {
                    log.trace(this.hashCode() + " created collector " + collector.hashCode() + " for dataset " + datasetName);
                }
            }
        } else {
            collector = this.parent.getDatasetCollector(datasetName);
        }
        return collector;
    }

    public JRExpressionCollector getCollector(JRDataset dataset) {
        JRExpressionCollector collector = this.parent == null ? (dataset.isMainDataset() || this.datasetCollectors == null ? this : this.getDatasetCollector(dataset.getName())) : this.parent.getCollector(dataset);
        return collector;
    }

    public JRExpressionCollector getCollector(JRCrosstab crosstab) {
        JRExpressionCollector collector;
        if (this.parent == null) {
            collector = this.crosstabCollectors.get(crosstab);
            if (collector == null) {
                collector = new JRExpressionCollector(this.jasperReportsContext, this, this.report);
                this.crosstabCollectors.put(crosstab, collector);
            }
        } else {
            collector = this.parent.getCollector(crosstab);
        }
        return collector;
    }

    public List<JRExpression> getExpressions() {
        return new ArrayList<JRExpression>(this.generatedIds.expressions());
    }

    @Deprecated
    public List<JRExpression> getCompiledExpressions() {
        List<JRExpression> expressions = this.generatedIds.expressions();
        ArrayList<JRExpression> compiledExpressions = new ArrayList<JRExpression>(expressions.size());
        for (JRExpression expression : expressions) {
            if (expression.getType() == ExpressionTypeEnum.SIMPLE_TEXT) continue;
            compiledExpressions.add(expression);
        }
        return compiledExpressions;
    }

    public Collection<JRExpression> getReportExpressions() {
        return Collections.unmodifiableSet(this.expressionIds.keySet());
    }

    public List<JRExpression> getExpressions(JRDataset dataset) {
        return this.getCollector(dataset).getExpressions();
    }

    public List<JRExpression> getExpressions(JRCrosstab crosstab) {
        return this.getCollector(crosstab).getExpressions();
    }

    public Integer getExpressionId(JRExpression expression) {
        return this.expressionIds.get(expression);
    }

    public JRExpression getExpression(int expressionId) {
        return this.generatedIds.expression(expressionId);
    }

    public Integer getCrosstabId(JRCrosstab crosstab) {
        return this.crosstabIds.get(crosstab);
    }

    public Object getExpressionContext(JRExpression expression) {
        return this.expressionContextMap.get(expression);
    }

    public Collection<JRExpression> collect() {
        this.collectTemplates();
        this.collect(this.report.getDefaultStyle());
        this.collect(this.report.getMainDataset());
        JRDataset[] datasets = this.report.getDatasets();
        if (datasets != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                JRExpressionCollector collector = this.getCollector(datasets[i]);
                collector.collect(datasets[i]);
            }
        }
        this.collect(this.report.getBackground());
        this.collect(this.report.getTitle());
        this.collect(this.report.getPageHeader());
        this.collect(this.report.getColumnHeader());
        this.collect(this.report.getDetailSection());
        this.collect(this.report.getColumnFooter());
        this.collect(this.report.getPageFooter());
        this.collect(this.report.getLastPageFooter());
        this.collect(this.report.getSummary());
        this.collect(this.report.getNoData());
        return this.getExpressions();
    }

    protected void collectTemplates() {
        JRReportTemplate[] templates = this.report.getTemplates();
        if (templates != null) {
            for (int i = 0; i < templates.length; ++i) {
                JRReportTemplate template = templates[i];
                this.collect(template);
            }
        }
    }

    protected void collect(JRReportTemplate template) {
        this.addExpression(template.getSourceExpression());
    }

    public void collect(JRStyle style) {
        if (style != null && this.collectedStyles.add(style)) {
            JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
            if (conditionalStyles != null && conditionalStyles.length > 0) {
                for (int i = 0; i < conditionalStyles.length; ++i) {
                    this.addExpression(conditionalStyles[i].getConditionExpression());
                }
            }
            this.collect(style.getStyle());
        }
    }

    private void collect(JRParameter[] parameters) {
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.addExpression(parameters[i].getDefaultValueExpression());
            }
        }
    }

    private void collect(JRField[] fields) {
        if (fields != null && fields.length > 0) {
            for (JRField field : fields) {
                this.collectPropertyExpressions(field.getPropertyExpressions());
            }
        }
    }

    private void collect(JRVariable[] variables) {
        if (variables != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                JRVariable variable = variables[i];
                this.addExpression(variable.getExpression());
                this.addExpression(variable.getInitialValueExpression());
            }
        }
    }

    private void collect(JRGroup[] groups) {
        if (groups != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                JRGroup group = groups[i];
                this.addExpression(group.getExpression());
                this.collect(group.getGroupHeaderSection());
                this.collect(group.getGroupFooterSection());
            }
        }
    }

    private void collect(JRSection section) {
        if (section != null) {
            JRPart[] parts;
            JRBand[] bands = section.getBands();
            if (bands != null && bands.length > 0) {
                for (int i = 0; i < bands.length; ++i) {
                    this.collect(bands[i]);
                }
            }
            if ((parts = section.getParts()) != null && parts.length > 0) {
                for (int i = 0; i < parts.length; ++i) {
                    this.collect(parts[i]);
                }
            }
        }
    }

    private void collect(JRBand band) {
        if (band != null) {
            List<ExpressionReturnValue> returnValues;
            this.addExpression(band.getPrintWhenExpression());
            JRElement[] elements = band.getElements();
            if (elements != null && elements.length > 0) {
                for (int i = 0; i < elements.length; ++i) {
                    elements[i].collectExpressions(this);
                }
            }
            if ((returnValues = band.getReturnValues()) != null && returnValues.size() > 0) {
                for (ExpressionReturnValue returnValue : returnValues) {
                    this.addExpression(returnValue.getExpression());
                }
            }
        }
    }

    private void collect(JRPart part) {
        if (part != null) {
            this.addExpression(part.getPrintWhenExpression());
            this.addExpression(part.getPartNameExpression());
            ComponentKey componentKey = part.getComponentKey();
            PartComponentManager manager = PartComponentsEnvironment.getInstance(this.jasperReportsContext).getManager(componentKey);
            PartComponent component = part.getComponent();
            manager.getComponentCompiler(this.jasperReportsContext).collectExpressions(component, this);
        }
    }

    private void collectElement(JRElement element) {
        this.collect(element.getStyle());
        this.addExpression(element.getPrintWhenExpression());
        this.collectPropertyExpressions(element.getPropertyExpressions());
    }

    public void collectPropertyExpressions(JRPropertyExpression[] propertyExpressions) {
        if (propertyExpressions != null && propertyExpressions.length > 0) {
            for (int i = 0; i < propertyExpressions.length; ++i) {
                this.collectPropertyExpression(propertyExpressions[i]);
            }
        }
    }

    protected void collectPropertyExpression(JRPropertyExpression propertyExpression) {
        this.addExpression(propertyExpression.getValueExpression());
    }

    private void collectAnchor(JRAnchor anchor) {
        this.addExpression(anchor.getAnchorNameExpression());
        this.addExpression(anchor.getBookmarkLevelExpression());
    }

    public void collectHyperlink(JRHyperlink hyperlink) {
        if (hyperlink != null) {
            this.addExpression(hyperlink.getHyperlinkReferenceExpression());
            this.addExpression(hyperlink.getHyperlinkWhenExpression());
            this.addExpression(hyperlink.getHyperlinkAnchorExpression());
            this.addExpression(hyperlink.getHyperlinkPageExpression());
            this.addExpression(hyperlink.getHyperlinkTooltipExpression());
            JRHyperlinkParameter[] hyperlinkParameters = hyperlink.getHyperlinkParameters();
            if (hyperlinkParameters != null) {
                for (int i = 0; i < hyperlinkParameters.length; ++i) {
                    JRHyperlinkParameter parameter = hyperlinkParameters[i];
                    this.collectHyperlinkParameter(parameter);
                }
            }
        }
    }

    protected void collectHyperlinkParameter(JRHyperlinkParameter parameter) {
        if (parameter != null) {
            this.addExpression(parameter.getValueExpression());
        }
    }

    public void collect(JRBreak breakElement) {
        this.collectElement(breakElement);
    }

    public void collect(JRLine line) {
        this.collectElement(line);
    }

    public void collect(JRRectangle rectangle) {
        this.collectElement(rectangle);
    }

    public void collect(JREllipse ellipse) {
        this.collectElement(ellipse);
    }

    public void collect(JRImage image) {
        this.collectElement(image);
        this.addExpression(image.getExpression());
        this.collectAnchor(image);
        this.collectHyperlink(image);
    }

    public void collect(JRStaticText staticText) {
        this.collectElement(staticText);
    }

    public void collect(JRTextField textField) {
        this.collectElement(textField);
        this.addExpression(textField.getExpression());
        this.addExpression(textField.getPatternExpression());
        this.collectAnchor(textField);
        this.collectHyperlink(textField);
    }

    public void collect(JRSubreport subreport) {
        this.collectElement(subreport);
        this.addExpression(subreport.getParametersMapExpression());
        JRSubreportParameter[] parameters = subreport.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int j = 0; j < parameters.length; ++j) {
                this.addExpression(parameters[j].getExpression());
            }
        }
        this.addExpression(subreport.getConnectionExpression());
        this.addExpression(subreport.getDataSourceExpression());
        this.addExpression(subreport.getExpression());
    }

    public void collect(JRChart chart) {
        this.collectElement(chart);
        this.collectAnchor(chart);
        this.collectHyperlink(chart);
        this.addExpression(chart.getTitleExpression());
        this.addExpression(chart.getSubtitleExpression());
        chart.getDataset().collectExpressions(this);
        chart.getPlot().collectExpressions(this);
    }

    public void collect(JRPieDataset pieDataset) {
        JRExpressionCollector collector;
        this.collect((JRElementDataset)pieDataset);
        JRPieSeries[] pieSeries = pieDataset.getSeries();
        if (pieSeries != null && pieSeries.length > 0) {
            collector = this.getCollector(pieDataset);
            for (int j = 0; j < pieSeries.length; ++j) {
                collector.collect(pieSeries[j]);
            }
        }
        collector = this.getCollector(pieDataset);
        collector.addExpression(pieDataset.getOtherKeyExpression());
        collector.addExpression(pieDataset.getOtherLabelExpression());
        collector.collectHyperlink(pieDataset.getOtherSectionHyperlink());
    }

    public void collect(JRCategoryDataset categoryDataset) {
        this.collect((JRElementDataset)categoryDataset);
        JRCategorySeries[] categorySeries = categoryDataset.getSeries();
        if (categorySeries != null && categorySeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(categoryDataset);
            for (int j = 0; j < categorySeries.length; ++j) {
                collector.collect(categorySeries[j]);
            }
        }
    }

    public void collect(JRXyDataset xyDataset) {
        this.collect((JRElementDataset)xyDataset);
        JRXySeries[] xySeries = xyDataset.getSeries();
        if (xySeries != null && xySeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(xyDataset);
            for (int j = 0; j < xySeries.length; ++j) {
                collector.collect(xySeries[j]);
            }
        }
    }

    public void collect(JRTimeSeriesDataset timeSeriesDataset) {
        this.collect((JRElementDataset)timeSeriesDataset);
        JRTimeSeries[] timeSeries = timeSeriesDataset.getSeries();
        if (timeSeries != null && timeSeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(timeSeriesDataset);
            for (int i = 0; i < timeSeries.length; ++i) {
                collector.collect(timeSeries[i]);
            }
        }
    }

    public void collect(JRTimePeriodDataset timePeriodDataset) {
        this.collect((JRElementDataset)timePeriodDataset);
        JRTimePeriodSeries[] timePeriodSeries = timePeriodDataset.getSeries();
        if (timePeriodSeries != null && timePeriodSeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(timePeriodDataset);
            for (int i = 0; i < timePeriodSeries.length; ++i) {
                collector.collect(timePeriodSeries[i]);
            }
        }
    }

    public void collect(JRGanttDataset ganttDataset) {
        this.collect((JRElementDataset)ganttDataset);
        JRGanttSeries[] ganttSeries = ganttDataset.getSeries();
        if (ganttSeries != null && ganttSeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(ganttDataset);
            for (int j = 0; j < ganttSeries.length; ++j) {
                collector.collect(ganttSeries[j]);
            }
        }
    }

    public void collect(JRValueDataset valueDataset) {
        this.collect((JRElementDataset)valueDataset);
        JRExpressionCollector collector = this.getCollector(valueDataset);
        collector.addExpression(valueDataset.getValueExpression());
    }

    private void collect(JRXySeries xySeries) {
        this.addExpression(xySeries.getSeriesExpression());
        this.addExpression(xySeries.getXValueExpression());
        this.addExpression(xySeries.getYValueExpression());
        this.addExpression(xySeries.getLabelExpression());
        this.collectHyperlink(xySeries.getItemHyperlink());
    }

    private void collect(JRPieSeries pieSeries) {
        this.addExpression(pieSeries.getKeyExpression());
        this.addExpression(pieSeries.getValueExpression());
        this.addExpression(pieSeries.getLabelExpression());
        this.collectHyperlink(pieSeries.getSectionHyperlink());
    }

    private void collect(JRCategorySeries categorySeries) {
        this.addExpression(categorySeries.getSeriesExpression());
        this.addExpression(categorySeries.getCategoryExpression());
        this.addExpression(categorySeries.getValueExpression());
        this.addExpression(categorySeries.getLabelExpression());
        this.collectHyperlink(categorySeries.getItemHyperlink());
    }

    private void collect(JRGanttSeries ganttSeries) {
        this.addExpression(ganttSeries.getSeriesExpression());
        this.addExpression(ganttSeries.getTaskExpression());
        this.addExpression(ganttSeries.getSubtaskExpression());
        this.addExpression(ganttSeries.getStartDateExpression());
        this.addExpression(ganttSeries.getEndDateExpression());
        this.addExpression(ganttSeries.getPercentExpression());
        this.addExpression(ganttSeries.getLabelExpression());
        this.collectHyperlink(ganttSeries.getItemHyperlink());
    }

    public void collect(JRBarPlot barPlot) {
        this.addExpression(barPlot.getCategoryAxisLabelExpression());
        this.addExpression(barPlot.getValueAxisLabelExpression());
        this.addExpression(barPlot.getDomainAxisMinValueExpression());
        this.addExpression(barPlot.getDomainAxisMaxValueExpression());
        this.addExpression(barPlot.getRangeAxisMinValueExpression());
        this.addExpression(barPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRBar3DPlot barPlot) {
        this.addExpression(barPlot.getCategoryAxisLabelExpression());
        this.addExpression(barPlot.getValueAxisLabelExpression());
        this.addExpression(barPlot.getRangeAxisMinValueExpression());
        this.addExpression(barPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRLinePlot linePlot) {
        this.addExpression(linePlot.getCategoryAxisLabelExpression());
        this.addExpression(linePlot.getValueAxisLabelExpression());
        this.addExpression(linePlot.getDomainAxisMinValueExpression());
        this.addExpression(linePlot.getDomainAxisMaxValueExpression());
        this.addExpression(linePlot.getRangeAxisMinValueExpression());
        this.addExpression(linePlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRTimeSeriesPlot timeSeriesPlot) {
        this.addExpression(timeSeriesPlot.getTimeAxisLabelExpression());
        this.addExpression(timeSeriesPlot.getValueAxisLabelExpression());
        this.addExpression(timeSeriesPlot.getDomainAxisMinValueExpression());
        this.addExpression(timeSeriesPlot.getDomainAxisMaxValueExpression());
        this.addExpression(timeSeriesPlot.getRangeAxisMinValueExpression());
        this.addExpression(timeSeriesPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRScatterPlot scatterPlot) {
        this.addExpression(scatterPlot.getXAxisLabelExpression());
        this.addExpression(scatterPlot.getYAxisLabelExpression());
        this.addExpression(scatterPlot.getDomainAxisMinValueExpression());
        this.addExpression(scatterPlot.getDomainAxisMaxValueExpression());
        this.addExpression(scatterPlot.getRangeAxisMinValueExpression());
        this.addExpression(scatterPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRAreaPlot areaPlot) {
        this.addExpression(areaPlot.getCategoryAxisLabelExpression());
        this.addExpression(areaPlot.getValueAxisLabelExpression());
        this.addExpression(areaPlot.getDomainAxisMinValueExpression());
        this.addExpression(areaPlot.getDomainAxisMaxValueExpression());
        this.addExpression(areaPlot.getRangeAxisMinValueExpression());
        this.addExpression(areaPlot.getRangeAxisMaxValueExpression());
    }

    private void collect(JRTimeSeries timeSeries) {
        this.addExpression(timeSeries.getSeriesExpression());
        this.addExpression(timeSeries.getTimePeriodExpression());
        this.addExpression(timeSeries.getValueExpression());
        this.addExpression(timeSeries.getLabelExpression());
        this.collectHyperlink(timeSeries.getItemHyperlink());
    }

    private void collect(JRTimePeriodSeries timePeriodSeries) {
        this.addExpression(timePeriodSeries.getSeriesExpression());
        this.addExpression(timePeriodSeries.getStartDateExpression());
        this.addExpression(timePeriodSeries.getEndDateExpression());
        this.addExpression(timePeriodSeries.getValueExpression());
        this.addExpression(timePeriodSeries.getLabelExpression());
        this.collectHyperlink(timePeriodSeries.getItemHyperlink());
    }

    public void collect(JRXyzDataset xyzDataset) {
        this.collect((JRElementDataset)xyzDataset);
        JRXyzSeries[] xyzSeries = xyzDataset.getSeries();
        if (xyzSeries != null && xyzSeries.length > 0) {
            JRExpressionCollector collector = this.getCollector(xyzDataset);
            for (int j = 0; j < xyzSeries.length; ++j) {
                collector.collect(xyzSeries[j]);
            }
        }
    }

    private void collect(JRXyzSeries xyzSeries) {
        this.addExpression(xyzSeries.getSeriesExpression());
        this.addExpression(xyzSeries.getXValueExpression());
        this.addExpression(xyzSeries.getYValueExpression());
        this.addExpression(xyzSeries.getZValueExpression());
        this.collectHyperlink(xyzSeries.getItemHyperlink());
    }

    public void collect(JRBubblePlot bubblePlot) {
        this.addExpression(bubblePlot.getXAxisLabelExpression());
        this.addExpression(bubblePlot.getYAxisLabelExpression());
        this.addExpression(bubblePlot.getDomainAxisMinValueExpression());
        this.addExpression(bubblePlot.getDomainAxisMaxValueExpression());
        this.addExpression(bubblePlot.getRangeAxisMinValueExpression());
        this.addExpression(bubblePlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRHighLowPlot highLowPlot) {
        this.addExpression(highLowPlot.getTimeAxisLabelExpression());
        this.addExpression(highLowPlot.getValueAxisLabelExpression());
        this.addExpression(highLowPlot.getDomainAxisMinValueExpression());
        this.addExpression(highLowPlot.getDomainAxisMaxValueExpression());
        this.addExpression(highLowPlot.getRangeAxisMinValueExpression());
        this.addExpression(highLowPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRDataRange dataRange) {
        if (dataRange != null) {
            this.addExpression(dataRange.getLowExpression());
            this.addExpression(dataRange.getHighExpression());
        }
    }

    public void collect(JRMeterPlot meterPlot) {
        List<JRMeterInterval> intervals = meterPlot.getIntervals();
        if (intervals != null) {
            for (JRMeterInterval interval : intervals) {
                this.collect(interval.getDataRange());
            }
        }
        this.collect(meterPlot.getDataRange());
    }

    public void collect(JRThermometerPlot thermometerPlot) {
        this.collect(thermometerPlot.getDataRange());
        this.collect(thermometerPlot.getLowRange());
        this.collect(thermometerPlot.getMediumRange());
        this.collect(thermometerPlot.getHighRange());
    }

    public void collect(JRHighLowDataset highLowDataset) {
        this.collect((JRElementDataset)highLowDataset);
        JRExpressionCollector collector = this.getCollector(highLowDataset);
        collector.addExpression(highLowDataset.getSeriesExpression());
        collector.addExpression(highLowDataset.getDateExpression());
        collector.addExpression(highLowDataset.getHighExpression());
        collector.addExpression(highLowDataset.getLowExpression());
        collector.addExpression(highLowDataset.getOpenExpression());
        collector.addExpression(highLowDataset.getCloseExpression());
        collector.addExpression(highLowDataset.getVolumeExpression());
        collector.collectHyperlink(highLowDataset.getItemHyperlink());
    }

    public void collect(JRCandlestickPlot candlestickPlot) {
        this.addExpression(candlestickPlot.getTimeAxisLabelExpression());
        this.addExpression(candlestickPlot.getValueAxisLabelExpression());
        this.addExpression(candlestickPlot.getDomainAxisMinValueExpression());
        this.addExpression(candlestickPlot.getDomainAxisMaxValueExpression());
        this.addExpression(candlestickPlot.getRangeAxisMinValueExpression());
        this.addExpression(candlestickPlot.getRangeAxisMaxValueExpression());
    }

    public void collect(JRCrosstab crosstab) {
        JRCrosstabMeasure[] measures;
        JRCrosstabColumnGroup[] colGroups;
        this.collectElement(crosstab);
        this.createCrosstabId(crosstab);
        JRCrosstabDataset dataset = crosstab.getDataset();
        this.collect(dataset);
        JRExpressionCollector datasetCollector = this.getCollector(dataset);
        JRExpressionCollector crosstabCollector = this.getCollector(crosstab);
        crosstabCollector.collect(this.report.getDefaultStyle());
        this.addExpression(crosstab.getParametersMapExpression());
        JRCrosstabParameter[] parameters = crosstab.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                this.addExpression(parameters[i].getExpression());
            }
        }
        if (crosstab.getTitleCell() != null) {
            crosstabCollector.collect(crosstab.getTitleCell().getCellContents());
        }
        crosstabCollector.collect(crosstab.getHeaderCell());
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        if (rowGroups != null) {
            for (int i = 0; i < rowGroups.length; ++i) {
                JRCrosstabRowGroup rowGroup = rowGroups[i];
                JRCrosstabBucket bucket = rowGroup.getBucket();
                datasetCollector.addExpression(bucket.getExpression());
                crosstabCollector.pushContextObject(rowGroup);
                crosstabCollector.addExpression(bucket.getOrderByExpression());
                this.addExpression(bucket.getComparatorExpression());
                crosstabCollector.collect(rowGroup.getHeader());
                crosstabCollector.collect(rowGroup.getTotalHeader());
                crosstabCollector.popContextObject();
            }
        }
        if ((colGroups = crosstab.getColumnGroups()) != null) {
            for (int i = 0; i < colGroups.length; ++i) {
                JRCrosstabColumnGroup columnGroup = colGroups[i];
                JRCrosstabBucket bucket = columnGroup.getBucket();
                datasetCollector.addExpression(bucket.getExpression());
                crosstabCollector.pushContextObject(columnGroup);
                crosstabCollector.addExpression(bucket.getOrderByExpression());
                this.addExpression(bucket.getComparatorExpression());
                crosstabCollector.collect(columnGroup.getCrosstabHeader());
                crosstabCollector.collect(columnGroup.getHeader());
                crosstabCollector.collect(columnGroup.getTotalHeader());
                crosstabCollector.popContextObject();
            }
        }
        if ((measures = crosstab.getMeasures()) != null) {
            for (int i = 0; i < measures.length; ++i) {
                datasetCollector.addExpression(measures[i].getValueExpression());
            }
        }
        crosstabCollector.collect(crosstab.getWhenNoDataCell());
        this.collectCrosstabCells(crosstab, crosstabCollector);
    }

    private void createCrosstabId(JRCrosstab crosstab) {
        this.crosstabIds.put(crosstab, this.crosstabIds.size());
    }

    private void collectCrosstabCells(JRCrosstab crosstab, JRExpressionCollector crosstabCollector) {
        block5: {
            block4: {
                if (!(crosstab instanceof JRDesignCrosstab)) break block4;
                List<JRCrosstabCell> cellsList = ((JRDesignCrosstab)crosstab).getCellsList();
                if (cellsList == null) break block5;
                for (JRCrosstabCell cell : cellsList) {
                    crosstabCollector.collect(cell.getContents());
                }
                break block5;
            }
            JRCrosstabCell[][] cells = crosstab.getCells();
            if (cells != null) {
                for (int i = 0; i < cells.length; ++i) {
                    for (int j = 0; j < cells[i].length; ++j) {
                        if (cells[i][j] == null) continue;
                        crosstabCollector.collect(cells[i][j].getContents());
                    }
                }
            }
        }
    }

    public Collection<JRExpression> collect(JRDataset dataset) {
        JRExpressionCollector collector = this.getCollector(dataset);
        collector.collectPropertyExpressions(dataset.getPropertyExpressions());
        collector.collect(dataset.getParameters());
        collector.collect(dataset.getFields());
        collector.collect(dataset.getVariables());
        collector.collect(dataset.getGroups());
        collector.addExpression(dataset.getFilterExpression());
        return this.getExpressions(dataset);
    }

    public void collect(JRElementDataset dataset) {
        this.collect(dataset.getDatasetRun());
        JRExpression incrementWhenExpression = dataset.getIncrementWhenExpression();
        if (incrementWhenExpression != null) {
            JRExpressionCollector datasetCollector = this.getCollector(dataset);
            datasetCollector.addExpression(incrementWhenExpression);
        }
    }

    public void collect(JRDatasetRun datasetRun) {
        if (datasetRun != null) {
            this.addExpression(datasetRun.getParametersMapExpression());
            this.addExpression(datasetRun.getConnectionExpression());
            this.addExpression(datasetRun.getDataSourceExpression());
            JRDatasetParameter[] parameters = datasetRun.getParameters();
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    this.addExpression(parameters[i].getExpression());
                }
            }
        }
    }

    protected void collect(JRCellContents cell) {
        if (cell != null) {
            this.collect(cell.getStyle());
            JRElement[] elements = cell.getElements();
            if (elements != null && elements.length > 0) {
                for (int i = 0; i < elements.length; ++i) {
                    elements[i].collectExpressions(this);
                }
            }
        }
    }

    public void collect(JRFrame frame) {
        this.collectElement(frame);
        JRElement[] elements = frame.getElements();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                elements[i].collectExpressions(this);
            }
        }
    }

    public void collect(JRComponentElement componentElement) {
        this.collectElement(componentElement);
        ComponentKey componentKey = componentElement.getComponentKey();
        ComponentManager manager = ComponentsEnvironment.getInstance(this.jasperReportsContext).getManager(componentKey);
        Component component = componentElement.getComponent();
        manager.getComponentCompiler(this.jasperReportsContext).collectExpressions(component, this);
    }

    public void collect(JRGenericElement element) {
        this.collectElement(element);
        JRGenericElementParameter[] parameters = element.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            JRGenericElementParameter parameter = parameters[i];
            this.addExpression(parameter.getValueExpression());
        }
    }

    public void collect(MultiAxisData data) {
        if (data == null) {
            return;
        }
        MultiAxisDataset dataset = data.getDataset();
        this.collect(dataset);
        JRExpressionCollector datasetCollector = this.getCollector(dataset);
        List<DataAxis> axisList = data.getDataAxisList();
        for (DataAxis dataAxis : axisList) {
            for (DataAxisLevel level : dataAxis.getLevels()) {
                this.collect(level, datasetCollector);
            }
        }
        for (DataMeasure measure : data.getMeasures()) {
            this.addExpression(measure.getLabelExpression());
            datasetCollector.addExpression(measure.getValueExpression());
        }
    }

    protected void collect(DataAxisLevel level, JRExpressionCollector datasetCollector) {
        this.addExpression(level.getLabelExpression());
        DataLevelBucket bucket = level.getBucket();
        datasetCollector.addExpression(bucket.getExpression());
        datasetCollector.addExpression(bucket.getLabelExpression());
        this.addExpression(bucket.getComparatorExpression());
        List<DataLevelBucketProperty> bucketProperties = bucket.getBucketProperties();
        if (bucketProperties != null) {
            for (DataLevelBucketProperty bucketProperty : bucketProperties) {
                datasetCollector.addExpression(bucketProperty.getExpression());
            }
        }
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    protected static class GeneratedIds {
        private final TreeMap<Integer, JRExpression> ids = new TreeMap();
        private int nextId;
        private List<JRExpression> expressions;

        protected GeneratedIds() {
        }

        public JRExpression get(Integer id) {
            return this.ids.get(id);
        }

        public JRExpression put(Integer id, JRExpression expression) {
            this.expressions = null;
            return this.ids.put(id, expression);
        }

        public void move(Integer id, Integer newId) {
            this.expressions = null;
            JRExpression expression = this.ids.remove(id);
            if (expression != null) {
                this.ids.put(newId, expression);
            }
        }

        public Integer nextId() {
            Integer id = this.nextId;
            while (this.ids.containsKey(id)) {
                id = ++this.nextId;
            }
            return id;
        }

        public List<JRExpression> expressions() {
            if (this.expressions == null) {
                this.expressions = new ArrayList<JRExpression>(this.ids.values());
            }
            return this.expressions;
        }

        public JRExpression expression(int id) {
            return this.ids.get(id);
        }
    }
}

