/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.sf.jasperreports.compilers.DirectEvaluator;
import net.sf.jasperreports.compilers.DirectExpressionValueFilter;
import net.sf.jasperreports.compilers.DirectValueClassFilterDecorator;
import net.sf.jasperreports.compilers.ReportClassFilter;
import net.sf.jasperreports.compilers.ReportExpressionEvaluationData;
import net.sf.jasperreports.compilers.ReportExpressionsCompilation;
import net.sf.jasperreports.compilers.ReportExpressionsCompiler;
import net.sf.jasperreports.compilers.ReportSourceCompilation;
import net.sf.jasperreports.compilers.SimpleTextEvaluators;
import net.sf.jasperreports.compilers.StandardExpressionEvaluators;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.CompilationUnits;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRReportCompileData;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRStringUtil;

public abstract class JRAbstractCompiler
implements JRCompiler {
    public static final String EXCEPTION_MESSAGE_KEY_CROSSTAB_ID_NOT_FOUND = "compilers.crosstab.id.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_DESIGN_COMPILE_ERROR = "compilers.design.compile.error";
    public static final String EXCEPTION_MESSAGE_KEY_LANGUAGE_NOT_SUPPORTED = "compilers.language.not.supported";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_EXPRESSIONS_COMPILE_ERROR = "compilers.report.expressions.compile.error";
    public static final String EXCEPTION_MESSAGE_KEY_TEMP_DIR_NOT_FOUND = "compilers.temp.dir.not.found";
    private static final int NAME_SUFFIX_RANDOM_MAX = 1000000;
    private static final Random random = new Random();
    protected final JasperReportsContext jasperReportsContext;
    private final boolean needsSourceFiles;
    private ReportExpressionsCompiler expressionsCompiler;
    protected ReportClassFilter reportClassFilter;

    protected JRAbstractCompiler(JasperReportsContext jasperReportsContext, boolean needsSourceFiles) {
        this.jasperReportsContext = jasperReportsContext;
        this.needsSourceFiles = needsSourceFiles;
        this.expressionsCompiler = ReportExpressionsCompiler.instance();
        this.reportClassFilter = new ReportClassFilter(jasperReportsContext);
    }

    public static String getUnitName(JasperReport report, JRDataset dataset) {
        return JRAbstractCompiler.getUnitName((JRReport)report, dataset, report.getCompileNameSuffix());
    }

    protected static String getUnitName(JRReport report, JRDataset dataset, String nameSuffix) {
        String className = dataset.isMainDataset() ? report.getName() : report.getName() + "_" + dataset.getName();
        className = JRStringUtil.getJavaIdentifier(className) + nameSuffix;
        return className;
    }

    public static String getUnitName(JasperReport report, JRCrosstab crosstab) {
        return JRAbstractCompiler.getUnitName((JRReport)report, crosstab.getId(), report.getCompileNameSuffix());
    }

    protected static String getUnitName(JRReport report, JRCrosstab crosstab, JRExpressionCollector expressionCollector, String nameSuffix) {
        Integer crosstabId = expressionCollector.getCrosstabId(crosstab);
        if (crosstabId == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CROSSTAB_ID_NOT_FOUND, (Object[])null);
        }
        return JRAbstractCompiler.getUnitName(report, crosstabId, nameSuffix);
    }

    protected static String getUnitName(JRReport report, int crosstabId, String nameSuffix) {
        return JRStringUtil.getJavaIdentifier(report.getName()) + "_CROSSTAB" + crosstabId + nameSuffix;
    }

    @Override
    public final JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        String tempDirStr;
        this.checkLanguage(jasperDesign.getLanguage());
        JRExpressionCollector expressionCollector = JRExpressionCollector.collector(this.jasperReportsContext, jasperDesign);
        this.verifyDesign(jasperDesign, expressionCollector);
        String nameSuffix = JRAbstractCompiler.createNameSuffix();
        boolean isKeepJavaFile = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty("net.sf.jasperreports.compiler.keep.java.file");
        File tempDirFile = null;
        if (!(!isKeepJavaFile && !this.needsSourceFiles || (tempDirFile = new File(tempDirStr = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty("net.sf.jasperreports.compiler.temp.dir"))).exists() && tempDirFile.isDirectory())) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_TEMP_DIR_NOT_FOUND, tempDirStr);
        }
        List<JRDataset> datasets = jasperDesign.getDatasetsList();
        List<JRCrosstab> crosstabs = jasperDesign.getCrosstabs();
        JRCompilationUnit[] units = new JRCompilationUnit[datasets.size() + crosstabs.size() + 1];
        units[0] = this.createCompileUnit(jasperDesign, jasperDesign.getMainDesignDataset(), expressionCollector, tempDirFile, nameSuffix);
        int sourcesCount = 1;
        for (JRDesignDataset jRDesignDataset : datasets) {
            units[sourcesCount] = this.createCompileUnit(jasperDesign, jRDesignDataset, expressionCollector, tempDirFile, nameSuffix);
            ++sourcesCount;
        }
        for (JRDesignCrosstab jRDesignCrosstab : crosstabs) {
            units[sourcesCount] = this.createCompileUnit(jasperDesign, jRDesignCrosstab, expressionCollector, tempDirFile, nameSuffix);
            ++sourcesCount;
        }
        String classpath = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty("net.sf.jasperreports.compiler.classpath");
        CompilationUnits compilationUnits = new CompilationUnits(units);
        JRCompilationUnit[] sourceUnits = compilationUnits.getSourceUnits();
        try {
            JasperReport jasperReport;
            String compileErrors;
            if (sourceUnits.length > 0 && (compileErrors = this.compileUnits(sourceUnits, classpath, tempDirFile)) != null) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_EXPRESSIONS_COMPILE_ERROR, compileErrors);
            }
            JRReportCompileData reportCompileData = new JRReportCompileData();
            reportCompileData.setMainDatasetCompileData(this.createCompileData(compilationUnits.getCompiledUnit(0)));
            ListIterator<JRCloneable> it = datasets.listIterator();
            while (it.hasNext()) {
                JRDesignDataset dataset = (JRDesignDataset)it.next();
                reportCompileData.setDatasetCompileData(dataset, this.createCompileData(compilationUnits.getCompiledUnit(it.nextIndex())));
            }
            it = crosstabs.listIterator();
            while (it.hasNext()) {
                JRDesignCrosstab crosstab = (JRDesignCrosstab)it.next();
                Integer crosstabId = expressionCollector.getCrosstabId(crosstab);
                reportCompileData.setCrosstabCompileData(crosstabId, this.createCompileData(compilationUnits.getCompiledUnit(datasets.size() + it.nextIndex())));
            }
            JasperReport jasperReport2 = jasperReport = new JasperReport((JRReport)jasperDesign, this.getCompilerClass(), (Serializable)reportCompileData, expressionCollector, nameSuffix);
            return jasperReport2;
        }
        catch (JRException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DESIGN_COMPILE_ERROR, null, e);
        }
        finally {
            if (this.needsSourceFiles && !isKeepJavaFile) {
                this.deleteSourceFiles(sourceUnits);
            }
        }
    }

    protected ReportExpressionEvaluationData createCompileData(JRCompilationUnit unit) {
        ReportExpressionEvaluationData data = new ReportExpressionEvaluationData();
        data.setCompileData(unit.getCompileData());
        data.setDirectEvaluations(unit.getDirectEvaluations());
        return data;
    }

    private static String createNameSuffix() {
        return "_" + System.currentTimeMillis() + "_" + random.nextInt(1000000);
    }

    protected String getCompilerClass() {
        return this.getClass().getName();
    }

    private void verifyDesign(JasperDesign jasperDesign, JRExpressionCollector expressionCollector) throws JRException {
        Collection<JRValidationFault> brokenRules = JRVerifier.verifyDesign(this.jasperReportsContext, jasperDesign, expressionCollector);
        if (brokenRules != null && brokenRules.size() > 0) {
            throw new JRValidationException(brokenRules);
        }
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignDataset dataset, JRExpressionCollector expressionCollector, File saveSourceDir, String nameSuffix) throws JRException {
        String unitName = JRAbstractCompiler.getUnitName((JRReport)jasperDesign, dataset, nameSuffix);
        JRExpressionCollector datasetCollector = expressionCollector.getCollector(dataset);
        ReportExpressionsCompilation expressions = this.expressionsCompiler.getExpressionsCompilation(datasetCollector);
        JRCompilationUnit compilationUnit = new JRCompilationUnit(unitName);
        compilationUnit.setDirectEvaluations(expressions.getDirectEvaluations());
        ReportSourceCompilation<JRParameter> sourceCompilation = new ReportSourceCompilation<JRParameter>(this.jasperReportsContext, jasperDesign, expressions, dataset.getParametersMap(), dataset.getFieldsMap(), dataset.getVariablesMap(), dataset.getVariables());
        if (sourceCompilation.hasSource()) {
            JRSourceCompileTask sourceTask = new JRSourceCompileTask(jasperDesign, unitName, datasetCollector, sourceCompilation, false);
            JRCompilationSourceCode sourceCode = this.generateSourceCode(sourceTask);
            File sourceFile = this.getSourceFile(saveSourceDir, unitName, sourceCode);
            compilationUnit.setSource(sourceCode, sourceFile, sourceTask);
        }
        return compilationUnit;
    }

    private JRCompilationUnit createCompileUnit(JasperDesign jasperDesign, JRDesignCrosstab crosstab, JRExpressionCollector expressionCollector, File saveSourceDir, String nameSuffix) throws JRException {
        String unitName = JRAbstractCompiler.getUnitName(jasperDesign, crosstab, expressionCollector, nameSuffix);
        JRExpressionCollector crosstabCollector = expressionCollector.getCollector(crosstab);
        ReportExpressionsCompilation expressions = this.expressionsCompiler.getExpressionsCompilation(crosstabCollector);
        JRCompilationUnit compilationUnit = new JRCompilationUnit(unitName);
        compilationUnit.setDirectEvaluations(expressions.getDirectEvaluations());
        ReportSourceCompilation<JRCrosstabParameter> sourceCompilation = new ReportSourceCompilation<JRCrosstabParameter>(this.jasperReportsContext, jasperDesign, expressions, crosstab.getParametersMap(), null, crosstab.getVariablesMap(), crosstab.getVariables());
        if (sourceCompilation.hasSource()) {
            JRSourceCompileTask sourceTask = new JRSourceCompileTask(jasperDesign, unitName, crosstabCollector, sourceCompilation, true);
            JRCompilationSourceCode sourceCode = this.generateSourceCode(sourceTask);
            File sourceFile = this.getSourceFile(saveSourceDir, unitName, sourceCode);
            compilationUnit.setSource(sourceCode, sourceFile, sourceTask);
        }
        return compilationUnit;
    }

    protected File getSourceFile(File saveSourceDir, String unitName, JRCompilationSourceCode sourceCode) {
        File sourceFile = null;
        if (saveSourceDir != null && sourceCode != null && sourceCode.getCode() != null) {
            String fileName = this.getSourceFileName(unitName);
            sourceFile = new File(saveSourceDir, fileName);
            try {
                JRSaver.saveClassSource(sourceCode.getCode(), sourceFile);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
        return sourceFile;
    }

    private void deleteSourceFiles(JRCompilationUnit[] units) {
        for (int i = 0; i < units.length; ++i) {
            units[i].getSourceFile().delete();
        }
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return this.loadEvaluator(jasperReport, jasperReport.getMainDataset());
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        JRReportCompileData reportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        String unitName = reportCompileData.getUnitName(jasperReport, dataset);
        Serializable compileData = reportCompileData.getDatasetCompileData(dataset);
        return this.createEvaluator(compileData, unitName);
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab crosstab) throws JRException {
        JRReportCompileData reportCompileData = (JRReportCompileData)jasperReport.getCompileData();
        String unitName = reportCompileData.getUnitName(jasperReport, crosstab);
        Serializable compileData = reportCompileData.getCrosstabCompileData(crosstab);
        return this.createEvaluator(compileData, unitName);
    }

    protected JREvaluator createEvaluator(Serializable compileData, String unitName) throws JRException {
        JREvaluator evaluator;
        if (compileData instanceof ReportExpressionEvaluationData) {
            ReportExpressionEvaluationData evaluationData = (ReportExpressionEvaluationData)compileData;
            Serializable evaluatorCompileData = evaluationData.getCompileData();
            evaluator = evaluatorCompileData == null ? new DirectEvaluator() : this.loadEvaluator(evaluatorCompileData, unitName);
            StandardExpressionEvaluators evaluators = new StandardExpressionEvaluators(evaluationData.getDirectEvaluations(), this.effectiveDirectValueFilter());
            evaluator.setDirectExpressionEvaluators(evaluators);
        } else {
            evaluator = this.loadEvaluator(compileData, unitName);
            evaluator.setDirectExpressionEvaluators(new SimpleTextEvaluators());
        }
        return evaluator;
    }

    protected DirectExpressionValueFilter effectiveDirectValueFilter() {
        DirectExpressionValueFilter baseFilter = this.directValueFilter();
        DirectExpressionValueFilter effectiveFilter = this.reportClassFilter.isFilteringEnabled() ? new DirectValueClassFilterDecorator(baseFilter, this.reportClassFilter) : baseFilter;
        return effectiveFilter;
    }

    protected DirectExpressionValueFilter directValueFilter() {
        return null;
    }

    protected abstract JREvaluator loadEvaluator(Serializable var1, String var2) throws JRException;

    protected abstract void checkLanguage(String var1) throws JRException;

    protected abstract JRCompilationSourceCode generateSourceCode(JRSourceCompileTask var1) throws JRException;

    protected abstract String compileUnits(JRCompilationUnit[] var1, String var2, File var3) throws JRException;

    protected abstract String getSourceFileName(String var1);
}

