/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ooxml.GenericElementPptxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporterContext;
import net.sf.jasperreports.engine.export.ooxml.PptxContentTypesHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxFontHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxPresentationHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxPresentationRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxRunHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxSlideHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxSlideRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxZip;
import net.sf.jasperreports.engine.export.ooxml.PropsAppHelper;
import net.sf.jasperreports.engine.export.ooxml.PropsCoreHelper;
import net.sf.jasperreports.engine.export.ooxml.type.PptxFieldTypeEnum;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.ExifOrientationEnum;
import net.sf.jasperreports.engine.util.FileBufferedWriter;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.engine.util.PageRange;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.engine.util.StyledTextWriteContext;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.PptxExporterConfiguration;
import net.sf.jasperreports.export.PptxReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersOutputStreamExporterOutput;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPptxExporter
extends JRAbstractExporter<PptxReportConfiguration, PptxExporterConfiguration, OutputStreamExporterOutput, JRPptxExporterContext> {
    private static final Log log = LogFactory.getLog(JRPptxExporter.class);
    public static final String PPTX_EXPORTER_KEY = "net.sf.jasperreports.pptx";
    public static final String PPTX_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.pptx.";
    public static final String PROPERTY_TO_SLIDE_MASTER = "net.sf.jasperreports.export.pptx.to.slide.master";
    public static final String PROPERTY_FIELD_TYPE = "net.sf.jasperreports.export.pptx.field.type";
    public static final String FIELD_TYPE_SLIDENUM = "slidenum";
    public static final String FIELD_TYPE_DATETIME = "datetime";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected PptxZip pptxZip;
    protected PptxFontHelper fontHelper;
    protected PptxPresentationHelper presentationHelper;
    protected PptxPresentationRelsHelper presentationRelsHelper;
    protected PptxContentTypesHelper ctHelper;
    protected PropsAppHelper appHelper;
    protected PropsCoreHelper coreHelper;
    protected PptxSlideHelper slideHelper;
    protected PptxSlideRelsHelper slideRelsHelper;
    protected Writer presentationWriter;
    protected Writer presentationRelsWriter;
    protected Map<String, Pair<String, ExifOrientationEnum>> rendererToImagePathMap;
    protected RenderersCache renderersCache;
    protected int reportIndex;
    protected int pageIndex;
    protected List<Integer> frameIndexStack;
    protected int elementIndex;
    protected boolean startPage;
    protected String invalidCharReplacement;
    protected int slideIndex;
    private PptxRunHelper runHelper;

    public JRPptxExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRPptxExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<PptxExporterConfiguration> getConfigurationInterface() {
        return PptxExporterConfiguration.class;
    }

    @Override
    protected Class<PptxReportConfiguration> getItemConfigurationInterface() {
        return PptxReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersOutputStreamExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.rendererToImagePathMap = new HashMap<String, Pair<String, ExifOrientationEnum>>();
        this.initExport();
        this.ensureOutput();
        OutputStream outputStream = ((OutputStreamExporterOutput)this.getExporterOutput()).getOutputStream();
        try {
            this.exportReportToStream(outputStream);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            ((OutputStreamExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
        this.invalidCharReplacement = this.jasperPrint.hasProperties() && this.jasperPrint.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") ? this.jasperPrint.getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") : this.getPropertiesUtil().getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars", this.jasperPrint);
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
    }

    protected void exportReportToStream(OutputStream os) throws JRException, IOException {
        int endPageIndex;
        int startPageIndex;
        JRAbstractExporter.PageRange pageRange;
        List<JRPrintPage> pages;
        ExporterInputItem item;
        Integer slideMasterReport;
        String keywords;
        String author;
        String subject;
        this.pptxZip = new PptxZip();
        PptxExporterConfiguration configuration = (PptxExporterConfiguration)this.getCurrentConfiguration();
        this.presentationWriter = this.pptxZip.getPresentationEntry().getWriter();
        this.presentationRelsWriter = this.pptxZip.getRelsEntry().getWriter();
        boolean isEmbedFonts = Boolean.TRUE.equals(configuration.isEmbedFonts());
        FileBufferedWriter fontWriter = new FileBufferedWriter();
        this.fontHelper = new PptxFontHelper(this.jasperReportsContext, fontWriter, this.presentationRelsWriter, this.pptxZip, isEmbedFonts);
        this.presentationHelper = new PptxPresentationHelper(this.jasperReportsContext, this.presentationWriter, fontWriter);
        this.presentationHelper.exportHeader(isEmbedFonts);
        this.presentationRelsHelper = new PptxPresentationRelsHelper(this.jasperReportsContext, this.presentationRelsWriter);
        this.presentationRelsHelper.exportHeader();
        this.ctHelper = new PptxContentTypesHelper(this.jasperReportsContext, this.pptxZip.getContentTypesEntry().getWriter());
        this.ctHelper.exportHeader();
        this.appHelper = new PropsAppHelper(this.jasperReportsContext, this.pptxZip.getAppEntry().getWriter());
        this.coreHelper = new PropsCoreHelper(this.jasperReportsContext, this.pptxZip.getCoreEntry().getWriter());
        this.appHelper.exportHeader();
        String application = configuration.getMetadataApplication();
        if (application == null) {
            application = "JasperReports Library version " + Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion();
        }
        this.appHelper.exportProperty("Application", application);
        this.coreHelper.exportHeader();
        String title = configuration.getMetadataTitle();
        if (title != null) {
            this.coreHelper.exportProperty("dc:title", title);
        }
        if ((subject = configuration.getMetadataSubject()) != null) {
            this.coreHelper.exportProperty("dc:subject", subject);
        }
        if ((author = configuration.getMetadataAuthor()) != null) {
            this.coreHelper.exportProperty("dc:creator", author);
        }
        if ((keywords = configuration.getMetadataKeywords()) != null) {
            this.coreHelper.exportProperty("cp:keywords", keywords);
        }
        if ((slideMasterReport = configuration.getSlideMasterReport()) == null) {
            slideMasterReport = 1;
        }
        int slideMasterReportIndex = slideMasterReport - 1;
        Integer slideMasterPage = configuration.getSlideMasterPage();
        if (slideMasterPage == null) {
            slideMasterPage = 1;
        }
        int slideMasterPageIndex = slideMasterPage - 1;
        List<ExporterInputItem> items = this.exporterInput.getItems();
        boolean hasSlideMasterElements = false;
        this.createSlideMaster();
        if (0 <= slideMasterReportIndex && slideMasterReportIndex < items.size()) {
            if (Thread.interrupted()) {
                throw new ExportInterruptedException();
            }
            item = items.get(slideMasterReportIndex);
            this.setCurrentExporterInputItem(item);
            pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                pageRange = this.getPageRange();
                startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int n = endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                if (startPageIndex <= slideMasterPageIndex && slideMasterPageIndex <= endPageIndex) {
                    hasSlideMasterElements = this.exportPageToSlideMaster(pages.get(slideMasterPageIndex), configuration.isBackgroundAsSlideMaster());
                }
            }
        }
        this.closeSlideMaster();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                pageRange = this.getPageRange();
                startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                PageRange[] hideSmPageRanges = null;
                String hideSlideMasterPages = ((PptxReportConfiguration)this.getCurrentItemConfiguration()).getHideSlideMasterPages();
                if (hideSlideMasterPages != null && hideSlideMasterPages.trim().length() > 0) {
                    hideSmPageRanges = PageRange.parse(hideSlideMasterPages);
                }
                this.pageIndex = startPageIndex;
                while (this.pageIndex <= endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new ExportInterruptedException();
                    }
                    JRPrintPage page = pages.get(this.pageIndex);
                    this.createSlide(PageRange.isPageInRanges(this.pageIndex + 1, hideSmPageRanges));
                    ++this.slideIndex;
                    this.exportPage(page, configuration.isBackgroundAsSlideMaster(), hasSlideMasterElements);
                    this.closeSlide();
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.fontHelper.exportFonts();
        fontWriter.close();
        this.presentationHelper.exportFooter(this.jasperPrint);
        this.presentationHelper.close();
        this.presentationRelsHelper.exportFooter();
        this.presentationRelsHelper.close();
        this.ctHelper.exportFooter();
        this.ctHelper.close();
        this.appHelper.exportFooter();
        this.appHelper.close();
        this.coreHelper.exportFooter();
        this.coreHelper.close();
        this.pptxZip.zipEntries(os);
        fontWriter.dispose();
        this.pptxZip.dispose();
    }

    protected boolean exportPageToSlideMaster(JRPrintPage page, boolean isBackgroundAsSlideMaster) throws JRException {
        this.frameIndexStack = new ArrayList<Integer>();
        boolean hasSlideMasterElements = false;
        List<JRPrintElement> elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                JRPrintElement element = elements.get(i);
                this.elementIndex = i;
                if ((!isBackgroundAsSlideMaster || element.getOrigin().getBandTypeValue() != BandTypeEnum.BACKGROUND) && !this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_TO_SLIDE_MASTER, false) || this.filter != null && !this.filter.isToExport(element)) continue;
                this.exportElement(element);
                hasSlideMasterElements = true;
            }
        }
        return hasSlideMasterElements;
    }

    protected void exportPage(JRPrintPage page, boolean isBackgroundAsSlideMaster, boolean hasToSlideMasterElements) throws JRException {
        JRExportProgressMonitor progressMonitor;
        this.frameIndexStack = new ArrayList<Integer>();
        List<JRPrintElement> elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                JRPrintElement element = elements.get(i);
                this.elementIndex = i;
                if (isBackgroundAsSlideMaster && element.getOrigin().getBandTypeValue() == BandTypeEnum.BACKGROUND || hasToSlideMasterElements && this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_TO_SLIDE_MASTER, false) || this.filter != null && !this.filter.isToExport(element)) continue;
                this.exportElement(element);
            }
        }
        if ((progressMonitor = ((PptxReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor()) != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void createSlideMaster() {
        ExportZipEntry slideMasterRelsEntry = this.pptxZip.addSlideMasterRels();
        Writer slideMasterRelsWriter = slideMasterRelsEntry.getWriter();
        this.slideRelsHelper = new PptxSlideRelsHelper(this.jasperReportsContext, slideMasterRelsWriter);
        ExportZipEntry slideMasterEntry = this.pptxZip.addSlideMaster();
        Writer slideMasterWriter = slideMasterEntry.getWriter();
        this.slideHelper = new PptxSlideHelper(this.jasperReportsContext, slideMasterWriter, this.slideRelsHelper);
        this.runHelper = new PptxRunHelper(this.jasperReportsContext, slideMasterWriter, this.fontHelper);
        this.slideHelper.exportHeader(true, false);
        this.slideRelsHelper.exportHeader(true);
    }

    protected void createSlide(boolean hideSlideMaster) {
        this.presentationHelper.exportSlide(this.slideIndex + 1);
        this.ctHelper.exportSlide(this.slideIndex + 1);
        this.presentationRelsHelper.exportSlide(this.slideIndex + 1);
        ExportZipEntry slideRelsEntry = this.pptxZip.addSlideRels(this.slideIndex + 1);
        Writer slideRelsWriter = slideRelsEntry.getWriter();
        this.slideRelsHelper = new PptxSlideRelsHelper(this.jasperReportsContext, slideRelsWriter);
        ExportZipEntry slideEntry = this.pptxZip.addSlide(this.slideIndex + 1);
        Writer slideWriter = slideEntry.getWriter();
        this.slideHelper = new PptxSlideHelper(this.jasperReportsContext, slideWriter, this.slideRelsHelper);
        this.runHelper = new PptxRunHelper(this.jasperReportsContext, slideWriter, this.fontHelper);
        this.slideHelper.exportHeader(false, hideSlideMaster);
        this.slideRelsHelper.exportHeader(false);
    }

    protected void closeSlideMaster() {
        if (this.slideHelper != null) {
            this.slideHelper.exportFooter(true);
            this.slideHelper.close();
            this.slideRelsHelper.exportFooter();
            this.slideRelsHelper.close();
        }
    }

    protected void closeSlide() {
        if (this.slideHelper != null) {
            this.slideHelper.exportFooter(false);
            this.slideHelper.close();
            this.slideRelsHelper.exportFooter();
            this.slideRelsHelper.close();
        }
    }

    protected void exportElement(JRPrintElement element) throws JRException {
        if (element instanceof JRPrintLine) {
            this.exportLine((JRPrintLine)element);
        } else if (element instanceof JRPrintRectangle) {
            this.exportRectangle((JRPrintRectangle)element);
        } else if (element instanceof JRPrintEllipse) {
            this.exportEllipse((JRPrintEllipse)element);
        } else if (element instanceof JRPrintImage) {
            this.exportImage((JRPrintImage)element);
        } else if (element instanceof JRPrintText) {
            this.exportText((JRPrintText)element);
        } else if (element instanceof JRPrintFrame) {
            this.exportFrame((JRPrintFrame)element);
        } else if (element instanceof JRGenericPrintElement) {
            this.exportGenericElement((JRGenericPrintElement)element);
        }
    }

    protected void exportLine(JRPrintLine line) {
        int x = line.getX() + this.getOffsetX();
        int y = line.getY() + this.getOffsetY();
        int height = line.getHeight();
        int width = line.getWidth();
        if (width <= 1 || height <= 1) {
            if (width > 1) {
                height = 0;
            } else {
                width = 0;
            }
        }
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + this.toOOXMLId(line) + "\" name=\"Line\"/>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm" + (line.getDirectionValue() == LineDirectionEnum.BOTTOM_UP ? " flipV=\"1\"" : "") + ">\n");
        this.slideHelper.write("      <a:off x=\"" + LengthUtil.emu(x) + "\" y=\"" + LengthUtil.emu(y) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + LengthUtil.emu(width) + "\" cy=\"" + LengthUtil.emu(height) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"line\"><a:avLst/></a:prstGeom>\n");
        if (line.getModeValue() == ModeEnum.OPAQUE && line.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(line.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        this.exportPen(line.getLinePen());
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr rtlCol=\"0\" anchor=\"ctr\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr algn=\"ctr\"/>\n");
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
    }

    protected void exportPen(JRPen pen) {
        if (pen != null && pen.getLineWidth().floatValue() > 0.0f) {
            this.slideHelper.write("  <a:ln w=\"" + LengthUtil.emu(pen.getLineWidth().floatValue()) + "\"");
            if (LineStyleEnum.DOUBLE.equals(pen.getLineStyleValue())) {
                this.slideHelper.write(" cmpd=\"dbl\"");
            }
            this.slideHelper.write(">\n");
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(pen.getLineColor()) + "\"/></a:solidFill>\n");
            this.slideHelper.write("<a:prstDash val=\"");
            switch (pen.getLineStyleValue()) {
                case DASHED: {
                    this.slideHelper.write("dash");
                    break;
                }
                case DOTTED: {
                    this.slideHelper.write("dot");
                    break;
                }
                default: {
                    this.slideHelper.write("solid");
                }
            }
            this.slideHelper.write("\"/>\n");
            this.slideHelper.write("  </a:ln>\n");
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.exportRectangle(rectangle, rectangle.getLinePen(), rectangle.getRadius());
    }

    protected void exportRectangle(JRPrintElement rectangle, JRPen pen, int radius) {
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + this.toOOXMLId(rectangle) + "\" name=\"Rectangle\"/>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm>\n");
        this.slideHelper.write("      <a:off x=\"" + LengthUtil.emu(rectangle.getX() + this.getOffsetX()) + "\" y=\"" + LengthUtil.emu(rectangle.getY() + this.getOffsetY()) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + LengthUtil.emu(rectangle.getWidth()) + "\" cy=\"" + LengthUtil.emu(rectangle.getHeight()) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"" + (radius == 0 ? "rect" : "roundRect") + "\">");
        if (radius > 0) {
            int size = Math.min(50000, radius * 100000 / Math.min(rectangle.getHeight(), rectangle.getWidth()));
            this.slideHelper.write("<a:avLst><a:gd name=\"adj\" fmla=\"val " + size + "\"/></a:avLst></a:prstGeom>\n");
        } else {
            this.slideHelper.write("<a:avLst/></a:prstGeom>\n");
        }
        if (rectangle.getModeValue() == ModeEnum.OPAQUE && rectangle.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(rectangle.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        this.exportPen(pen);
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr rtlCol=\"0\" anchor=\"ctr\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr algn=\"ctr\"/>\n");
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + this.toOOXMLId(ellipse) + "\" name=\"Ellipse\"/>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm>\n");
        this.slideHelper.write("      <a:off x=\"" + LengthUtil.emu(ellipse.getX() + this.getOffsetX()) + "\" y=\"" + LengthUtil.emu(ellipse.getY() + this.getOffsetY()) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + LengthUtil.emu(ellipse.getWidth()) + "\" cy=\"" + LengthUtil.emu(ellipse.getHeight()) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"ellipse\"><a:avLst/></a:prstGeom>\n");
        if (ellipse.getModeValue() == ModeEnum.OPAQUE && ellipse.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(ellipse.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        this.exportPen(ellipse.getLinePen());
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr rtlCol=\"0\" anchor=\"ctr\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr algn=\"ctr\"/>\n");
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
    }

    public void exportText(JRPrintText text) {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int rotation = 0;
        int leftPadding = text.getLineBox().getLeftPadding();
        int topPadding = text.getLineBox().getTopPadding();
        int rightPadding = text.getLineBox().getRightPadding();
        int bottomPadding = text.getLineBox().getBottomPadding();
        switch (text.getRotationValue()) {
            case LEFT: {
                rotation = -5400000;
                x = text.getX() + this.getOffsetX() - (text.getHeight() - text.getWidth()) / 2;
                y = text.getY() + this.getOffsetY() + (text.getHeight() - text.getWidth()) / 2;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                break;
            }
            case RIGHT: {
                rotation = 5400000;
                x = text.getX() + this.getOffsetX() - (text.getHeight() - text.getWidth()) / 2;
                y = text.getY() + this.getOffsetY() + (text.getHeight() - text.getWidth()) / 2;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                break;
            }
            case UPSIDE_DOWN: {
                rotation = 10800000;
                x = text.getX() + this.getOffsetX();
                y = text.getY() + this.getOffsetY();
                width = text.getWidth();
                height = text.getHeight();
                int tmpPadding = topPadding;
                topPadding = bottomPadding;
                bottomPadding = tmpPadding;
                tmpPadding = leftPadding;
                leftPadding = rightPadding;
                rightPadding = tmpPadding;
                break;
            }
            default: {
                rotation = 0;
                x = text.getX() + this.getOffsetX();
                y = text.getY() + this.getOffsetY();
                width = text.getWidth();
                height = text.getHeight();
            }
        }
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + this.toOOXMLId(text) + "\" name=\"Text\">\n");
        String href = this.getHyperlinkURL(text);
        if (href != null) {
            this.slideHelper.exportHyperlink(href);
        }
        this.slideHelper.write("    </p:cNvPr>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm rot=\"" + rotation + "\">\n");
        this.slideHelper.write("      <a:off x=\"" + LengthUtil.emu(x) + "\" y=\"" + LengthUtil.emu(y) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + LengthUtil.emu(width) + "\" cy=\"" + LengthUtil.emu(height) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom>\n");
        if (text.getModeValue() == ModeEnum.OPAQUE && text.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(text.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        this.exportPen(text.getLineBox());
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr wrap=\"square\" lIns=\"" + LengthUtil.emu(leftPadding) + "\" tIns=\"" + LengthUtil.emu(topPadding) + "\" rIns=\"" + LengthUtil.emu(rightPadding) + "\" bIns=\"" + LengthUtil.emu(bottomPadding) + "\" rtlCol=\"0\" anchor=\"");
        switch (text.getVerticalTextAlign()) {
            case BOTTOM: {
                this.slideHelper.write("b");
                break;
            }
            case MIDDLE: {
                this.slideHelper.write("ctr");
                break;
            }
            default: {
                this.slideHelper.write("t");
            }
        }
        this.slideHelper.write("\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr");
        this.slideHelper.write(" algn=\"");
        switch (text.getHorizontalTextAlign()) {
            case LEFT: {
                this.slideHelper.write("l");
                break;
            }
            case CENTER: {
                this.slideHelper.write("ctr");
                break;
            }
            case RIGHT: {
                this.slideHelper.write("r");
                break;
            }
            case JUSTIFIED: {
                this.slideHelper.write("just");
                break;
            }
            default: {
                this.slideHelper.write("l");
            }
        }
        this.slideHelper.write("\">\n");
        this.slideHelper.write("<a:lnSpc><a:spcPct");
        this.slideHelper.write(" val=\"");
        switch (text.getParagraph().getLineSpacing()) {
            case DOUBLE: {
                this.slideHelper.write("200");
                break;
            }
            case ONE_AND_HALF: {
                this.slideHelper.write("150");
                break;
            }
            default: {
                this.slideHelper.write("100");
            }
        }
        this.slideHelper.write("%\"/></a:lnSpc>\n");
        this.runHelper.exportProps(text, this.getTextLocale(text));
        this.slideHelper.write("</a:pPr>\n");
        if (textLength > 0) {
            PptxFieldTypeEnum fieldTypeEnum = PptxFieldTypeEnum.getByName(JRPropertiesUtil.getOwnProperty(text, PROPERTY_FIELD_TYPE));
            String uuid = null;
            String fieldType = null;
            if (fieldTypeEnum != null) {
                uuid = text.getUUID().toString().toUpperCase();
                fieldType = fieldTypeEnum.getName();
            }
            this.exportStyledText(text.getStyle(), styledText, this.getTextLocale(text), fieldType, uuid);
        }
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
    }

    protected void exportPen(JRLineBox lineBox) {
        this.exportPen(this.getPptxPen(lineBox));
    }

    protected void exportStyledText(JRStyle style, JRStyledText styledText, Locale locale, String fieldType, String uuid) {
        StyledTextWriteContext context = new StyledTextWriteContext();
        String allText = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            String runText = allText.substring(iterator.getIndex(), runLimit);
            context.next(attributes, runText);
            if (context.listItemStartsWithNewLine() && !context.isListItemStart() && (context.isListItemEnd() || context.isListStart() || context.isListEnd())) {
                runText = runText.substring(1);
            }
            if (runText.length() > 0) {
                String bulletText = JRStyledTextUtil.getIndentedBulletText(context);
                String text = (bulletText == null ? "" : bulletText) + runText;
                if (fieldType != null) {
                    this.runHelper.export(style, attributes, text, locale, this.invalidCharReplacement, fieldType, uuid);
                } else {
                    this.runHelper.export(style, attributes, text, locale, this.invalidCharReplacement);
                }
            }
            iterator.setIndex(runLimit);
        }
    }

    public void exportImage(JRPrintImage image) throws JRException {
        int availableImageWidth;
        boolean hasPadding;
        int leftPadding = image.getLineBox().getLeftPadding();
        int topPadding = image.getLineBox().getTopPadding();
        int rightPadding = image.getLineBox().getRightPadding();
        int bottomPadding = image.getLineBox().getBottomPadding();
        JRPen pen = this.getPptxPen(image.getLineBox());
        boolean bl = hasPadding = leftPadding + topPadding + rightPadding + bottomPadding > 0;
        if (hasPadding) {
            this.exportRectangle(image, pen, 0);
        }
        availableImageWidth = (availableImageWidth = image.getWidth() - leftPadding - rightPadding) < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        Renderable renderer = image.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            InternalImageProcessorResult imageProcessorResult;
            block33: {
                InternalImageProcessor imageProcessor = new InternalImageProcessor(image, availableImageWidth, availableImageHeight);
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, image.getOnErrorTypeValue());
                    if (onErrorRenderer == null) break block33;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                int renderWidth = availableImageWidth;
                int renderHeight = availableImageHeight;
                int xoffset = 0;
                int yoffset = 0;
                double cropTop = 0.0;
                double cropLeft = 0.0;
                double cropBottom = 0.0;
                double cropRight = 0.0;
                int angle = 0;
                block1 : switch (image.getScaleImageValue()) {
                    case FILL_FRAME: {
                        switch (ImageUtil.getRotation(image.getRotation(), imageProcessorResult.exifOrientation)) {
                            case LEFT: {
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                angle = -90;
                                break block1;
                            }
                            case RIGHT: {
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                angle = 90;
                                break block1;
                            }
                            case UPSIDE_DOWN: {
                                renderWidth = availableImageWidth;
                                renderHeight = availableImageHeight;
                                angle = 180;
                                break block1;
                            }
                        }
                        renderWidth = availableImageWidth;
                        renderHeight = availableImageHeight;
                        angle = 0;
                        break;
                    }
                    case CLIP: {
                        double normalWidth = availableImageWidth;
                        double normalHeight = availableImageHeight;
                        Dimension2D dimension = imageProcessorResult.dimension;
                        if (dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                        switch (ImageUtil.getRotation(image.getRotation(), imageProcessorResult.exifOrientation)) {
                            case LEFT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                angle = -90;
                                break;
                            }
                            case RIGHT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                angle = 90;
                                break;
                            }
                            case UPSIDE_DOWN: {
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                angle = 180;
                                break;
                            }
                            default: {
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                angle = 0;
                            }
                        }
                        ImageUtil.Insets exifCrop = ImageUtil.getExifCrop(image, imageProcessorResult.exifOrientation, cropTop, cropLeft, cropBottom, cropRight);
                        cropLeft = exifCrop.left;
                        cropRight = exifCrop.right;
                        cropTop = exifCrop.top;
                        cropBottom = exifCrop.bottom;
                        break;
                    }
                    default: {
                        double normalWidth = availableImageWidth;
                        double normalHeight = availableImageHeight;
                        Dimension2D dimension = imageProcessorResult.dimension;
                        if (dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                        double ratioX = 1.0;
                        double ratioY = 1.0;
                        double imageWidth = availableImageWidth;
                        double imageHeight = availableImageHeight;
                        switch (ImageUtil.getRotation(image.getRotation(), imageProcessorResult.exifOrientation)) {
                            case LEFT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                ratioX = (double)availableImageWidth / normalHeight;
                                ratioY = (double)availableImageHeight / normalWidth;
                                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                                imageWidth = (int)(normalHeight * ratioX);
                                imageHeight = (int)(normalWidth * ratioY);
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                angle = -90;
                                break;
                            }
                            case RIGHT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                ratioX = (double)availableImageWidth / normalHeight;
                                ratioY = (double)availableImageHeight / normalWidth;
                                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                                imageWidth = (int)(normalHeight * ratioX);
                                imageHeight = (int)(normalWidth * ratioY);
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                angle = 90;
                                break;
                            }
                            case UPSIDE_DOWN: {
                                renderWidth = availableImageWidth;
                                renderHeight = availableImageHeight;
                                ratioX = (double)availableImageWidth / normalWidth;
                                ratioY = (double)availableImageHeight / normalHeight;
                                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                                imageWidth = (int)(normalWidth * ratioX);
                                imageHeight = (int)(normalHeight * ratioY);
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                angle = 180;
                                break;
                            }
                            default: {
                                renderWidth = availableImageWidth;
                                renderHeight = availableImageHeight;
                                ratioX = (double)availableImageWidth / normalWidth;
                                ratioY = (double)availableImageHeight / normalHeight;
                                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                                imageWidth = (int)(normalWidth * ratioX);
                                imageHeight = (int)(normalHeight * ratioY);
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                angle = 0;
                            }
                        }
                        ImageUtil.Insets exifCrop = ImageUtil.getExifCrop(image, imageProcessorResult.exifOrientation, cropTop, cropLeft, cropBottom, cropRight);
                        cropLeft = exifCrop.left;
                        cropRight = exifCrop.right;
                        cropTop = exifCrop.top;
                        cropBottom = exifCrop.bottom;
                    }
                }
                this.slideRelsHelper.exportImage(imageProcessorResult.imagePath);
                this.slideHelper.write("<p:pic>\n");
                this.slideHelper.write("  <p:nvPicPr>\n");
                this.slideHelper.write("    <p:cNvPr id=\"" + this.toOOXMLId(image) + "\" name=\"Picture\">\n");
                String href = this.getHyperlinkURL(image);
                if (href != null) {
                    this.slideHelper.exportHyperlink(href);
                }
                this.slideHelper.write("    </p:cNvPr>\n");
                this.slideHelper.write("    <p:cNvPicPr>\n");
                this.slideHelper.write("      <a:picLocks noChangeAspect=\"1\"/>\n");
                this.slideHelper.write("    </p:cNvPicPr>\n");
                this.slideHelper.write("    <p:nvPr/>\n");
                this.slideHelper.write("  </p:nvPicPr>\n");
                this.slideHelper.write("<p:blipFill>\n");
                this.slideHelper.write("<a:blip r:embed=\"" + imageProcessorResult.imagePath + "\"/>");
                this.slideHelper.write("<a:srcRect/>");
                this.slideHelper.write("<a:stretch><a:fillRect");
                this.slideHelper.write(" l=\"" + (int)(100000.0 * cropLeft) + "\"");
                this.slideHelper.write(" t=\"" + (int)(100000.0 * cropTop) + "\"");
                this.slideHelper.write(" r=\"" + (int)(100000.0 * cropRight) + "\"");
                this.slideHelper.write(" b=\"" + (int)(100000.0 * cropBottom) + "\"");
                this.slideHelper.write("/></a:stretch>\n");
                this.slideHelper.write("</p:blipFill>\n");
                this.slideHelper.write("  <p:spPr>\n");
                this.slideHelper.write("    <a:xfrm rot=\"" + 60000 * angle + "\">\n");
                this.slideHelper.write("      <a:off x=\"" + LengthUtil.emu(image.getX() + this.getOffsetX() + leftPadding + xoffset) + "\" y=\"" + LengthUtil.emu(image.getY() + this.getOffsetY() + topPadding + yoffset) + "\"/>\n");
                this.slideHelper.write("      <a:ext cx=\"" + LengthUtil.emu(renderWidth) + "\" cy=\"" + LengthUtil.emu(renderHeight) + "\"/>\n");
                this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom>\n");
                if (image.getModeValue() == ModeEnum.OPAQUE && image.getBackcolor() != null) {
                    this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(image.getBackcolor()) + "\"/></a:solidFill>\n");
                }
                if (!hasPadding) {
                    this.exportPen(image.getLineBox());
                }
                this.slideHelper.write("  </p:spPr>\n");
                this.slideHelper.write("  </p:pic>\n");
            }
        }
    }

    protected JRPrintElementIndex getElementIndex() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.frameIndexStack.size(); ++i) {
            Integer frameIndex = this.frameIndexStack.get(i);
            sb.append(frameIndex).append("_");
        }
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, sb.append(this.elementIndex).toString());
        return imageIndex;
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("export.common.invalid.image.name", imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    public void exportFrame(JRPrintFrame frame) throws JRException {
        this.slideHelper.write("<p:sp>\n");
        this.slideHelper.write("  <p:nvSpPr>\n");
        this.slideHelper.write("    <p:cNvPr id=\"" + this.toOOXMLId(frame) + "\" name=\"Frame\"/>\n");
        this.slideHelper.write("    <p:cNvSpPr>\n");
        this.slideHelper.write("      <a:spLocks noGrp=\"1\"/>\n");
        this.slideHelper.write("    </p:cNvSpPr>\n");
        this.slideHelper.write("    <p:nvPr/>\n");
        this.slideHelper.write("  </p:nvSpPr>\n");
        this.slideHelper.write("  <p:spPr>\n");
        this.slideHelper.write("    <a:xfrm>\n");
        this.slideHelper.write("      <a:off x=\"" + LengthUtil.emu(frame.getX() + this.getOffsetX()) + "\" y=\"" + LengthUtil.emu(frame.getY() + this.getOffsetY()) + "\"/>\n");
        this.slideHelper.write("      <a:ext cx=\"" + LengthUtil.emu(frame.getWidth()) + "\" cy=\"" + LengthUtil.emu(frame.getHeight()) + "\"/>\n");
        this.slideHelper.write("    </a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom>\n");
        if (frame.getModeValue() == ModeEnum.OPAQUE && frame.getBackcolor() != null) {
            this.slideHelper.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa(frame.getBackcolor()) + "\"/></a:solidFill>\n");
        }
        this.exportPen(frame.getLineBox());
        this.slideHelper.write("  </p:spPr>\n");
        this.slideHelper.write("  <p:txBody>\n");
        this.slideHelper.write("    <a:bodyPr rtlCol=\"0\" anchor=\"ctr\"/>\n");
        this.slideHelper.write("    <a:lstStyle/>\n");
        this.slideHelper.write("    <a:p>\n");
        this.slideHelper.write("<a:pPr algn=\"ctr\"/>\n");
        this.slideHelper.write("    </a:p>\n");
        this.slideHelper.write("  </p:txBody>\n");
        this.slideHelper.write("</p:sp>\n");
        this.setFrameElementsOffset(frame, false);
        this.frameIndexStack.add(this.elementIndex);
        List<JRPrintElement> elements = frame.getElements();
        if (elements != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                JRPrintElement element = elements.get(i);
                this.elementIndex = i;
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                this.exportElement(element);
            }
        }
        this.frameIndexStack.remove(this.frameIndexStack.size() - 1);
        this.restoreElementOffsets();
    }

    protected void exportGenericElement(JRGenericPrintElement element) {
        GenericElementPptxHandler handler = (GenericElementPptxHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), PPTX_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JRPptxExporterContext)this.exporterContext, element);
        } else if (log.isDebugEnabled()) {
            log.debug("No PPTX generic element handler for " + element.getGenericType());
        }
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block12: {
            JRHyperlinkProducer customHandler;
            block13: {
                href = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.pptx.ignore.hyperlink", link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = ((PptxReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
                }
                if (ignoreHyperlink.booleanValue()) break block12;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block13;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            try {
                                href = link.getHyperlinkReference().replaceAll("\\s", URLEncoder.encode(" ", "UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                href = link.getHyperlinkReference();
                            }
                            break;
                        }
                        break block12;
                    }
                    case LOCAL_ANCHOR: {
                        break;
                    }
                    case LOCAL_PAGE: {
                        break;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block12;
                    }
                    case REMOTE_PAGE: {
                        break;
                    }
                }
                break block12;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        return this.styledTextUtil.getProcessedStyledText(textElement, setBackcolor ? this.allSelector : this.noBackcolorSelector, this.getExporterKey());
    }

    @Override
    public String getExporterKey() {
        return PPTX_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return PPTX_EXPORTER_PROPERTIES_PREFIX;
    }

    protected String toOOXMLId(JRPrintElement element) {
        int hashCode = element.hashCode();
        return Integer.toString(hashCode & Integer.MAX_VALUE);
    }

    protected JRPen getPptxPen(JRLineBox box) {
        JRBasePen pen = null;
        Float lineWidth = box.getPen().getLineWidth();
        if (lineWidth.floatValue() == 0.0f) {
            if (((JRBasePen)((Object)box.getTopPen())).isIdentical(box.getLeftPen()) && ((JRBasePen)((Object)box.getTopPen())).isIdentical(box.getBottomPen()) && ((JRBasePen)((Object)box.getTopPen())).isIdentical(box.getRightPen()) && box.getTopPen().getLineWidth().floatValue() > 0.0f) {
                pen = new JRBasePen(box);
                pen.setLineWidth(box.getTopPen().getLineWidth());
                pen.setLineColor(box.getTopPen().getLineColor());
                pen.setLineStyle(box.getTopPen().getLineStyleValue());
            }
        } else {
            pen = new JRBasePen(box);
            pen.setLineWidth(lineWidth);
            pen.setLineColor(box.getPen().getLineColor());
            pen.setLineStyle(box.getPen().getLineStyleValue());
        }
        return pen;
    }

    private class InternalImageProcessorResult {
        protected final String imagePath;
        protected final Dimension2D dimension;
        protected final ExifOrientationEnum exifOrientation;

        protected InternalImageProcessorResult(String imagePath, Dimension2D dimension, ExifOrientationEnum exifOrientation) {
            this.imagePath = imagePath;
            this.dimension = dimension;
            this.exifOrientation = exifOrientation;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintElement imageElement;
        private final RenderersCache imageRenderersCache;
        private final boolean needDimension;
        private final int availableImageWidth;
        private final int availableImageHeight;

        protected InternalImageProcessor(JRPrintImage imageElement, int availableImageWidth, int availableImageHeight) {
            this.imageElement = imageElement;
            this.imageRenderersCache = imageElement.isUsingCache() ? JRPptxExporter.this.renderersCache : new RenderersCache(JRPptxExporter.this.getJasperReportsContext());
            boolean bl = this.needDimension = imageElement.getScaleImageValue() != ScaleImageEnum.FILL_FRAME;
            if (imageElement.getRotation() == RotationEnum.LEFT || imageElement.getRotation() == RotationEnum.RIGHT) {
                this.availableImageWidth = availableImageHeight;
                this.availableImageHeight = availableImageWidth;
            } else {
                this.availableImageWidth = availableImageWidth;
                this.availableImageHeight = availableImageHeight;
            }
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException {
            if (renderer instanceof ResourceRenderer) {
                renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            Dimension2D dimension = null;
            if (this.needDimension) {
                DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(JRPptxExporter.this.jasperReportsContext);
            }
            ExifOrientationEnum exifOrientation = ExifOrientationEnum.NORMAL;
            String imagePath = null;
            if (renderer instanceof DataRenderable && JRPptxExporter.this.rendererToImagePathMap.containsKey(renderer.getId())) {
                Pair<String, ExifOrientationEnum> imagePair = JRPptxExporter.this.rendererToImagePathMap.get(renderer.getId());
                imagePath = imagePair.first();
                exifOrientation = imagePair.second();
            } else {
                JRPrintElementIndex imageIndex = JRPptxExporter.this.getElementIndex();
                DataRenderable imageRenderer = JRPptxExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null);
                byte[] imageData = imageRenderer.getData(JRPptxExporter.this.jasperReportsContext);
                exifOrientation = ImageUtil.getExifOrientation(imageData);
                String fileExtension = JRTypeSniffer.getImageTypeValue(imageData).getFileExtension();
                String imageName = JRPptxExporter.IMAGE_NAME_PREFIX + imageIndex.toString() + (fileExtension == null ? "" : "." + fileExtension);
                JRPptxExporter.this.pptxZip.addEntry(new FileBufferedZipEntry("ppt/media/" + imageName, imageData));
                imagePath = imageName;
                if (imageRenderer == renderer) {
                    JRPptxExporter.this.rendererToImagePathMap.put(renderer.getId(), new Pair<String, ExifOrientationEnum>(imagePath, exifOrientation));
                }
            }
            return new InternalImageProcessorResult(imagePath, dimension, exifOrientation);
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRPptxExporterContext {
        protected ExporterContext() {
            super(JRPptxExporter.this);
        }
    }
}

