/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.member.evaluation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.json.expression.EvaluationContext;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.json.expression.member.evaluation.MemberExpressionEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMemberExpressionEvaluator
implements MemberExpressionEvaluator {
    private static final Log log = LogFactory.getLog(AbstractMemberExpressionEvaluator.class);
    private EvaluationContext evaluationContext;

    public AbstractMemberExpressionEvaluator(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public abstract MemberExpression getMemberExpression();

    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    protected boolean applyFilter(JRJsonNode node) {
        if (log.isDebugEnabled()) {
            log.debug("apply filter - " + this.getMemberExpression().getFilterExpression() + " - to: " + node);
        }
        if (this.getMemberExpression().getFilterExpression() != null) {
            boolean evalResult = this.getMemberExpression().getFilterExpression().evaluate(node, this.evaluationContext.getFilterExpressionEvaluatorVisitor());
            if (log.isDebugEnabled()) {
                log.debug("filter returns " + evalResult);
            }
            return evalResult;
        }
        if (log.isDebugEnabled()) {
            log.debug("no filter expression, returns true");
        }
        return true;
    }

    protected List<JRJsonNode> filterArrayNode(JRJsonNode parent, ArrayNode childArray) {
        return this.filterArrayNode(parent, childArray, null);
    }

    protected List<JRJsonNode> filterArrayNode(JRJsonNode parent, ArrayNode childArray, String deeperKey) {
        return this.filterArrayNode(parent, childArray, deeperKey, false);
    }

    protected List<JRJsonNode> filterArrayNode(JRJsonNode parent, ArrayNode childArray, String deeperKey, boolean keepArrayContainment) {
        if (log.isDebugEnabled()) {
            log.debug("filtering array: " + childArray + "; deeperKey: " + deeperKey + "; keepArrayContainment: " + keepArrayContainment);
        }
        ArrayList<JRJsonNode> result = new ArrayList<JRJsonNode>();
        ArrayNode container = null;
        if (keepArrayContainment) {
            container = this.evaluationContext.getObjectMapper().createArrayNode();
        }
        for (JsonNode current : childArray) {
            if (deeperKey != null) {
                JRJsonNode currentParent;
                JRJsonNode currentChild;
                JsonNode deeperNode = current.get(deeperKey);
                if (deeperNode == null || !this.applyFilter(currentChild = (currentParent = parent.createChild(current)).createChild(deeperNode))) continue;
                if (keepArrayContainment) {
                    container.add(deeperNode);
                    continue;
                }
                result.add(currentChild);
                continue;
            }
            JRJsonNode currentChild = parent.createChild(current);
            if (!this.applyFilter(currentChild)) continue;
            if (keepArrayContainment) {
                container.add(current);
                continue;
            }
            result.add(currentChild);
        }
        if (keepArrayContainment && container.size() > 0) {
            result.add(parent.createChild(container));
        }
        return result;
    }

    protected void addChildrenToStack(JRJsonNode stackNode, Deque<JRJsonNode> stack) {
        block3: {
            JsonNode stackDataNode;
            block2: {
                stackDataNode = stackNode.getDataNode();
                if (!stackDataNode.isObject()) break block2;
                Iterator<Map.Entry<String, JsonNode>> it = stackDataNode.fields();
                while (it.hasNext()) {
                    JsonNode current = it.next().getValue();
                    stack.addLast(stackNode.createChild(current));
                }
                break block3;
            }
            if (!stackDataNode.isArray()) break block3;
            for (JsonNode deeper : stackDataNode) {
                stack.addLast(stackNode.createChild(deeper));
            }
        }
    }
}

