/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.member.evaluation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.json.JsonNodeContainer;
import net.sf.jasperreports.engine.json.expression.EvaluationContext;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.json.expression.member.ObjectKeyExpression;
import net.sf.jasperreports.engine.json.expression.member.evaluation.AbstractMemberExpressionEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectKeyExpressionEvaluator
extends AbstractMemberExpressionEvaluator {
    private static final Log log = LogFactory.getLog(ObjectKeyExpressionEvaluator.class);
    private ObjectKeyExpression expression;
    private boolean isCalledFromFilter;
    private Pattern fieldNamePattern;

    public ObjectKeyExpressionEvaluator(EvaluationContext evaluationContext, ObjectKeyExpression expression) {
        this(evaluationContext, expression, false);
    }

    public ObjectKeyExpressionEvaluator(EvaluationContext evaluationContext, ObjectKeyExpression expression, boolean isCalledFromFilter) {
        super(evaluationContext);
        this.expression = expression;
        this.isCalledFromFilter = isCalledFromFilter;
        if (!expression.isWildcard() && expression.isComplex()) {
            this.fieldNamePattern = Pattern.compile(expression.getObjectKey());
        }
    }

    @Override
    public JsonNodeContainer evaluate(JsonNodeContainer contextNode) {
        List<JRJsonNode> nodes = contextNode.getNodes();
        if (log.isDebugEnabled()) {
            log.debug("---> evaluating expression [" + this.expression + "] on a node with (size: " + contextNode.getSize() + ", cSize: " + contextNode.getContainerSize() + ")");
        }
        JsonNodeContainer result = new JsonNodeContainer();
        for (JRJsonNode node : nodes) {
            List<JRJsonNode> evaluatedNodes = this.singleEval(node);
            if (evaluatedNodes.size() <= 0) continue;
            result.addNodes(evaluatedNodes);
        }
        if (result.getSize() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public MemberExpression getMemberExpression() {
        return this.expression;
    }

    private List<JRJsonNode> singleEval(JRJsonNode jrJsonNode) {
        switch (this.expression.getDirection()) {
            case DOWN: {
                return this.goDown(jrJsonNode);
            }
            case ANYWHERE_DOWN: {
                return this.goAnywhereDown(jrJsonNode);
            }
        }
        return null;
    }

    private List<JRJsonNode> goDown(JRJsonNode jrJsonNode) {
        if (log.isDebugEnabled()) {
            log.debug("going " + (Object)((Object)MemberExpression.DIRECTION.DOWN) + " by " + (this.expression.isWildcard() ? "wildcard" : "key: [" + this.expression.getObjectKey() + "]") + " on " + jrJsonNode.getDataNode());
        }
        List<JRJsonNode> result = new ArrayList<JRJsonNode>();
        JsonNode dataNode = jrJsonNode.getDataNode();
        if (dataNode.isObject()) {
            if (this.expression.isWildcard()) {
                ArrayNode container = this.getEvaluationContext().getObjectMapper().createArrayNode();
                Iterator<Map.Entry<String, JsonNode>> it = dataNode.fields();
                while (it.hasNext()) {
                    JsonNode current = it.next().getValue();
                    if (!this.applyFilter(jrJsonNode.createChild(current))) continue;
                    container.add(current);
                }
                if (container.size() > 0) {
                    result.add(jrJsonNode.createChild(container));
                }
            } else {
                JRJsonNode deeperNode = this.goDeeperIntoObjectNode(jrJsonNode, this.isCalledFromFilter);
                if (deeperNode != null) {
                    result.add(deeperNode);
                }
            }
        } else if (dataNode.isArray()) {
            result = this.expression.isWildcard() ? this.filterArrayNode(jrJsonNode, (ArrayNode)dataNode, null, this.isCalledFromFilter) : this.filterArrayNode(jrJsonNode, (ArrayNode)dataNode, this.expression.getObjectKey(), this.isCalledFromFilter);
        }
        return result;
    }

    private List<JRJsonNode> goAnywhereDown(JRJsonNode jrJsonNode) {
        if (log.isDebugEnabled()) {
            log.debug("going " + (Object)((Object)MemberExpression.DIRECTION.ANYWHERE_DOWN) + " by " + (this.expression.isWildcard() ? "wildcard" : "key: [" + this.expression.getObjectKey() + "]") + " on " + jrJsonNode.getDataNode());
        }
        ArrayList<JRJsonNode> result = new ArrayList<JRJsonNode>();
        ArrayDeque<JRJsonNode> stack = new ArrayDeque<JRJsonNode>();
        JsonNode initialDataNode = jrJsonNode.getDataNode();
        if (log.isDebugEnabled()) {
            log.debug("initial stack population with: " + initialDataNode);
        }
        if (initialDataNode.isArray()) {
            for (JsonNode deeper : initialDataNode) {
                stack.addLast(jrJsonNode.createChild(deeper));
            }
        } else {
            stack.push(jrJsonNode);
        }
        while (!stack.isEmpty()) {
            JRJsonNode stackNode = (JRJsonNode)stack.pop();
            JsonNode stackDataNode = stackNode.getDataNode();
            this.addChildrenToStack(stackNode, stack);
            if (log.isDebugEnabled()) {
                log.debug("processing stack element: " + stackDataNode);
            }
            if (stackDataNode.isObject()) {
                if (log.isDebugEnabled()) {
                    log.debug("stack element is object; wildcard: " + this.expression.isWildcard());
                }
                if (this.expression.isWildcard()) {
                    if (!this.applyFilter(stackNode)) continue;
                    result.add(stackNode);
                    continue;
                }
                JRJsonNode deeperNode = this.goDeeperIntoObjectNode(stackNode, false);
                if (deeperNode == null) continue;
                result.add(deeperNode);
                continue;
            }
            if (!stackDataNode.isValueNode() && !stackDataNode.isArray()) continue;
            if (log.isDebugEnabled()) {
                log.debug("stack element is " + (stackDataNode.isValueNode() ? "value node" : "array") + "; wildcard: " + this.expression.isWildcard());
            }
            if (!this.expression.isWildcard() || !this.applyFilter(stackNode)) continue;
            result.add(stackNode);
        }
        return result;
    }

    private JRJsonNode goDeeperIntoObjectNode(JRJsonNode jrJsonNode, boolean keepMissingNode) {
        ObjectNode dataNode = (ObjectNode)jrJsonNode.getDataNode();
        ArrayNode container = this.getEvaluationContext().getObjectMapper().createArrayNode();
        if (this.expression.isComplex()) {
            Iterator<String> fieldNamesIterator = dataNode.fieldNames();
            while (fieldNamesIterator.hasNext()) {
                JRJsonNode child;
                JsonNode deeperNode;
                String fieldName = fieldNamesIterator.next();
                Matcher fieldNameMatcher = this.fieldNamePattern.matcher(fieldName);
                if (!fieldNameMatcher.matches() || !(deeperNode = dataNode.path(fieldName)).isObject() && !deeperNode.isValueNode() && !deeperNode.isArray() || !this.applyFilter(child = jrJsonNode.createChild(deeperNode))) continue;
                container.add(deeperNode);
            }
        } else {
            JRJsonNode child;
            JsonNode deeperNode = dataNode.path(this.expression.getObjectKey());
            if ((deeperNode.isObject() || deeperNode.isValueNode() || deeperNode.isArray()) && this.applyFilter(child = jrJsonNode.createChild(deeperNode))) {
                container.add(deeperNode);
            }
        }
        if (container.size() > 1) {
            return jrJsonNode.createChild(container);
        }
        if (container.size() == 1) {
            return jrJsonNode.createChild(container.get(0));
        }
        if (keepMissingNode) {
            return jrJsonNode.createChild(MissingNode.getInstance());
        }
        return null;
    }
}

