/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Function;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.CustomControl;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.ThreadLocalStack;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.ResourceBundleResource;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JRResourcesUtil {
    private static final Log log = LogFactory.getLog(JRResourcesUtil.class);
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private static ClassLoader globalClassLoader;
    private static ThreadLocalStack localClassLoaderStack;

    public static URL createURL(String spec, URLStreamHandlerFactory urlHandlerFactory) {
        URL url;
        URLStreamHandler handler = JRResourcesUtil.getURLHandler(spec, urlHandlerFactory);
        try {
            url = handler == null ? new URL(spec) : new URL(null, spec, handler);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url;
    }

    public static URLStreamHandler getURLHandler(String spec, URLStreamHandlerFactory urlHandlerFact) {
        String protocol;
        URLStreamHandlerFactory urlHandlerFactory = urlHandlerFact;
        URLStreamHandler handler = null;
        if (urlHandlerFactory != null && (protocol = JRResourcesUtil.getURLProtocol(spec)) != null) {
            handler = urlHandlerFactory.createURLStreamHandler(protocol);
        }
        return handler;
    }

    private static String getURLProtocol(String urlSpec) {
        String proto;
        String protocol = null;
        String spec = urlSpec.trim();
        int colon = spec.indexOf(58);
        if (colon > 0 && JRResourcesUtil.protocolValid(proto = spec.substring(0, colon))) {
            protocol = proto;
        }
        return protocol;
    }

    private static boolean protocolValid(String protocol) {
        int length = protocol.length();
        if (length < 1) {
            return false;
        }
        if (!Character.isLetter(protocol.charAt(0))) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            char c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.') continue;
            return false;
        }
        return true;
    }

    public static File resolveFile(String location, FileResolver fileRes) {
        FileResolver fileResolver = fileRes;
        if (fileResolver != null) {
            return fileResolver.resolveFile(location);
        }
        return JRResourcesUtil.resolveFile(null, location);
    }

    public static File resolveFile(RepositoryContext context, String location) {
        return JRResourcesUtil.resolveFile(context, location, JRResourcesUtil::defaultLocateFile);
    }

    public static File resolveFile(RepositoryContext context, String location, Function<String, File> rootLocator) {
        File file = JRResourcesUtil.locateFile(context == null ? null : context.getResourceContext(), location, rootLocator);
        if (file != null && file.isFile()) {
            return file;
        }
        return null;
    }

    protected static File defaultLocateFile(String location) {
        File file = new File(location);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    protected static File locateFile(RepositoryResourceContext resourceContext, String location, Function<String, File> rootLocator) {
        File file = rootLocator.apply(location);
        if (file != null) {
            return file;
        }
        if (resourceContext != null) {
            for (RepositoryResourceContext context = resourceContext; context != null; context = context.getFallbackContext()) {
                File contextDir = JRResourcesUtil.locateContextDirectory(context, rootLocator);
                if (contextDir == null || !(file = new File(contextDir, location)).exists()) continue;
                if (log.isDebugEnabled()) {
                    log.debug("resolved location " + location + " relative to the context " + contextDir);
                }
                return file;
            }
        }
        return null;
    }

    protected static File locateContextDirectory(RepositoryResourceContext resourceContext, Function<String, File> rootLocator) {
        block4: {
            String contextLocation = resourceContext.getContextLocation();
            if (contextLocation != null) {
                try {
                    Paths.get(contextLocation, new String[0]);
                    File contextDir = rootLocator.apply(contextLocation);
                    if (contextDir != null && contextDir.isDirectory()) {
                        return contextDir;
                    }
                }
                catch (InvalidPathException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("location \"" + contextLocation + "\" is not a file path: " + e);
                }
            }
        }
        return null;
    }

    public static ClassLoader getClassLoader(ClassLoader clsLoader) {
        ClassLoader classLoader = clsLoader;
        if (classLoader == null && (classLoader = JRResourcesUtil.getThreadClassLoader()) == null) {
            classLoader = globalClassLoader;
        }
        return classLoader;
    }

    public static ClassLoader getGlobalClassLoader() {
        return globalClassLoader;
    }

    public static ClassLoader getThreadClassLoader() {
        return (ClassLoader)localClassLoaderStack.top();
    }

    public static void setThreadClassLoader(ClassLoader classLoader) {
        localClassLoaderStack.push(classLoader);
    }

    public static void resetClassLoader() {
        localClassLoaderStack.pop();
    }

    public static void setGlobalClassLoader(ClassLoader classLoader) {
        globalClassLoader = classLoader;
    }

    public static URL findClassLoaderResource(String location, ClassLoader clsLoader, Class<?> clazz) {
        ClassLoader classLoader = JRResourcesUtil.getClassLoader(clsLoader);
        URL url = null;
        if (classLoader != null) {
            url = classLoader.getResource(location);
        }
        if (url == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                url = classLoader.getResource(location);
            }
            if (url == null) {
                classLoader = clazz.getClassLoader();
                url = classLoader == null ? clazz.getResource("/" + location) : classLoader.getResource(location);
            }
        }
        return url;
    }

    public static URL findClassLoaderResource(String location, ClassLoader clsLoader) {
        ClassLoader classLoader = JRResourcesUtil.getClassLoader(clsLoader);
        URL url = null;
        if (classLoader != null) {
            url = classLoader.getResource(location);
        }
        if (url == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                url = classLoader.getResource(location);
            }
            if (url == null) {
                classLoader = JRLoader.class.getClassLoader();
                url = classLoader == null ? JRLoader.class.getResource("/" + location) : classLoader.getResource(location);
            }
        }
        return url;
    }

    public static ResourceBundle loadResourceBundle(JasperReportsContext jasperReportsContext, String baseName, Locale locale) {
        return JRResourcesUtil.loadResourceBundle(SimpleRepositoryContext.of(jasperReportsContext), baseName, locale);
    }

    public static ResourceBundle loadResourceBundle(RepositoryContext repositoryContext, String baseName, Locale locale) {
        ResourceBundle resourceBundle = null;
        MissingResourceException ex = null;
        try {
            resourceBundle = JRResourcesUtil.loadResourceBundle(baseName, locale, null);
        }
        catch (MissingResourceException e) {
            ex = e;
        }
        if (resourceBundle == null) {
            CustomControl control = new CustomControl();
            List<Locale> locales = control.getCandidateLocales(baseName, locale);
            for (Locale lc : locales) {
                String suffix = lc.toString();
                suffix = (suffix.trim().length() > 0 ? "_" : "") + suffix;
                ResourceBundleResource resourceBundleResource = null;
                try {
                    resourceBundleResource = RepositoryUtil.getInstance(repositoryContext).getResourceFromLocation(baseName + suffix + PROPERTIES_FILE_EXTENSION, ResourceBundleResource.class);
                }
                catch (JRException jRException) {
                    // empty catch block
                }
                if (resourceBundleResource == null) continue;
                resourceBundle = resourceBundleResource.getResourceBundle();
                break;
            }
        }
        if (resourceBundle == null) {
            throw ex;
        }
        return resourceBundle;
    }

    public static ResourceBundle loadResourceBundle(String baseName, Locale locale) {
        return JRResourcesUtil.loadResourceBundle(baseName, locale, null);
    }

    public static ResourceBundle loadResourceBundle(String baseName, Locale locale, ClassLoader clsLoader) {
        ResourceBundle resourceBundle = null;
        ClassLoader classLoader = JRResourcesUtil.getClassLoader(clsLoader);
        if (classLoader != null) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (resourceBundle == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            classLoader = JRClassLoader.class.getClassLoader();
            resourceBundle = classLoader == null ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName, locale, classLoader);
        }
        return resourceBundle;
    }

    private JRResourcesUtil() {
    }

    static {
        localClassLoaderStack = new ThreadLocalStack();
    }
}

