/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.SimpleDataRenderer;
import net.sf.jasperreports.renderers.WrappingRenderToImageDataRenderer;
import net.sf.jasperreports.renderers.util.SvgDataSniffer;
import net.sf.jasperreports.renderers.util.XmlDataSniffer;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RendererUtil {
    private static final Log log = LogFactory.getLog(RendererUtil.class);
    public static final String EXCEPTION_MESSAGE_KEY_IMAGE_ERROR = "engine.renderable.util.image.error";
    public static final String EXCEPTION_MESSAGE_KEY_RENDERABLE_MUST_IMPLEMENT_INTERFACE = "engine.renderable.must.implement.interface";
    public static final Renderable NO_IMAGE_RENDERER = ResourceRenderer.getInstance("net/sf/jasperreports/engine/images/image-16.png", false);
    public static final String SVG_MIME_TYPE = "image/svg+xml";
    public static final String SVG_FILE_EXTENSION = "svg";
    protected static final String SVG_ROOT_ELEMENT = "svg";
    protected static final String SVG_ROOT_ELEMENT_QNAME_SUFFIX = ":svg";
    private final RepositoryContext context;
    private SvgDataSniffer svgDataSniffer;

    private RendererUtil(RepositoryContext context) {
        this.context = context;
    }

    public static RendererUtil getInstance(JasperReportsContext jasperReportsContext) {
        return RendererUtil.getInstance(SimpleRepositoryContext.of(jasperReportsContext));
    }

    public static RendererUtil getInstance(RepositoryContext context) {
        return new RendererUtil(context);
    }

    public boolean isSvgData(byte[] data) {
        SvgDataSniffer.SvgInfo svgInfo = this.getSvgInfo(data);
        return svgInfo != null;
    }

    public SvgDataSniffer.SvgInfo getSvgInfo(byte[] data) {
        String rootElement;
        XmlDataSniffer.XmlSniffResult xmlSniff;
        if (JRTypeSniffer.getImageTypeValue(data) == ImageTypeEnum.UNKNOWN && (xmlSniff = XmlDataSniffer.sniffXml(data)) != null && ((rootElement = xmlSniff.getRootElementName()) == null || this.isSvgRootElement(rootElement))) {
            return this.getSvgDataSniffer().getSvgInfo(data);
        }
        return null;
    }

    protected boolean isSvgRootElement(String rootElementName) {
        return rootElementName.equalsIgnoreCase("svg") || rootElementName.toLowerCase().endsWith(SVG_ROOT_ELEMENT_QNAME_SUFFIX);
    }

    public boolean isSvgData(DataRenderable dataRenderable) throws JRException {
        return this.isSvgData(dataRenderable.getData(this.context.getJasperReportsContext()));
    }

    public SvgDataSniffer getSvgDataSniffer() {
        if (this.svgDataSniffer == null) {
            this.svgDataSniffer = SvgDataSniffer.getInstance(this.context.getJasperReportsContext());
        }
        return this.svgDataSniffer;
    }

    public Renderable getNonLazyRenderable(String resourceLocation, OnErrorTypeEnum onErrorType) throws JRException {
        byte[] data;
        try {
            data = RepositoryUtil.getInstance(this.context).getBytesFromLocation(resourceLocation);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("handled image error with type " + onErrorType + " for location " + resourceLocation, e);
            }
            return this.handleImageError(e, onErrorType);
        }
        return SimpleDataRenderer.getInstance(data);
    }

    public Renderable getRenderable(Image img, OnErrorTypeEnum onErrorType) throws JRException {
        ColorModel colorModel;
        ImageTypeEnum type = ImageTypeEnum.JPEG;
        if (img instanceof RenderedImage && (colorModel = ((RenderedImage)((Object)img)).getColorModel()).hasAlpha() && colorModel.getTransparency() != 1) {
            type = ImageTypeEnum.PNG;
        }
        return this.getRenderable(img, type, onErrorType);
    }

    public Renderable getRenderable(Image image, ImageTypeEnum imageType, OnErrorTypeEnum onErrorType) throws JRException {
        byte[] data = null;
        try {
            data = JRImageLoader.getInstance(this.context.getJasperReportsContext()).loadBytesFromAwtImage(image, imageType);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("handled image error with type " + onErrorType, e);
            }
            return this.handleImageError(e, onErrorType);
        }
        return SimpleDataRenderer.getInstance(data);
    }

    public Renderable getRenderable(byte[] data) {
        return SimpleDataRenderer.getInstance(data);
    }

    public Renderable getRenderable(InputStream is, OnErrorTypeEnum onErrorType) throws JRException {
        byte[] data = null;
        try {
            data = JRLoader.loadBytes(is);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("handled image error with type " + onErrorType, e);
            }
            return this.handleImageError(e, onErrorType);
        }
        return SimpleDataRenderer.getInstance(data);
    }

    public Renderable getRenderable(URL url, OnErrorTypeEnum onErrorType) throws JRException {
        byte[] data = null;
        try {
            data = JRLoader.loadBytes(url);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("handled image error with type " + onErrorType + " for URL " + url, e);
            }
            return this.handleImageError(e, onErrorType);
        }
        return SimpleDataRenderer.getInstance(data);
    }

    public Renderable getRenderable(File file, OnErrorTypeEnum onErrorType) throws JRException {
        byte[] data = null;
        try {
            data = JRLoader.loadBytes(file);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("handled image error with type " + onErrorType + " for file " + file, e);
            }
            return this.handleImageError(e, onErrorType);
        }
        return SimpleDataRenderer.getInstance(data);
    }

    public Renderable handleImageError(Exception error, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable errorRenderable;
        if (error instanceof JRException) {
            errorRenderable = this.getOnErrorRenderer(onErrorType, (JRException)error);
        } else if (error instanceof JRRuntimeException) {
            errorRenderable = this.getOnErrorRenderer(onErrorType, (JRRuntimeException)error);
        } else {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (log.isDebugEnabled()) {
                log.debug("got unexpected image exception of type " + error.getClass().getName(), error);
            }
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_IMAGE_ERROR, null, error);
        }
        return errorRenderable;
    }

    public Renderable getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRException e) throws JRException {
        Renderable renderer = null;
        switch (onErrorType) {
            case ICON: {
                renderer = NO_IMAGE_RENDERER;
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                throw e;
            }
        }
        return renderer;
    }

    public Renderable getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRRuntimeException e) throws JRRuntimeException {
        Renderable renderer = null;
        switch (onErrorType) {
            case ICON: {
                renderer = NO_IMAGE_RENDERER;
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                throw e;
            }
        }
        return renderer;
    }

    public static boolean isLazy(Renderable renderer) {
        Class<JRImageRenderer> depClass;
        boolean isLazy = false;
        if (renderer instanceof ResourceRenderer) {
            isLazy = ((ResourceRenderer)renderer).isLazy();
        } else if (renderer != null && (depClass = JRImageRenderer.class).equals(renderer.getClass())) {
            JRImageRenderer depRenderer = (JRImageRenderer)renderer;
            String depImageLocation = depRenderer.getImageLocation();
            isLazy = depImageLocation != null;
        }
        return isLazy;
    }

    public static String getResourceLocation(Renderable renderer) {
        Class<JRImageRenderer> depClass;
        String resourceLocation = null;
        if (renderer instanceof ResourceRenderer) {
            resourceLocation = ((ResourceRenderer)renderer).getResourceLocation();
        } else if (renderer != null && (depClass = JRImageRenderer.class).equals(renderer.getClass())) {
            String depImageLocation;
            JRImageRenderer depRenderer = (JRImageRenderer)renderer;
            resourceLocation = depImageLocation = depRenderer.getImageLocation();
        }
        return resourceLocation;
    }

    public DataRenderable getDataRenderable(Renderable renderer, Dimension dimension, Color backcolor) throws JRException {
        DataRenderable imageRenderer = null;
        if (renderer != null) {
            if (renderer instanceof DataRenderable) {
                imageRenderer = (DataRenderable)((Object)renderer);
            } else {
                Graphics2DRenderable grxRenderer = null;
                if (!(renderer instanceof Graphics2DRenderable)) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_RENDERABLE_MUST_IMPLEMENT_INTERFACE, renderer.getClass().getName(), DataRenderable.class.getName() + " or " + Graphics2DRenderable.class.getName());
                }
                grxRenderer = (Graphics2DRenderable)((Object)renderer);
                imageRenderer = new WrappingRenderToImageDataRenderer(grxRenderer, dimension, backcolor);
            }
        }
        return imageRenderer;
    }

    public DataRenderable getImageDataRenderable(RenderersCache renderersCache, Renderable renderer, Dimension dimension, Color backcolor) throws JRException {
        DataRenderable imageRenderer = null;
        if (renderer != null) {
            if (renderer instanceof DataRenderable) {
                boolean isSvgData = this.isSvgData((DataRenderable)((Object)renderer));
                imageRenderer = isSvgData ? new WrappingRenderToImageDataRenderer((Graphics2DRenderable)((Object)renderersCache.getWrappingRenderable(renderer.getId(), (DataRenderable)((Object)renderer))), dimension, backcolor) : (DataRenderable)((Object)renderer);
            } else {
                Graphics2DRenderable grxRenderer = null;
                if (!(renderer instanceof Graphics2DRenderable)) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_RENDERABLE_MUST_IMPLEMENT_INTERFACE, renderer.getClass().getName(), DataRenderable.class.getName() + " or " + Graphics2DRenderable.class.getName());
                }
                grxRenderer = (Graphics2DRenderable)((Object)renderer);
                imageRenderer = new WrappingRenderToImageDataRenderer(grxRenderer, dimension, backcolor);
            }
        }
        return imageRenderer;
    }
}

