/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.ResourceInfo;
import net.sf.jasperreports.repo.SimpleRepositoryContext;

public final class RepositoryUtil {
    public static final String EXCEPTION_MESSAGE_KEY_BYTE_DATA_LOADING_ERROR = "repo.byte.data.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_BYTE_DATA_NOT_FOUND = "repo.byte.data.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_INPUT_STREAM_NOT_FOUND = "repo.input.stream.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_NOT_FOUND = "repo.report.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_RESOURCET_NOT_FOUND = "repo.resource.not.found";
    private AtomicReference<List<RepositoryService>> repositoryServices = new AtomicReference();
    private RepositoryContext context;

    private RepositoryUtil(RepositoryContext context) {
        this.context = context;
    }

    public static RepositoryUtil getInstance(JasperReportsContext jasperReportsContext) {
        return RepositoryUtil.getInstance(SimpleRepositoryContext.of(jasperReportsContext));
    }

    public static RepositoryUtil getInstance(RepositoryContext repositoryContext) {
        return new RepositoryUtil(repositoryContext);
    }

    private List<RepositoryService> getServices() {
        List<RepositoryService> cachedServices = this.repositoryServices.get();
        if (cachedServices != null) {
            return cachedServices;
        }
        List<RepositoryService> services = this.context.getJasperReportsContext().getExtensions(RepositoryService.class);
        if (this.repositoryServices.compareAndSet(null, services)) {
            return services;
        }
        return this.repositoryServices.get();
    }

    public JasperReport getReport(ReportContext reportContext, String location) throws JRException {
        JasperReport jasperReport = null;
        JasperDesignCache cache = JasperDesignCache.getInstance(this.context.getJasperReportsContext(), reportContext);
        if (cache != null) {
            jasperReport = cache.getJasperReport(location);
        }
        if (jasperReport == null) {
            ReportResource resource = this.getResourceFromLocation(location, ReportResource.class);
            if (resource == null) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_NOT_FOUND, location);
            }
            jasperReport = resource.getReport();
            if (cache != null) {
                cache.set(location, jasperReport);
            }
        }
        return jasperReport;
    }

    public <K extends Resource> K getResourceFromLocation(String location, Class<K> resourceType) throws JRException {
        K resource = null;
        List<RepositoryService> services = this.getServices();
        if (services != null) {
            RepositoryService service;
            Iterator<RepositoryService> iterator = services.iterator();
            while (iterator.hasNext() && (resource = (K)(service = iterator.next()).getResource(this.context, location, resourceType)) == null) {
            }
        }
        if (resource == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_RESOURCET_NOT_FOUND, location);
        }
        return resource;
    }

    public InputStream getInputStreamFromLocation(String location) throws JRException {
        InputStream is = this.findInputStream(location);
        if (is == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_INPUT_STREAM_NOT_FOUND, location);
        }
        return is;
    }

    private InputStream findInputStream(String location) throws JRException {
        InputStreamResource inputStreamResource;
        block1: {
            RepositoryService service;
            inputStreamResource = null;
            List<RepositoryService> services = this.getServices();
            if (services == null) break block1;
            Iterator<RepositoryService> iterator = services.iterator();
            while (iterator.hasNext() && (inputStreamResource = (service = iterator.next()).getResource(this.context, location, InputStreamResource.class)) == null) {
            }
        }
        return inputStreamResource == null ? null : inputStreamResource.getInputStream();
    }

    public byte[] getBytesFromLocation(String location) throws JRException {
        InputStream is = this.findInputStream(location);
        if (is == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_BYTE_DATA_NOT_FOUND, location);
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_BYTE_DATA_LOADING_ERROR, new Object[]{location}, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return baos.toByteArray();
    }

    public ResourceInfo getResourceInfo(String location) {
        ResourceInfo resourceInfo;
        block1: {
            RepositoryService service;
            resourceInfo = null;
            List<RepositoryService> services = this.getServices();
            if (services == null) break block1;
            Iterator<RepositoryService> iterator = services.iterator();
            while (iterator.hasNext() && (resourceInfo = (service = iterator.next()).getResourceInfo(this.context, location)) == null) {
            }
        }
        return resourceInfo;
    }

    public RepositoryContext getRepositoryContext() {
        return this.context;
    }
}

