/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.web.util.RequirejsConfigContributor;
import net.sf.jasperreports.web.util.RequirejsModuleMapping;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebRequestContext;
import net.sf.jasperreports.web.util.WebUtil;

public class RequirejsConfigCreator {
    private static final String REQUIREJS_CONFIG_TEMPLATE = "net/sf/jasperreports/web/servlets/resources/templates/RequirejsConfigTemplate.vm";
    private WebRequestContext context;
    private ObjectMapper objectMapper;

    public static RequirejsConfigCreator getInstance(WebRequestContext context) {
        return new RequirejsConfigCreator(context);
    }

    protected RequirejsConfigCreator(WebRequestContext context) {
        this.context = context;
        this.objectMapper = new ObjectMapper();
    }

    public String getRequirejsConfig() {
        JasperReportsContext jrContext = this.context.getJasperReportsContext();
        String contextPath = this.context.getRequestContextPath();
        ObjectNode configRoot = this.objectMapper.createObjectNode();
        configRoot.put("baseUrl", contextPath);
        ObjectNode configPaths = this.objectMapper.createObjectNode();
        configRoot.set("paths", configPaths);
        this.setModuleMappings(jrContext, contextPath, configPaths);
        this.runContributors(jrContext, contextPath, configRoot);
        String requirejsConfig = this.toConfigScript(configRoot);
        return requirejsConfig;
    }

    protected void setModuleMappings(JasperReportsContext jrContext, String contextPath, ObjectNode configPaths) {
        WebUtil webUtil = WebUtil.getInstance(jrContext);
        List<RequirejsModuleMapping> requirejsMappings = jrContext.getExtensions(RequirejsModuleMapping.class);
        for (RequirejsModuleMapping requirejsMapping : requirejsMappings) {
            String modulePath = requirejsMapping.getPath();
            if (requirejsMapping.isClasspathResource()) {
                modulePath = contextPath + webUtil.getResourcesBasePath() + modulePath;
            }
            configPaths.put(requirejsMapping.getName(), modulePath);
        }
    }

    protected void runContributors(JasperReportsContext jrContext, String contextPath, ObjectNode configRoot) {
        List<RequirejsConfigContributor> contributors = jrContext.getExtensions(RequirejsConfigContributor.class);
        for (RequirejsConfigContributor contributor : contributors) {
            contributor.contribute(this.context, configRoot);
        }
    }

    protected String toConfigScript(ObjectNode configRoot) {
        String configString = this.toConfigString(configRoot);
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("config", configString);
        String requirejsConfig = VelocityUtil.processTemplate(REQUIREJS_CONFIG_TEMPLATE, contextMap);
        return requirejsConfig;
    }

    protected String toConfigString(ObjectNode configRoot) {
        CharArrayWriter outWriter = new CharArrayWriter(1024);
        try {
            this.objectMapper.writeValue(outWriter, (Object)configRoot);
        }
        catch (JsonGenerationException e) {
            throw new JRRuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        String configString = outWriter.toString();
        return configString;
    }
}

