/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service;

import br.com.java_brasil.boleto.model.BoletoBanco;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.service.MetodosGenericos;
import br.com.java_brasil.boleto.util.ValidaUtils;
import java.util.List;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;

public class BoletoService
implements MetodosGenericos {
    private final BoletoController controller;

    public BoletoService(@NonNull BoletoBanco banco, @NonNull Configuracao configuracao, boolean valida) {
        if (banco == null) {
            throw new NullPointerException("banco is marked non-null but is null");
        }
        if (configuracao == null) {
            throw new NullPointerException("configuracao is marked non-null but is null");
        }
        if (valida) {
            ValidaUtils.validaConfiguracao(configuracao);
        }
        this.controller = banco.getController();
        this.controller.setConfiguracao(configuracao);
    }

    public BoletoService(@NonNull BoletoBanco banco, @NonNull Configuracao configuracao) {
        if (banco == null) {
            throw new NullPointerException("banco is marked non-null but is null");
        }
        if (configuracao == null) {
            throw new NullPointerException("configuracao is marked non-null but is null");
        }
        ValidaUtils.validaConfiguracao(configuracao);
        this.controller = banco.getController();
        this.controller.setConfiguracao(configuracao);
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.controller.imprimirBoleto(boletoModel);
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        return this.controller.imprimirBoleto(boletos);
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.controller.imprimirBoletoByte(boletoModel);
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.controller.imprimirBoletoByte(boletoModel);
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.controller.imprimirBoletoBanco(boletoModel);
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        this.controller.imprimirBoletoJasperDesktop(boletoModel, diretoImpressora, printService);
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        ValidaUtils.validaBoletoModel(boletoModel, this.controller.getConfiguracao().camposObrigatoriosBoleto());
        return this.controller.enviarBoleto(boletoModel);
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        ValidaUtils.validaBoletoModel(boletoModel, this.controller.getConfiguracao().camposObrigatoriosBoleto());
        return this.controller.alterarBoleto(boletoModel);
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.controller.consultarBoleto(boletoModel);
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.controller.baixarBoleto(boletoModel);
    }

    public Configuracao getConfiguracao() {
        return this.controller.getConfiguracao();
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        return this.controller.gerarArquivoRemessa(remessaRetornoModel);
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        return this.controller.importarArquivoRetorno(arquivo);
    }
}

