/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.asaas_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.service.bancos.asaas_api.BaseResponse;
import br.com.java_brasil.boleto.service.bancos.asaas_api.ConfiguracaoAsaasAPI;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.BoletoAsaasModelConverter;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.Customer;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.CustomerResponse;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.IdentificationFieldResponse;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.ListCustomerResponse;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.Payment;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.PaymentResponse;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.QrCodeResponse;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.ReceiveInCash;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;

public class BancoAsaasAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger(BancoAsaasAPI.class.getName());

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco em modelo API.");
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco em modelo API.");
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco em modelo API.");
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco em modelo API.");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco em modelo API.");
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            BoletoModel consultarBoleto = this.consultarBoleto(boletoModel);
            return BoletoUtil.downloadFile(consultarBoleto.getUrlPdf());
        }
        catch (IOException ex) {
            throw new BoletoException("Erro ao fazer download de boleto do banco", ex);
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoAsaasAPI configuracao = this.getConfiguracaoAsaas();
            Optional.ofNullable(boletoModel.getPagador().getCodigoNoBanco()).filter(StringUtils::isNotEmpty).orElseGet(() -> {
                this.consultaDadosPagador(boletoModel, configuracao);
                return boletoModel.getPagador().getCodigoNoBanco();
            });
            Payment payment = BoletoAsaasModelConverter.montaBoletoRequest(boletoModel);
            String json = this.logAndConvertToJson("Json Envio Boleto: ", payment);
            Header[] headers = this.buildHeaders(configuracao.getToken());
            CloseableHttpResponse response = RestUtil.post(configuracao.urlBase() + configuracao.getUrlCriarCobranca(), headers, json);
            String retorno = this.logAndReturnBody("Retorno Envio Boleto: ", response);
            PaymentResponse boletoResponse = RestUtil.JsonToObject(retorno, PaymentResponse.class);
            this.validarResponse(boletoResponse, "Erro ao enviar boleto");
            BoletoAsaasModelConverter.montaBoletoResponse(boletoModel, boletoResponse);
            if (configuracao.isConsultarLinhaDigitavelNoEnvio()) {
                log.info("Obtendo linha digitavel");
                this.obterLinhaDigitavel(boletoModel, configuracao);
            }
            if (configuracao.isConsultarQrCodePixNoEnvio()) {
                log.info("Obtendo QrCode Pix");
                this.obterQrCode(boletoModel, configuracao);
            }
            return boletoModel;
        }
        catch (Exception e) {
            throw new BoletoException(this.tratarErro(e, boletoModel), e);
        }
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoAsaasAPI configuracao = this.getConfiguracaoAsaas();
            Optional.ofNullable(boletoModel.getPagador().getCodigoNoBanco()).filter(StringUtils::isNotEmpty).orElseGet(() -> {
                this.consultaDadosPagador(boletoModel, configuracao);
                return boletoModel.getPagador().getCodigoNoBanco();
            });
            Payment payment = BoletoAsaasModelConverter.montaBoletoRequest(boletoModel);
            String json = this.logAndConvertToJson("Json Atualizar Boleto: ", payment);
            String url = configuracao.urlBase() + configuracao.getUrlServicoCobranca() + "/" + boletoModel.getNossoNumero();
            Header[] headers = this.buildHeaders(configuracao.getToken());
            CloseableHttpResponse response = RestUtil.put(url, headers, json);
            String retorno = this.logAndReturnBody("Retorno Atualizar Boleto: ", response);
            PaymentResponse boletoResponse = RestUtil.JsonToObject(retorno, PaymentResponse.class);
            this.validarResponse(boletoResponse, "Erro ao enviar boleto");
            BoletoAsaasModelConverter.montaBoletoResponse(boletoModel, boletoResponse);
            return boletoModel;
        }
        catch (Exception e) {
            throw new BoletoException(this.tratarErro(e, boletoModel), e);
        }
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoAsaasAPI configuracao = (ConfiguracaoAsaasAPI)this.getConfiguracao();
            log.config("Iniciando consulta da cobran\u00e7a asaas");
            String parametros = "/" + boletoModel.getNossoNumero();
            HttpGet get = new HttpGet(configuracao.urlBase() + configuracao.getUrlServicoCobranca() + parametros);
            get.setHeader("Content-Type", "application/json");
            get.setHeader("Accept", "application/json");
            get.setHeader((Header)new BasicHeader("access_token", configuracao.getToken()));
            CloseableHttpResponse response = RestUtil.enviaComando((HttpUriRequest)get);
            String json = this.logAndReturnBody("Retorno Consulta Boleto: ", response);
            PaymentResponse consultaResponse = RestUtil.JsonToObject(json, PaymentResponse.class);
            this.validarResponse(consultaResponse, "Erro ao consultar cobranca");
            BoletoAsaasModelConverter.montaBoletoResponse(boletoModel, consultaResponse);
            return boletoModel;
        }
        catch (Exception e) {
            throw new BoletoException(this.tratarErro(e, boletoModel), e);
        }
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            ConfiguracaoAsaasAPI configuracao = this.getConfiguracaoAsaas();
            Optional.ofNullable(boletoModel.getPagador().getCodigoNoBanco()).filter(StringUtils::isNotEmpty).orElseGet(() -> {
                this.consultaDadosPagador(boletoModel, configuracao);
                return boletoModel.getPagador().getCodigoNoBanco();
            });
            String url = configuracao.urlBase() + configuracao.getUrlCriarCobranca() + "/" + boletoModel.getNossoNumero() + "/receiveInCash";
            ReceiveInCash receiveInCash = new ReceiveInCash();
            receiveInCash.toDTO(boletoModel);
            String json = this.logAndConvertToJson("Json Envio Baixa do Boleto em Dinheiro: ", receiveInCash);
            Header[] headers = this.buildHeaders(configuracao.getToken());
            CloseableHttpResponse response = RestUtil.post(url, headers, json);
            String retorno = this.logAndReturnBody("Retorno Envio Baixa de Boleto: ", response);
            PaymentResponse boletoResponse = RestUtil.JsonToObject(retorno, PaymentResponse.class);
            this.validarResponse(boletoResponse, "Erro ao enviar Baixa de  boleto");
            BoletoAsaasModelConverter.montaBoletoResponse(boletoModel, boletoResponse);
            return boletoModel;
        }
        catch (Exception e) {
            throw new BoletoException(this.tratarErro(e, boletoModel), e);
        }
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco em modelo API.");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        return Collections.emptyList();
    }

    private ConfiguracaoAsaasAPI getConfiguracaoAsaas() {
        return (ConfiguracaoAsaasAPI)this.getConfiguracao();
    }

    private String tratarErro(Exception e, BoletoModel boletoModel) {
        String msg = Optional.ofNullable(e.getMessage()).orElse("");
        Map<String, String> errosMap = this.buildErrosMap(boletoModel.getNossoNumero());
        return errosMap.entrySet().stream().filter(entry -> msg.contains((CharSequence)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse("Erro n\u00e3o mapeado pela integra\u00e7\u00e3o. Retorno da API: " + msg);
    }

    private Map<String, String> buildErrosMap(String nossoNumero) {
        LinkedHashMap<String, String> errosMap = new LinkedHashMap<String, String>();
        errosMap.put("Invalid user credentials", "Credenciais inv\u00e1lidas. Verifique username/password/context.");
        errosMap.put("Missing parameter: username", "Par\u00e2metro 'username' n\u00e3o informado.");
        errosMap.put("Could not find a required Access Token", "Token de acesso (x-api-key) n\u00e3o informado ou inv\u00e1lido.");
        errosMap.put("UNAUTHORIZED", "Token de autoriza\u00e7\u00e3o inv\u00e1lido ou n\u00e3o informado.");
        errosMap.put("codigoBeneficiario", "C\u00f3digo de benefici\u00e1rio informado \u00e9 diferente do usu\u00e1rio autenticado.");
        errosMap.put("Cooperativa", "Cooperativa informada \u00e9 diferente da cooperativa do usu\u00e1rio.");
        errosMap.put("400", "Erro de requisi\u00e7\u00e3o: verifique os par\u00e2metros obrigat\u00f3rios.");
        errosMap.put("nossoNumero", "Erro ao baixar boleto, t\u00edtulo com nosso n\u00famero [ " + nossoNumero + " ] n\u00e3o encontrado.");
        errosMap.put("Campo obrigat\u00f3rio em branco", "Par\u00e2metro obrigat\u00f3rio n\u00e3o informado.");
        errosMap.put("grant_type", "Par\u00e2metro 'grant_type' n\u00e3o informado ou inv\u00e1lido.");
        errosMap.put("Content-Type", "Tipo de conte\u00fado inv\u00e1lido. Use 'application/json'.");
        errosMap.put("dataVencimento", "Data de vencimento obrigat\u00f3ria ou inv\u00e1lida.");
        errosMap.put("diasProtestoAuto", "O campo 'diasProtestoAuto' deve estar entre 3 e 99 dias.");
        errosMap.put("juros", "Valor de juros inv\u00e1lido. Deve ser maior que zero e menor que o valor do t\u00edtulo.");
        errosMap.put("multa", "Valor de multa inv\u00e1lido. Deve ser maior que zero.");
        errosMap.put("valorDesconto", "Valor de desconto inv\u00e1lido. Deve ser maior que zero e menor que o valor do t\u00edtulo.");
        errosMap.put("documento", "Documento do pagador/benefici\u00e1rio inv\u00e1lido (CPF/CNPJ).");
        errosMap.put("404", "Recurso n\u00e3o encontrado. Verifique a URL utilizada.");
        errosMap.put("415", "Tipo de conte\u00fado n\u00e3o suportado. Use 'application/json'.");
        errosMap.put("aguardando confirma\u00e7\u00e3o", "T\u00edtulo aguardando confirma\u00e7\u00e3o. Opera\u00e7\u00e3o n\u00e3o permitida.");
        errosMap.put("rejeitado", "T\u00edtulo rejeitado. Opera\u00e7\u00e3o n\u00e3o permitida.");
        errosMap.put("baixado", "T\u00edtulo j\u00e1 baixado.");
        errosMap.put("liquidado", "T\u00edtulo j\u00e1 liquidado.");
        errosMap.put("fluxo de negativa\u00e7\u00e3o", "T\u00edtulo em negativa\u00e7\u00e3o/protesto.");
        errosMap.put("anterior est\u00e1 em processamento", "J\u00e1 existe uma solicita\u00e7\u00e3o em andamento. Aguarde.");
        errosMap.put("n\u00e3o tem contratado", "Benefici\u00e1rio n\u00e3o possui Cobran\u00e7a Online contratada.");
        errosMap.put("convenio encerrado", "Conv\u00eanio do benefici\u00e1rio est\u00e1 encerrado. Verifique com a cooperativa.");
        errosMap.put("H\u00edbrido n\u00e3o contratado", "Produto h\u00edbrido n\u00e3o habilitado. Solicite habilita\u00e7\u00e3o junto \u00e0 cooperativa.");
        errosMap.put("Documento do pagador n\u00e3o pode ser o mesmo", "CPF/CNPJ do pagador n\u00e3o pode ser igual ao do benefici\u00e1rio.");
        errosMap.put("Documento do benefici\u00e1rio n\u00e3o pode ser o mesmo", "CPF/CNPJ do benefici\u00e1rio n\u00e3o pode ser igual ao do pagador/benefici\u00e1rio final.");
        errosMap.put("Data de vencimento tem que ser posterior", "A data de vencimento deve ser maior ou igual \u00e0 data atual.");
        errosMap.put("Esp\u00e9cie de documento n\u00e3o permite protesto", "A esp\u00e9cie do documento n\u00e3o permite protesto/negativa\u00e7\u00e3o.");
        errosMap.put("N\u00e3o permite juros", "N\u00e3o \u00e9 permitido informar juros ou multa para esp\u00e9cie 'Boleto Proposta'.");
        errosMap.put("Percentual juros deve ser menor que 100%", "Percentual de juros inv\u00e1lido. Deve ser menor que 100%.");
        errosMap.put("Percentual desconto", "Percentual de desconto inv\u00e1lido. Deve ser menor que 100%.");
        errosMap.put("Data de desconto", "Data de desconto inv\u00e1lida (n\u00e3o pode ser menor que a data atual).");
        errosMap.put("429", "Muitas requisi\u00e7\u00f5es em um curto espa\u00e7o de tempo. Aguarde e tente novamente.");
        errosMap.put("504", "Tempo limite excedido. O servi\u00e7o n\u00e3o respondeu no tempo esperado.");
        return errosMap;
    }

    private void consultaDadosPagador(@NonNull BoletoModel boletoModel, ConfiguracaoAsaasAPI configuracao) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            log.config("Iniciando consulta do cliente");
            String parametros = "?cpfCnpj=" + boletoModel.getPagador().getDocumento();
            HttpGet get = new HttpGet(configuracao.urlBase() + configuracao.getUrlConsultaCliente() + parametros);
            get.setHeader("Content-Type", "application/json");
            get.setHeader("Accept", "application/json");
            get.setHeader((Header)new BasicHeader("access_token", configuracao.getToken()));
            CloseableHttpResponse response = RestUtil.enviaComando((HttpUriRequest)get);
            String json = this.logAndReturnBody("Retorno Consulta Boleto: ", response);
            ListCustomerResponse consultaResponse = RestUtil.JsonToObject(json, ListCustomerResponse.class);
            this.validarResponse(consultaResponse, "Erro ao consultar cliente");
            Optional<String> codigoCliente = Optional.ofNullable(consultaResponse.getData()).filter(data -> !data.isEmpty()).map(data -> ((Customer)data.get(0)).getId());
            if (codigoCliente.isPresent()) {
                boletoModel.getPagador().setCodigoNoBanco(codigoCliente.get());
            } else {
                this.cadastrarCliente(boletoModel, configuracao);
            }
        }
        catch (Exception e) {
            throw new BoletoException(this.tratarErro(e, boletoModel), e);
        }
    }

    private void obterLinhaDigitavel(@NonNull BoletoModel boletoModel, ConfiguracaoAsaasAPI configuracao) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            log.config("Iniciando consulta da linha digitavel");
            HttpGet get = new HttpGet(configuracao.urlBase() + configuracao.getUrlServicoCobranca() + "/" + boletoModel.getNossoNumero() + "/identificationField");
            get.setHeader("Content-Type", "application/json");
            get.setHeader("Accept", "application/json");
            get.setHeader((Header)new BasicHeader("access_token", configuracao.getToken()));
            CloseableHttpResponse response = RestUtil.enviaComando((HttpUriRequest)get);
            String json = this.logAndReturnBody("Retorno Consulta Boleto: ", response);
            IdentificationFieldResponse consultaResponse = RestUtil.JsonToObject(json, IdentificationFieldResponse.class);
            this.validarResponse(consultaResponse, "Erro ao consultar linha digit\u00e1vel do boleto");
            Optional.ofNullable(consultaResponse.getIdentificationField()).filter(StringUtils::isNotBlank).ifPresent(boletoModel::setLinhaDigitavel);
        }
        catch (Exception e) {
            throw new BoletoException(this.tratarErro(e, boletoModel), e);
        }
    }

    private void obterQrCode(@NonNull BoletoModel boletoModel, ConfiguracaoAsaasAPI configuracao) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            log.config("Iniciando consulta de QrCode Pix");
            HttpGet get = new HttpGet(configuracao.urlBase() + configuracao.getUrlServicoCobranca() + "/" + boletoModel.getNossoNumero() + "/pixQrCode");
            get.setHeader("Content-Type", "application/json");
            get.setHeader("Accept", "application/json");
            get.setHeader((Header)new BasicHeader("access_token", configuracao.getToken()));
            CloseableHttpResponse response = RestUtil.enviaComando((HttpUriRequest)get);
            String json = this.logAndReturnBody("Retorno Consulta QrCode Pix Boleto: ", response);
            QrCodeResponse consultaResponse = RestUtil.JsonToObject(json, QrCodeResponse.class);
            this.validarResponse(consultaResponse, "Erro ao consultar qr code Pix do boleto");
            Optional.ofNullable(consultaResponse.getPayload()).filter(StringUtils::isNotBlank).ifPresent(payload -> {
                boletoModel.setPixCopiaCola((String)payload);
                boletoModel.setPixBase64(consultaResponse.getEncodedImage());
            });
        }
        catch (Exception e) {
            throw new BoletoException(this.tratarErro(e, boletoModel), e);
        }
    }

    private void cadastrarCliente(@NonNull BoletoModel boletoModel, ConfiguracaoAsaasAPI configuracao) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            Customer customer = new Customer();
            customer.toDTO(boletoModel);
            String json = this.logAndConvertToJson("Json Cadastra Cliente Boleto: ", customer);
            Header[] headers = this.buildHeaders(configuracao.getToken());
            CloseableHttpResponse response = RestUtil.post(configuracao.urlBase() + configuracao.getUrlConsultaCliente(), headers, json);
            String retorno = this.logAndReturnBody("Retorno Cria\u00e7\u00e3o de Cliente AsaaS : ", response);
            CustomerResponse customerResponse = RestUtil.JsonToObject(retorno, CustomerResponse.class);
            this.validarResponse(customerResponse, "Erro ao criar cliente");
            boletoModel.getPagador().setCodigoNoBanco(customerResponse.getId());
        }
        catch (Exception e) {
            throw new BoletoException(this.tratarErro(e, boletoModel), e);
        }
    }

    private Header[] buildHeaders(String token) {
        return new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json"), new BasicHeader("access_token", token)};
    }

    private <T extends BaseResponse> void validarResponse(T response, String mensagemErro) {
        Optional.ofNullable(response).filter(resp -> StringUtils.isEmpty((CharSequence)resp.getCode()) || "200".equals(resp.getCode())).orElseThrow(() -> new BoletoException(String.format("%s, c\u00f3digo erro: %s Mensagem: %s", mensagemErro, response != null ? response.getCode() : "null", response != null ? response.getDescription() : "null")));
    }

    private String logAndConvertToJson(String logPrefix, Object obj) throws JsonProcessingException {
        String json = RestUtil.ObjectToJson(obj);
        log.config(logPrefix + json);
        return json;
    }

    private String logAndReturnBody(String logPrefix, CloseableHttpResponse response) throws IOException {
        String body = RestUtil.validaResponseERetornaBody(response);
        log.config(logPrefix + body);
        return body;
    }
}

