/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.asaas_api;

import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;

public class ConfiguracaoAsaasAPI
implements Configuracao {
    private static final Logger log = Logger.getLogger(ConfiguracaoAsaasAPI.class.getName());
    private static final String urlBaseHomologacao = "https://api-sandbox.asaas.com/v3";
    private static final String urlBaseProducao = "https://api.asaas.com/v3";
    @NotNull
    private String token;
    @NotNull
    private AmbienteEnum ambiente;
    private String urlCriarCobranca = "/lean/payments";
    private String urlConsultaCliente = "/customers";
    private String urlServicoCobranca = "/payments";
    private boolean consultarQrCodePixNoEnvio;
    private boolean consultarLinhaDigitavelNoEnvio;
    private final String arquivoJasper = "BoletoAsaaS";
    private final String logo = "LogoAsaas.png";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    public String urlBase() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? urlBaseProducao : urlBaseHomologacao;
    }

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    @Override
    public InputStream modeloImpressaoBoleto() {
        if (this.modeloImpressaoBoleto == null) {
            try {
                this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoAsaaS.jasper");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
        try {
            this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoCarne.jasper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() {
        Image imageLogo = null;
        try {
            InputStream inputStreamLogo = this.getClass().getResourceAsStream("/logo/LogoAsaas.png");
            imageLogo = new ImageIcon(IOUtils.toByteArray((InputStream)inputStreamLogo)).getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.parametrosImpressaoBoleto.put("LogoBanco", imageLogo);
        this.parametrosImpressaoBoleto.put("REPORT_LOCALE", new Locale("pt", "BR"));
        return this.parametrosImpressaoBoleto;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return Arrays.asList("valor", "dataVencimento", "pagador", "pagador.nome", "pagador.numeroCpfCnpj", "pagador.dd", "pagador.telefone", "pagador.email", "beneficiario.nome");
    }

    @NotNull
    public String getToken() {
        return this.token;
    }

    @NotNull
    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public String getUrlCriarCobranca() {
        return this.urlCriarCobranca;
    }

    public String getUrlConsultaCliente() {
        return this.urlConsultaCliente;
    }

    public String getUrlServicoCobranca() {
        return this.urlServicoCobranca;
    }

    public boolean isConsultarQrCodePixNoEnvio() {
        return this.consultarQrCodePixNoEnvio;
    }

    public boolean isConsultarLinhaDigitavelNoEnvio() {
        return this.consultarLinhaDigitavelNoEnvio;
    }

    public String getArquivoJasper() {
        return this.arquivoJasper;
    }

    public String getLogo() {
        return this.logo;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public void setToken(@NotNull String token) {
        this.token = token;
    }

    public void setAmbiente(@NotNull AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public void setUrlCriarCobranca(String urlCriarCobranca) {
        this.urlCriarCobranca = urlCriarCobranca;
    }

    public void setUrlConsultaCliente(String urlConsultaCliente) {
        this.urlConsultaCliente = urlConsultaCliente;
    }

    public void setUrlServicoCobranca(String urlServicoCobranca) {
        this.urlServicoCobranca = urlServicoCobranca;
    }

    public void setConsultarQrCodePixNoEnvio(boolean consultarQrCodePixNoEnvio) {
        this.consultarQrCodePixNoEnvio = consultarQrCodePixNoEnvio;
    }

    public void setConsultarLinhaDigitavelNoEnvio(boolean consultarLinhaDigitavelNoEnvio) {
        this.consultarLinhaDigitavelNoEnvio = consultarLinhaDigitavelNoEnvio;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

