/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.asaas_api.model;

import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.model.enums.TipoDescontoEnum;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.Discount;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.IdentificationFieldResponse;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.Interest;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.Payment;
import br.com.java_brasil.boleto.service.bancos.asaas_api.model.PaymentResponse;
import br.com.java_brasil.boleto.util.BoletoUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BoletoAsaasModelConverter {
    private static final Map<String, SituacaoEnum> STATUS_SITUACAO_MAP;

    public static BoletoModel montaBoletoLinhaDigitavelResponse(BoletoModel boletoModel, IdentificationFieldResponse response) {
        boletoModel.setLinhaDigitavel(response.getIdentificationField());
        return boletoModel;
    }

    public static void montaBoletoResponse(BoletoModel boletoModel, PaymentResponse boletoResponse) {
        boletoModel.setUrlPdf(boletoResponse.getBankSlipUrl());
        boletoModel.setLinkBoleto(boletoResponse.getInvoiceUrl());
        boletoModel.setNossoNumero(boletoResponse.getId());
        String status = boletoResponse.getStatus();
        SituacaoEnum situacao = Optional.ofNullable(status).map(STATUS_SITUACAO_MAP::get).orElse(SituacaoEnum.EM_ABERTO);
        boletoModel.setSituacao(situacao);
    }

    public static Payment montaBoletoRequest(BoletoModel boletoModel) {
        Payment boleto = new Payment();
        boleto.setCustomer(boletoModel.getPagador().getCodigoNoBanco());
        boleto.setBillingType("BOLETO");
        boleto.setDueDate(BoletoUtil.getDataFormatoYYYYMMDD(boletoModel.getDataVencimento()));
        boleto.setValue(boletoModel.getValorBoleto());
        boleto.setDescription("BOLETO DE COBRANCA");
        boleto.setExternalReference(boletoModel.getNumeroBoleto());
        Optional.ofNullable(boletoModel.getValorDescontos()).filter(BoletoUtil::isNotNullEMaiorQZero).ifPresent(valorDesconto -> {
            Discount discount = new Discount();
            discount.setType(TipoDescontoEnum.VALOR_FIXO.equals((Object)boletoModel.getTipoDesconto()) ? "FIXED" : "PERCENTAGE");
            discount.setValue(TipoDescontoEnum.VALOR_FIXO.equals((Object)boletoModel.getTipoDesconto()) ? boletoModel.getValorDescontos().setScale(1, RoundingMode.CEILING) : Optional.ofNullable(boletoModel.getValorPercentualDescontos()).orElse(BigDecimal.ZERO).setScale(1, RoundingMode.CEILING));
            discount.setDueDateLimitDays(BoletoAsaasModelConverter.diferencaDatas(boletoModel.getDataLimiteParaDesconto(), boletoModel.getDataVencimento()));
            boleto.setDiscount(discount);
        });
        Optional.ofNullable(boletoModel.getValorPercentualJuros()).filter(BoletoUtil::isNotNullEMaiorQZero).ifPresent(valorJuros -> {
            Interest interest = new Interest();
            interest.setValue(valorJuros.setScale(1, RoundingMode.CEILING));
            boleto.setInterest(interest);
        });
        return boleto;
    }

    private static long diferencaDatas(LocalDate dataInicial, LocalDate dataFinal) {
        return dataInicial == null || dataFinal == null ? 0L : ChronoUnit.DAYS.between(dataInicial, dataFinal);
    }

    static {
        HashMap<String, SituacaoEnum> map = new HashMap<String, SituacaoEnum>();
        map.put("PENDING", SituacaoEnum.EM_ABERTO);
        map.put("AWAITING_RISK_ANALYSIS", SituacaoEnum.EM_ABERTO);
        map.put("OVERDUE", SituacaoEnum.EM_ABERTO);
        map.put("CHARGEBACK_DISPUTE", SituacaoEnum.EM_ABERTO);
        map.put("AWAITING_CHARGEBACK_REVERSAL", SituacaoEnum.EM_ABERTO);
        map.put("DUNNING_REQUESTED", SituacaoEnum.EM_ABERTO);
        map.put("RECEIVED_IN_CASH", SituacaoEnum.BAIXADO);
        map.put("REFUND_REQUESTED", SituacaoEnum.BAIXADO);
        map.put("REFUNDED", SituacaoEnum.BAIXADO);
        map.put("CONFIRMED", SituacaoEnum.LIQUIDADO);
        map.put("DUNNING_RECEIVED", SituacaoEnum.LIQUIDADO);
        map.put("RECEIVED", SituacaoEnum.LIQUIDADO);
        STATUS_SITUACAO_MAP = Collections.unmodifiableMap(map);
    }
}

