/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banco_brasil_api;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.EstadoTituloCobrancaBBEnum;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.model.enums.TipoMultaEnum;
import br.com.java_brasil.boleto.service.bancos.banco_brasil_api.ConfiguracaoBancoBrasilAPI;
import br.com.java_brasil.boleto.service.bancos.banco_brasil_api.model.BoletoBancoBrasilAPIRequest;
import br.com.java_brasil.boleto.service.bancos.banco_brasil_api.model.Pagador;
import br.com.java_brasil.boleto.service.bancos.banco_brasil_api.model.response.BoletoBancoBrasilAPICosultaResponse;
import br.com.java_brasil.boleto.service.bancos.banco_brasil_api.model.response.BoletoBancoBrasilAPIResponse;
import br.com.java_brasil.boleto.service.bancos.banco_brasil_cnab240.BancoBrasilUtil;
import br.com.java_brasil.boleto.service.bancos.banrisul_api.BanrisulUtil;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.RestUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintService;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class BancoBrasilAPI
extends BoletoController {
    private static final Logger log = Logger.getLogger("BancoBrasilAPI");

    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            BoletoBancoBrasilAPIRequest boletoBancoBrasilAPIRequest = this.montaBoletoEnvioRequest(boletoModel);
            BoletoBancoBrasilAPIResponse boletoBancoBrasilAPIResponse = this.registraBoleto(boletoBancoBrasilAPIRequest);
            return this.montaEnvioBoletoResponse(boletoModel, boletoBancoBrasilAPIResponse);
        }
        catch (IOException e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            BoletoBancoBrasilAPICosultaResponse boletoBancoBrasilAPIResponse = this.detalhaBoleto(boletoModel);
            return this.montaConsultarBoletoResponse(boletoModel, boletoBancoBrasilAPIResponse);
        }
        catch (IOException e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    public String getToken(ConfiguracaoBancoBrasilAPI configuracao) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/x-www-form-urlencoded"), new BasicHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((configuracao.getClientId() + ":" + configuracao.getClientSecret()).getBytes()))};
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("grant_type", "client_credentials"));
        nvps.add(new BasicNameValuePair("client_id", configuracao.getClientId()));
        nvps.add(new BasicNameValuePair("client_secret", configuracao.getClientSecret()));
        nvps.add(new BasicNameValuePair("scope", "cobrancas.boletos-info cobrancas.boletos-requisicao"));
        HttpPost httpPost = new HttpPost(configuracao.getURLToken());
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        httpPost.setHeaders(headers);
        CloseableHttpResponse response = RestUtil.enviaComando((HttpUriRequest)httpPost);
        String retorno = RestUtil.validaResponseERetornaBody(response);
        log.config("Retorno Token Bradesco: " + retorno);
        JsonObject json = JsonParser.parseString((String)retorno).getAsJsonObject();
        String token = json.get("access_token").getAsString();
        LocalDateTime expires = LocalDateTime.now().plusSeconds(json.get("expires_in").getAsInt());
        log.config("Token Banco do Brasil: " + token);
        log.config("Expira: " + expires);
        return token;
    }

    private BoletoBancoBrasilAPIResponse registraBoleto(BoletoBancoBrasilAPIRequest boletoRequest) throws IOException {
        ConfiguracaoBancoBrasilAPI configuracao = (ConfiguracaoBancoBrasilAPI)this.getConfiguracao();
        String token = this.getToken(configuracao);
        String json = RestUtil.ObjectToJson(boletoRequest);
        log.config("Json envio Banco do Brasil: " + json);
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json;charset=ISO-8859-1"), new BasicHeader("Authorization", "Bearer " + token)};
        StringBuilder urlRequisicao = new StringBuilder();
        urlRequisicao.append(configuracao.getURLBase());
        urlRequisicao.append("/boletos");
        urlRequisicao.append(configuracao.getUrlDevAppKey());
        urlRequisicao.append(configuracao.getDeveloperKey());
        CloseableHttpResponse response = RestUtil.post(urlRequisicao.toString(), headers, json);
        String retorno = RestUtil.validaResponseERetornaBody(response);
        log.config("Retorno envio Banco do Brasil: " + retorno);
        return RestUtil.JsonToObject(retorno, BoletoBancoBrasilAPIResponse.class);
    }

    private BoletoBancoBrasilAPICosultaResponse detalhaBoleto(BoletoModel boletoRequest) throws IOException {
        ConfiguracaoBancoBrasilAPI configuracao = (ConfiguracaoBancoBrasilAPI)this.getConfiguracao();
        String token = this.getToken(configuracao);
        Header[] headers = new Header[]{new BasicHeader("User-Agent", "PostmanRuntime/7.26.8"), new BasicHeader("Content-Type", "application/json;charset=ISO-8859-1"), new BasicHeader("Authorization", "Bearer " + token)};
        StringBuilder urlRequisicao = new StringBuilder();
        urlRequisicao.append(configuracao.getURLBase());
        urlRequisicao.append("/boletos/").append(boletoRequest.getNossoNumero());
        urlRequisicao.append(configuracao.getUrlDevAppKey());
        urlRequisicao.append(configuracao.getDeveloperKey());
        urlRequisicao.append("&numeroConvenio=").append(boletoRequest.getBeneficiario().getNumeroConvenio());
        log.info("Enviando requisi\u00e7\u00e3o para: " + urlRequisicao.toString());
        CloseableHttpResponse response = RestUtil.get(urlRequisicao.toString(), headers);
        String retorno = RestUtil.validaResponseERetornaBody(response);
        return RestUtil.JsonToObject(retorno, BoletoBancoBrasilAPICosultaResponse.class);
    }

    private BoletoBancoBrasilAPIRequest montaBoletoEnvioRequest(BoletoModel boletoModel) {
        return BoletoBancoBrasilAPIRequest.builder().numeroConvenio(Long.valueOf(boletoModel.getBeneficiario().getNumeroConvenio())).numeroCarteira(Integer.valueOf(boletoModel.getBeneficiario().getCarteira())).numeroVariacaoCarteira(Integer.valueOf(boletoModel.getBeneficiario().getVariacaoCarteira())).codigoModalidade(boletoModel.getCodigoModalidade()).dataEmissao(BoletoUtil.getDataFormatoDDMMYYYY(LocalDate.now())).dataVencimento(BoletoUtil.getDataFormatoDDMMYYYY(boletoModel.getDataVencimento())).valorOriginal(boletoModel.getValorBoleto()).valorAbatimento(boletoModel.getValorDescontos()).codigoAceite(boletoModel.isAceite() ? "A" : "N").codigoTipoTituloCobranca(Integer.parseInt(boletoModel.getEspecieDocumento())).indicadorPermissaoRecebimentoParcial(boletoModel.isAutorizaPagamentoParcial() ? "S" : "N").numeroTituloBeneficiario(boletoModel.getNumeroDocumento()).numeroTituloCliente(boletoModel.getNossoNumero()).pagador(Pagador.builder().tipoInscricao(boletoModel.getPagador().isClienteCpf() ? 1 : 2).numeroInscricao(boletoModel.getPagador().getDocumento()).nome(boletoModel.getPagador().getNome()).cep(Integer.valueOf(boletoModel.getPagador().getEndereco().getCep())).cidade(boletoModel.getPagador().getEndereco().getCidade()).bairro(boletoModel.getPagador().getEndereco().getBairro()).uf(boletoModel.getPagador().getEndereco().getUf()).build()).build();
    }

    private BoletoModel montaEnvioBoletoResponse(BoletoModel boletoModel, BoletoBancoBrasilAPIResponse response) {
        boletoModel.getPagador().setCodigo(String.valueOf(response.getCodigoCliente()));
        boletoModel.setLinhaDigitavel(response.getLinhaDigitavel());
        boletoModel.setCodigoBarras(response.getCodigoBarraNumerico());
        return boletoModel;
    }

    private BoletoModel montaConsultarBoletoResponse(BoletoModel boletoModel, BoletoBancoBrasilAPICosultaResponse response) {
        boletoModel.setLinhaDigitavel(response.getCodigoLinhaDigitavel());
        boletoModel.setCodigoBarras(response.getTextoCodigoBarrasTituloCobranca());
        switch (response.getCodigoTipoMulta()) {
            case 1: {
                boletoModel.setTipoMulta(TipoMultaEnum.VALOR);
                break;
            }
            case 2: {
                boletoModel.setTipoMulta(TipoMultaEnum.PERCENTUAL);
                break;
            }
            default: {
                boletoModel.setTipoMulta(TipoMultaEnum.ISENTO);
            }
        }
        boletoModel.setValorMulta(response.getValorMultaTituloCobranca());
        switch (response.getCodigoEstadoTituloCobranca()) {
            case 6: {
                boletoModel.setSituacao(SituacaoEnum.LIQUIDADO);
                break;
            }
            case 7: {
                boletoModel.setSituacao(SituacaoEnum.BAIXADO);
                break;
            }
            default: {
                boletoModel.setSituacao(SituacaoEnum.EM_ABERTO);
            }
        }
        boletoModel.setEstadoTituloCobrancaBB(EstadoTituloCobrancaBBEnum.valueOf(response.getCodigoEstadoTituloCobranca()));
        boletoModel.setCodigoModalidade(response.getCodigoModalidadeTitulo());
        boletoModel.setDataVencimento(BoletoUtil.formataStringPadraoDDMMYYParaLocalDate(response.getDataVencimentoTituloCobranca()));
        boletoModel.setAceite("A".equals(response.getCodigoAceiteTituloCobranca()));
        return boletoModel;
    }

    private void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        StringBuilder codigoBarras = new StringBuilder();
        codigoBarras.append("0019");
        codigoBarras.append("X");
        codigoBarras.append(BanrisulUtil.fatorData(boletoModel.getDataVencimento()));
        codigoBarras.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        StringBuilder campoLivre = new StringBuilder();
        Integer numeroConvenio = Integer.parseInt(boletoModel.getBeneficiario().getNumeroConvenio());
        if (numeroConvenio.compareTo(9999) <= 0) {
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getNumeroConvenio(), 4, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getNossoNumero(), 7, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getAgencia(), 4, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getConta(), 8, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getCarteira(), 2, "0"));
        } else if (numeroConvenio.compareTo(9999) > 0 && numeroConvenio.compareTo(999999) <= 0) {
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getNumeroConvenio(), 6, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getNossoNumero(), 5, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getAgencia(), 4, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getConta(), 8, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getCarteira(), 2, "0"));
        } else {
            campoLivre.append("000000");
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getNumeroConvenio(), 7, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getNossoNumero(), 10, "0"));
            campoLivre.append(BoletoUtil.leftPad(boletoModel.getBeneficiario().getCarteira(), 2, "0"));
        }
        codigoBarras.append((CharSequence)campoLivre);
        String dvCodigoBarras = BancoBrasilUtil.modulo11BB(codigoBarras.toString().replace("X", ""));
        boletoModel.setLinhaDigitavel(codigoBarras.toString().replace("X", dvCodigoBarras));
        boletoModel.setCodigoBarras(codigoBarras.toString().replace("X", dvCodigoBarras));
        StringBuilder linhaParte1 = new StringBuilder();
        linhaParte1.append(boletoModel.getLinhaDigitavel(), 0, 4);
        linhaParte1.append(boletoModel.getLinhaDigitavel(), 19, 21);
        linhaParte1.append(boletoModel.getLinhaDigitavel(), 21, 24);
        linhaParte1.append(BancoBrasilUtil.modulo10BB(linhaParte1.toString()));
        StringBuilder linhaParte2 = new StringBuilder();
        linhaParte2.append(boletoModel.getLinhaDigitavel(), 24, 34);
        linhaParte2.append(BancoBrasilUtil.modulo10BB(linhaParte2.toString()));
        StringBuilder linhaParte3 = new StringBuilder();
        linhaParte3.append(boletoModel.getLinhaDigitavel(), 34, 44);
        linhaParte3.append(BancoBrasilUtil.modulo10BB(linhaParte3.toString()));
        StringBuilder linhaParte4 = new StringBuilder();
        linhaParte4.append(boletoModel.getLinhaDigitavel().charAt(4));
        linhaParte4.append(boletoModel.getLinhaDigitavel(), 5, 9);
        linhaParte4.append(boletoModel.getLinhaDigitavel(), 9, 19);
        StringBuilder linhaDigitavel = new StringBuilder();
        linhaDigitavel.append(linhaParte1.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte1.toString(), 5, 10);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte2.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte2.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte3.toString(), 0, 5);
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte3.toString(), 5, 11);
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte4.toString().charAt(0));
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte4.toString(), 1, 15);
        boletoModel.setLinhaDigitavel(linhaDigitavel.toString());
        this.validaDadosImpressao(boletoModel);
    }

    private void validaDadosImpressao(BoletoModel boleto) {
        ValidaUtils.validaBoletoModel(boleto, Arrays.asList("locaisDePagamento", "dataVencimento", "dataEmissao", "numeroDocumento", "especieDocumento", "aceite", "especieMoeda", "valorBoleto", "linhaDigitavel", "codigoBarras", "nossoNumero", "beneficiario", "beneficiario.nomeBeneficiario", "beneficiario.documento", "beneficiario.agencia", "beneficiario.digitoConta", "beneficiario.conta", "beneficiario.carteira", "beneficiario.variacaoCarteira", "beneficiario.endereco", "beneficiario.endereco.logradouro", "beneficiario.endereco.numero", "beneficiario.endereco.bairro", "beneficiario.endereco.cidade", "beneficiario.endereco.uf", "beneficiario.endereco.cep", "pagador", "pagador.nome", "pagador.documento", "pagador.endereco.logradouro", "pagador.endereco.cep", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf"));
    }
}

